/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.api.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.shr.base.syssetting.api.bean.SHRCodingRule;
import com.kingdee.shr.base.syssetting.api.codingrule.ShrCodeRuleAdaptConfig;
import com.kingdee.shr.base.syssetting.util.BaseMetaDataUtil;
import com.kingdee.util.StringUtils;

public abstract class SHRCodingRuleApi {
    public static final String NUMBER = "number";
    public static final int DUMP_MAX_COUNT = 1000;

    public static void codingNumber(Context ctx, IObjectValue model, IObjectValue numberFromModel, String mainOrgID) throws BOSException, EASBizException {
        if (!SHRCodingRuleApi.hasCodingRule(ctx, numberFromModel, mainOrgID)) {
            return;
        }
        String propertyName = SHRCodingRuleApi.getCodingRuleProperty(numberFromModel.getBOSType().toString());
        ICoreBase iCoreBase = BaseMetaDataUtil.getBizInterface(ctx, numberFromModel.getBOSType());
        FilterInfo filter = new FilterInfo();
        String number = model.getString(propertyName);
        filter.getFilterItems().add(new FilterItemInfo(propertyName, (Object)number, CompareType.EQUALS));
        if (!iCoreBase.exists(filter)) {
            return;
        }
        SHRCodingRule shrCodingRule = SHRCodingRuleApi.getCodingNumber(ctx, numberFromModel, mainOrgID);
        SHRCodingRuleApi.setValue(model, shrCodingRule);
    }

    protected static void setValue(IObjectValue model, SHRCodingRule shrCodingRule) {
        String number;
        if (shrCodingRule.isExist() && (StringUtils.isEmpty((String)(number = model.getString(shrCodingRule.getPropertyName()))) || !number.equals(shrCodingRule.getCodingRuleNumber()))) {
            model.put(shrCodingRule.getPropertyName(), (Object)shrCodingRule.getCodingRuleNumber());
        }
    }

    public static SHRCodingRule getCodingNumber(Context ctx, IObjectValue numberFromModel, String mainOrgID) throws BOSException, EASBizException {
        String realOrgId = mainOrgID;
        realOrgId = StringUtils.isEmpty((String)mainOrgID) ? SHRCodingRuleApi.getNextCompanyId(ctx) : SHRCodingRuleApi.getRealOrgId(ctx, numberFromModel, mainOrgID);
        SHRCodingRule shrCodingRule = new SHRCodingRule();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String number = null;
        String propertyName = SHRCodingRuleApi.getCodingRuleProperty(numberFromModel.getBOSType().toString());
        RuleStatus ruleStatus = iCodingRuleManager.getRuleStatus(numberFromModel, realOrgId);
        shrCodingRule.setExist(ruleStatus.isExist());
        shrCodingRule.setPropertyName(propertyName);
        if (ruleStatus.isExist()) {
            number = iCodingRuleManager.readNumber(numberFromModel, realOrgId);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo(propertyName, (Object)number, CompareType.EQUALS));
            ICoreBase iCoreBase = BaseMetaDataUtil.getBizInterface(ctx, numberFromModel.getBOSType());
            int count = 0;
            while (iCoreBase.exists(filter)) {
                if (ruleStatus.isAddNoBreak()) {
                    number = iCodingRuleManager.getNonbreakNumber(numberFromModel, realOrgId);
                } else {
                    number = iCodingRuleManager.getNumber(numberFromModel, realOrgId);
                    number = iCodingRuleManager.readNumber(numberFromModel, realOrgId);
                }
                if (count >= 1000) break;
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo(propertyName, (Object)number, CompareType.EQUALS));
                ++count;
            }
            shrCodingRule.setAddNoBreak(ruleStatus.isAddNoBreak());
            shrCodingRule.setAddView(ruleStatus.isAddView());
            shrCodingRule.setModifiable(ruleStatus.isModifiable());
            shrCodingRule.setUseIntermitNumber(ruleStatus.isUseIntermitNumber());
            shrCodingRule.setUserSelect(ruleStatus.isUserSelect());
            shrCodingRule.setCodingRuleNumber(number);
        }
        return shrCodingRule;
    }

    private static String getRealOrgId(Context ctx, IObjectValue numberFromModel, String mainOrgID) {
        EntityObjectInfo entityObjectInfo = BaseMetaDataUtil.getEntityObjectInfo(ctx, numberFromModel.getBOSType());
        String extendPropertyOrgType = entityObjectInfo.getExtendedProperty("OrgType");
        String realOrgId = null;
        if (StringUtils.isEmpty((String)extendPropertyOrgType)) {
            return mainOrgID;
        }
        if ("ControlUnit".equals(extendPropertyOrgType)) {
            try {
                FullOrgUnitInfo full = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(mainOrgID));
                realOrgId = null != full ? full.getCU().getId().toString() : mainOrgID;
            }
            catch (EASBizException e) {
                e.printStackTrace();
                realOrgId = mainOrgID;
            }
            catch (BOSException e) {
                e.printStackTrace();
                realOrgId = mainOrgID;
            }
            return realOrgId;
        }
        return mainOrgID;
    }

    public static String getCodingRuleProperty(String bosType) {
        String number = ShrCodeRuleAdaptConfig.getInstance().getCodingRuleAdaptConfig(bosType);
        if (StringUtils.isEmpty((String)number)) {
            number = NUMBER;
        }
        return number;
    }

    public static boolean hasCodingRule(Context ctx, IObjectValue model, String orgId) {
        try {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            String realOrgId = orgId;
            realOrgId = StringUtils.isEmpty((String)orgId) ? SHRCodingRuleApi.getNextCompanyId(ctx) : SHRCodingRuleApi.getRealOrgId(ctx, model, orgId);
            if (iCodingRuleManager.isExist(model, realOrgId)) {
                return true;
            }
        }
        catch (Exception err) {
            err.printStackTrace();
            return false;
        }
        return false;
    }

    protected static String getNextCompanyId(Context ctx) throws BOSException, EASBizException {
        OrgUnitInfo mainOrg = (OrgUnitInfo)ctx.get((Object)OrgType.ControlUnit);
        if (null == mainOrg || StringUtils.isEmpty((String)mainOrg.getString("id"))) {
            return "00000000-0000-0000-0000-000000000000CCE7AED4";
        }
        return mainOrg.getString("id");
    }

    public static void setNumberFromCodingRule(Context ctx, IObjectValue numberFromModel, String orgId) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (orgId == null || orgId.trim().length() == 0) {
            orgId = SHRCodingRuleApi.getNextCompanyId(ctx);
        }
        if (orgId == null || orgId.trim().length() == 0) {
            return;
        }
        String propertyName = SHRCodingRuleApi.getCodingRuleProperty(numberFromModel.getBOSType().toString());
        RuleStatus ruleStatus = iCodingRuleManager.getRuleStatus(numberFromModel, orgId);
        if (ruleStatus.isExist()) {
            if (ruleStatus.isModifiable()) {
                if (StringUtils.isEmpty((String)String.valueOf(numberFromModel.get(propertyName)))) {
                    numberFromModel.put(propertyName, (Object)iCodingRuleManager.getNumber(numberFromModel, orgId));
                }
            } else {
                numberFromModel.put(propertyName, (Object)iCodingRuleManager.getNumber(numberFromModel, orgId));
            }
        }
    }
}

