/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.fieldrule.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.ICommonBOSType;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.syssetting.FieldRuleException;
import com.kingdee.shr.base.syssetting.fieldrule.FieldRuleUtils;
import com.kingdee.shr.base.syssetting.fieldrule.formula.ParserException;
import com.kingdee.shr.base.syssetting.fieldrule.formula.parse.FieldRuleInterpreter;
import com.kingdee.shr.base.syssetting.fieldrule.formula.parse.FieldRuleScriptParser;
import com.kingdee.shr.base.syssetting.fieldrule.formula.parse.Lexer;
import com.kingdee.shr.base.syssetting.fieldrule.formula.parse.TokenList;
import com.kingdee.shr.base.syssetting.fieldrule.formula.runtime.InterpreterException;
import com.kingdee.shr.base.syssetting.fieldrule.model.type.Type;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldRuleFormulaEngine {
    private static final Logger logger = LoggerFactory.getLogger(FieldRuleFormulaEngine.class);
    private static Map<String, FieldRuleScriptParser> parsedFormula = new HashMap<String, FieldRuleScriptParser>();
    private static final Pattern PATTERN_VARIABLE_COMMENT = Pattern.compile("//\\s*\\{([^}]+)\\}");
    public static final String MAIN_KEY = "Main#";

    private FieldRuleFormulaEngine() {
    }

    public static FieldRuleScriptParser parseFormulaStr(Context ctx, String formulaStr) throws EASBizException, BOSException {
        if (logger.isDebugEnabled()) {
            logger.debug("ParseFormulaStr param formulaStr is: {}", (Object)formulaStr);
        }
        if (formulaStr == null) {
            return null;
        }
        FieldRuleScriptParser oldParser = parsedFormula.get(formulaStr);
        if (logger.isDebugEnabled()) {
            logger.debug("ParseFormulaStr oldParser is: {}", (Object)oldParser);
        }
        if (oldParser != null) {
            return oldParser;
        }
        Lexer lexer = new Lexer(formulaStr);
        TokenList tokList = new TokenList(lexer);
        FieldRuleScriptParser parser = new FieldRuleScriptParser(tokList);
        try {
            parser.parse();
        }
        catch (Exception arg5) {
            logger.error(arg5.getMessage());
            throw new FieldRuleException(FieldRuleException.ERROR_FIELDRULE_FORMULA_ONE);
        }
        parsedFormula.put(formulaStr, parser);
        return parser;
    }

    public static Map<String, Object> parseFormulaVariable(Context ctx, String input) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        try {
            if (StringUtils.isEmpty((String)input)) {
                return vars;
            }
            Matcher matcher = PATTERN_VARIABLE_COMMENT.matcher(input);
            while (matcher.find()) {
                IObjectValue coreBaseInfo;
                String text = matcher.group(1);
                String[] params = text.split("\\|");
                if (params.length != 3) {
                    throw new ParserException("0", input, SHRServerResource.getString("com.kingdee.shr.base.syssetting.fieldrule.formula.function.FormulaResource", "76_KScriptFormulaParser", ctx));
                }
                String name = params[0].substring(params[0].indexOf("=") + 1, params[0].length());
                String type = params[1].substring(params[1].indexOf("=") + 1, params[1].length());
                String scope = params[2].substring(params[2].indexOf("=") + 1, params[2].length());
                if (Type.VarType.SYSTEMVARIABLE.name().equalsIgnoreCase(type)) {
                    vars.put(name, FieldRuleUtils.getVariableValue(ctx, name, input));
                    continue;
                }
                if (Type.VarType.FACADE.name().equalsIgnoreCase(type)) {
                    if (null == MetaDataPK.create((String)scope)) {
                        logger.error("ParseFormulaVariable error , not found facade : {}", (Object)scope);
                        return null;
                    }
                    FacadeInfo businessObjectInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getFacade((IMetaDataPK)MetaDataPK.create((String)scope));
                    IBOSObject bizFacade = BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)businessObjectInfo.getType());
                    vars.put(name, bizFacade);
                    continue;
                }
                if (!Type.VarType.OBJECTVALUE.name().equalsIgnoreCase(type) && !Type.VarType.ENTITY.name().equalsIgnoreCase(type) || null == (coreBaseInfo = FieldRuleFormulaEngine.newInstance(ctx, scope, 0))) continue;
                if (!Type.VarType.ENTITY.name().equalsIgnoreCase(type)) {
                    vars.put(MAIN_KEY + name, coreBaseInfo);
                    continue;
                }
                vars.put(name, coreBaseInfo);
            }
        }
        catch (BOSException e) {
            logger.error("ParseFormulaVariable error , formulaStr : {}", (Object)input);
            logger.error(e.getMessage());
        }
        return vars;
    }

    public static Object runFormula(String formulaStr, Map<String, Object> paramCtx, Context envCtx) {
        FieldRuleInterpreter ruleParser = new FieldRuleInterpreter(envCtx);
        long begin = System.currentTimeMillis();
        Object result = FieldRuleFormulaEngine.runFormula(ruleParser, formulaStr, paramCtx);
        long end = System.currentTimeMillis();
        long cost = end - begin;
        if (cost > 1000L && logger.isDebugEnabled()) {
            logger.debug("RunFormula formulaStr:{}", (Object)formulaStr);
            logger.debug("RunFormula cost:{} ms, {} s", (Object)cost, (Object)((double)cost / 1000.0));
        }
        return result;
    }

    private static Object runFormula(FieldRuleInterpreter ruleParser, String formulaStr, Map<String, Object> paramCtx) {
        try {
            if (StringUtils.isEmpty((String)formulaStr)) {
                throw new InterpreterException("Formula string couldn't be null.");
            }
            return ruleParser.eval(formulaStr, paramCtx);
        }
        catch (InterpreterException e) {
            logger.error("RuntimeException, formulaStr : {}", (Object)formulaStr);
            e.printStackTrace();
        }
        catch (ParserException e1) {
            logger.error("ParserException, formulaStr : {}", (Object)formulaStr);
            e1.printStackTrace();
        }
        return null;
    }

    private static IObjectValue newInstance(Context ctx, String entityName, int root) {
        if (StringUtils.isEmpty((String)entityName)) {
            return null;
        }
        MetaDataPK metaDataPK = MetaDataPK.create((String)entityName);
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)metaDataPK);
        String className = entityInfo.getObjectValueClass();
        IObjectValue objectInfo = null;
        try {
            Class<?> clazz = Class.forName(className);
            objectInfo = (IObjectValue)clazz.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            logger.error("Init java bean error : newInstance(String), entityName : {}", (Object)entityName);
            return null;
        }
        if (entityInfo.isDynamic() && objectInfo instanceof ICommonBOSType) {
            ICommonBOSType commonObject = (ICommonBOSType)objectInfo;
            commonObject.setBOSType(entityInfo.getType());
            commonObject.setPK((IMetaDataPK)metaDataPK);
        }
        FieldRuleFormulaEngine.setEntryEntityName(ctx, objectInfo, entityInfo.getProperties(), root);
        return objectInfo;
    }

    private static void setEntryEntityName(Context ctx, IObjectValue objValue, PropertyCollection props, int root) {
        if (root == 1) {
            return;
        }
        for (int i = 0; i < props.size(); ++i) {
            RelationshipInfo relationship;
            PropertyInfo propertyInfo = props.get(i);
            if (!(propertyInfo instanceof LinkPropertyInfo) || !RelationshipType.COMPOSITION.equals((Object)(relationship = ((LinkPropertyInfo)propertyInfo).getRelationship()).getType()) || !(objValue instanceof CoreBaseInfo)) continue;
            CoreBaseInfo coreBaseInfo = (CoreBaseInfo)objValue;
            String entityName = relationship.getSupplierObject().getFullName();
            if (!(coreBaseInfo.get(propertyInfo.getName()) instanceof IObjectCollection)) continue;
            AbstractObjectCollection coll = (AbstractObjectCollection)coreBaseInfo.get(propertyInfo.getName());
            coll.addObject(FieldRuleFormulaEngine.newInstance(ctx, entityName, ++root));
        }
    }
}

