/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.fieldrule.formula.parse;

import com.kingdee.shr.base.syssetting.fieldrule.formula.parse.Source;
import java.io.Serializable;

public class Position
implements Serializable {
    private static final long serialVersionUID = 2880492332223966433L;
    public static final Position NULL = new Position();
    public int beginLine = 0;
    public int beginColumn = 0;
    public int endLine = 0;
    public int endColumn = 0;
    public int position = -1;
    public int length = -1;
    public Source source = null;

    public String toString() {
        return "Position(ln=" + this.beginLine + ",col=" + this.beginColumn + ",pos=" + this.position + ",len=" + this.length + ") " + this.getSourceText();
    }

    public String getSourceText() {
        String text;
        if (this.source != null && this.position >= 0 && this.length > 0 && this.position + this.length <= (text = this.source.getText()).length()) {
            return text.substring(this.position, this.position + this.length);
        }
        return null;
    }

    public Position() {
    }

    public boolean equals(Object x) {
        if (x == null) {
            return false;
        }
        Position p = null;
        if (x instanceof Position) {
            p = (Position)x;
            return p.source.equals(this.source) && p.position == this.position && p.length == this.length;
        }
        return false;
    }

    public boolean isValidPosition() {
        return this.source != null && this.beginLine > 0 && this.beginColumn > 0 && this.position >= 0 && this.length > 0;
    }

    public Position nullStart() {
        return new Position(this.source, this.beginLine, this.beginColumn, this.position, 0);
    }

    public static Position getPosition(Position first, Position last) {
        if (last == null || first == last) {
            return first;
        }
        return new Position(first.source, first.beginLine, first.beginColumn, first.position, last.position + last.length - first.position);
    }

    public Position(Source source, int startLine, int startColumn, int position, int length) {
        this.source = source;
        this.beginLine = startLine;
        this.beginColumn = startColumn;
        this.position = position;
        this.length = length;
    }

    protected void setLength(String value) {
        this.length = value == null ? 0 : value.length();
    }
}

