/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.fieldrule.formula.parse;

import com.kingdee.shr.base.syssetting.fieldrule.formula.ParserException;
import com.kingdee.shr.base.syssetting.fieldrule.formula.TypeUtils;
import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.BinaryOpExpr;
import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.CodeExpr;
import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.VectorCreateExpr;
import com.kingdee.shr.base.syssetting.fieldrule.formula.parse.AbstractParser;
import com.kingdee.shr.base.syssetting.fieldrule.formula.parse.ExprParser;
import com.kingdee.shr.base.syssetting.fieldrule.formula.parse.Lexer;
import com.kingdee.shr.base.syssetting.fieldrule.formula.parse.Token;
import com.kingdee.shr.base.syssetting.fieldrule.formula.parse.TokenList;
import com.kingdee.shr.base.syssetting.fieldrule.formula.stmt.BlockStmt;
import com.kingdee.shr.base.syssetting.fieldrule.formula.stmt.CodeStmt;
import com.kingdee.shr.base.syssetting.fieldrule.formula.stmt.ElseIfItem;
import com.kingdee.shr.base.syssetting.fieldrule.formula.stmt.ExprListStmt;
import com.kingdee.shr.base.syssetting.fieldrule.formula.stmt.ExprStmt;
import com.kingdee.shr.base.syssetting.fieldrule.formula.stmt.IfStmt;
import com.kingdee.shr.base.syssetting.fieldrule.formula.stmt.ReturnStmt;
import com.kingdee.shr.base.syssetting.fieldrule.formula.stmt.VarDeclItem;
import com.kingdee.shr.base.syssetting.fieldrule.formula.stmt.VarDeclStmt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StmtParser
extends AbstractParser {
    public final List<String> namespaces;
    public final Map<String, Object> classMap;

    public StmtParser(TokenList tokList) {
        this._tokenList = tokList;
        this.namespaces = new ArrayList<String>();
        this.namespaces.add("java.lang");
        this.namespaces.add("java.util");
        this.classMap = new HashMap<String, Object>();
    }

    public StmtParser(TokenList tokList, List<String> namespaces, Map<String, Object> classMap) {
        this._tokenList = tokList;
        this.namespaces = namespaces;
        this.classMap = classMap;
    }

    public StmtParser(String text) throws ParserException {
        Lexer lexer = new Lexer(text);
        this._tokenList = new TokenList(lexer);
        this.namespaces = new ArrayList<String>();
        this.namespaces.add("java.lang");
        this.namespaces.add("java.util");
        this.classMap = new HashMap<String, Object>();
    }

    public StmtParser(String text, List<String> namespaces, Map<String, Object> classMap) throws ParserException {
        Lexer lexer = new Lexer(text);
        this._tokenList = new TokenList(lexer);
        this.namespaces = namespaces;
        this.classMap = classMap;
    }

    public void stmtList(List<CodeStmt> list) throws ParserException {
        this.stmtList(list, null);
    }

    public void stmtList(List<CodeStmt> list, Token endTok) throws ParserException {
        while (!(this._tokenList.lookup(0).equals(Token.EOFToken) || endTok != null && this._tokenList.lookup(0).equals(endTok))) {
            CodeStmt stmt = this.stmt();
            if (stmt == null) continue;
            list.add(stmt);
        }
    }

    public CodeStmt stmt() throws ParserException {
        Token first = this._tokenList.lookup(0);
        if (this._tokenList.lookup(0).equals(Token.SemicolonToken)) {
            this._tokenList.match();
            return null;
        }
        if (this._tokenList.lookup(0).equals(Token.IfToken)) {
            return this.ifStmt();
        }
        if (this._tokenList.lookup(0).equals(Token.ReturnToken)) {
            this._tokenList.match();
            ExprParser parser = new ExprParser(this._tokenList, this.namespaces, this.classMap);
            CodeExpr expr = parser.expr();
            if (!this._tokenList.lookup(0).equals(Token.EOFToken)) {
                this._tokenList.match(Token.SemicolonToken);
            }
            return new ReturnStmt(this.getPosition(first), expr);
        }
        if (this._tokenList.lookup(0).equals(Token.OpenCurlyBraceToken)) {
            this._tokenList.match();
            BlockStmt blockStmt = new BlockStmt(null);
            this.stmtList(blockStmt.stmtList, Token.CloseCurlyBraceToken);
            this._tokenList.match(Token.CloseCurlyBraceToken);
            blockStmt.position = this.getPosition(first);
            return blockStmt;
        }
        if (this._tokenList.lookup(0).equals(Token.VarToken)) {
            this._tokenList.match();
            VarDeclStmt varDeclStmt = new VarDeclStmt(null);
            VarDeclItem varItem = new VarDeclItem(null);
            Token varItemFirst = this._tokenList.lookup(0);
            String varName = this._tokenList.lookup((int)0).value;
            this._tokenList.match(1);
            varItem.name = varName;
            ExprParser parser = new ExprParser(this._tokenList);
            if (this._tokenList.lookup(0).equals(Token.AssignToken)) {
                this._tokenList.match();
                if (this._tokenList.lookup(0).equals(Token.OpenSquareBraceToken)) {
                    Token arrayFirst = this._tokenList.lookup(0);
                    this._tokenList.match();
                    if (this._tokenList.lookup(0).equals(Token.CloseSquareBraceToken)) {
                        this._tokenList.match();
                        varItem.initExpr = new VectorCreateExpr(this.getPosition(arrayFirst));
                    } else {
                        VectorCreateExpr vecCreateExpr = new VectorCreateExpr(null);
                        parser.exprList(vecCreateExpr.paramList);
                        varItem.initExpr = vecCreateExpr;
                        this._tokenList.match(Token.CloseSquareBraceToken);
                        vecCreateExpr.position = this.getPosition(arrayFirst);
                    }
                } else {
                    varItem.initExpr = parser.expr();
                }
            }
            varItem.position = this.getPosition(varItemFirst);
            varDeclStmt.varDeclList.add(varItem);
            while (this._tokenList.lookup(0).equals(Token.CommaToken)) {
                this._tokenList.match();
                varItem = new VarDeclItem(null);
                varItemFirst = this._tokenList.lookup(0);
                varName = this._tokenList.lookup((int)0).value;
                this._tokenList.match(1);
                varItem.name = varName;
                if (this._tokenList.lookup(0).equals(Token.AssignToken)) {
                    this._tokenList.match();
                    varItem.initExpr = parser.expr();
                }
                varItem.position = this.getPosition(varItemFirst);
                varDeclStmt.varDeclList.add(varItem);
            }
            if (!this._tokenList.lookup(0).equals(Token.EOFToken)) {
                this._tokenList.match(Token.SemicolonToken);
            }
            varDeclStmt.position = this.getPosition(first);
            return varDeclStmt;
        }
        if (this._tokenList.lookup((int)0).type == 1 || this._tokenList.lookup((int)0).type == 3) {
            StringBuffer buff = new StringBuffer();
            buff.append(this._tokenList.lookup((int)0).value);
            int tokIndex = 0;
            while (this._tokenList.lookup(++tokIndex).equals(Token.PeriodToken)) {
                buff.append('.');
                buff.append(this._tokenList.lookup((int)(++tokIndex)).value);
            }
            String typeName = buff.toString();
            Class<?> type = TypeUtils.classForName(this.namespaces, this.classMap, typeName);
            if (type != null || this._tokenList.lookup((int)tokIndex).type == 1 || this._tokenList.lookup(tokIndex).equals(Token.OpenSquareBraceToken) && this._tokenList.lookup(tokIndex + 1).equals(Token.CloseSquareBraceToken)) {
                for (int i = 0; i < tokIndex; ++i) {
                    this._tokenList.match();
                }
                if (this._tokenList.lookup(0).equals(Token.OpenSquareBraceToken) && this._tokenList.lookup(1).equals(Token.CloseSquareBraceToken)) {
                    this._tokenList.match();
                    this._tokenList.match();
                    typeName = typeName + "[]";
                }
                VarDeclStmt varDeclStmt = new VarDeclStmt(null);
                VarDeclItem varItem = new VarDeclItem(null);
                Token varItemFirst = this._tokenList.lookup(0);
                varItem.type = typeName;
                varItem.name = this._tokenList.lookup((int)0).value;
                this._tokenList.match(1);
                ExprParser parser = new ExprParser(this._tokenList);
                if (this._tokenList.lookup(0).equals(Token.AssignToken)) {
                    this._tokenList.match();
                    varItem.initExpr = parser.expr();
                }
                varItem.position = this.getPosition(varItemFirst);
                varDeclStmt.varDeclList.add(varItem);
                while (this._tokenList.lookup(0).equals(Token.CommaToken)) {
                    this._tokenList.match();
                    varItem = new VarDeclItem(null);
                    varItemFirst = this._tokenList.lookup(0);
                    String varName = this._tokenList.lookup((int)0).value;
                    this._tokenList.match(1);
                    varItem.name = varName;
                    if (this._tokenList.lookup(0).equals(Token.AssignToken)) {
                        this._tokenList.match();
                        varItem.initExpr = parser.expr();
                    }
                    varItem.position = this.getPosition(varItemFirst);
                    varDeclStmt.varDeclList.add(varItem);
                }
                this._tokenList.match(Token.SemicolonToken);
                varDeclStmt.position = this.getPosition(first);
                return varDeclStmt;
            }
            if (this._tokenList.lookup((int)tokIndex).type == 1) {
                // empty if block
            }
        }
        ExprParser parser = new ExprParser(this._tokenList);
        ArrayList<CodeExpr> exprList = new ArrayList<CodeExpr>();
        CodeExpr expr = parser.expr();
        exprList.add(expr);
        while (this._tokenList.lookup(0).equals(Token.CommaToken)) {
            this._tokenList.match();
            expr = parser.expr();
            exprList.add(expr);
        }
        if (!this._tokenList.lookup(0).equals(Token.EOFToken)) {
            this._tokenList.match(Token.SemicolonToken);
        }
        if (exprList.size() == 1) {
            return new ExprStmt(this.getPosition(first), expr);
        }
        return new ExprListStmt(this.getPosition(first), exprList);
    }

    public IfStmt ifStmt() throws ParserException {
        if (this._tokenList.lookup(0).equals(Token.IfToken)) {
            CodeStmt stmt;
            Token first = this._tokenList.lookup(0);
            this._tokenList.match();
            this._tokenList.match(Token.OpenBraceToken);
            ExprParser parser = new ExprParser(this._tokenList, this.namespaces, this.classMap);
            CodeExpr expr = parser.expr();
            if (expr instanceof BinaryOpExpr) {
                BinaryOpExpr boe = (BinaryOpExpr)expr;
                if (boe.operator == 2) {
                    throw (ParserException)new ParserException("condition can not be assign.", expr, "Can't use assign expression as condition.").setInfoId("CONDITION_CAN_NOT_BE_ASSIGN").addArg(expr.position.beginLine + ":" + expr.position.beginColumn).addArg(boe.toString());
                }
            }
            this._tokenList.match(Token.CloseBraceToken);
            IfStmt ifStmt = new IfStmt(null);
            ifStmt.testExpr = expr;
            if (this._tokenList.lookup(0).equals(Token.OpenCurlyBraceToken)) {
                this._tokenList.match();
                this.stmtList(ifStmt.trueStmtList, Token.CloseCurlyBraceToken);
                this._tokenList.match(Token.CloseCurlyBraceToken);
            } else {
                stmt = this.stmt();
                ifStmt.trueStmtList.add(stmt);
            }
            while (this._tokenList.lookup(0).equals(Token.ElseToken)) {
                this._tokenList.match();
                if (this._tokenList.lookup(0).equals(Token.IfToken) && this._tokenList.lookup(1).equals(Token.OpenBraceToken)) {
                    Token elseFirst = this._tokenList.lookup(0);
                    this._tokenList.match();
                    this._tokenList.match();
                    ElseIfItem elseIf = new ElseIfItem(null);
                    elseIf.testExpr = parser.expr();
                    this._tokenList.match(Token.CloseBraceToken);
                    if (this._tokenList.lookup(0).equals(Token.OpenCurlyBraceToken)) {
                        this._tokenList.match();
                        this.stmtList(elseIf.stmtList, Token.CloseCurlyBraceToken);
                        this._tokenList.match(Token.CloseCurlyBraceToken);
                    } else {
                        CodeStmt stmt2 = this.stmt();
                        elseIf.stmtList.add(stmt2);
                    }
                    elseIf.position = this.getPosition(elseFirst);
                    ifStmt.elseIfList.add(elseIf);
                    continue;
                }
                if (this._tokenList.lookup(0).equals(Token.OpenCurlyBraceToken)) {
                    this._tokenList.match();
                    this.stmtList(ifStmt.elseStmtList, Token.CloseCurlyBraceToken);
                    this._tokenList.match(Token.CloseCurlyBraceToken);
                    break;
                }
                stmt = this.stmt();
                ifStmt.elseStmtList.add(stmt);
                break;
            }
            ifStmt.position = this.getPosition(first);
            return ifStmt;
        }
        Token tok = this._tokenList.lookup(0);
        throw (ParserException)new ParserException("find unexpected token.", tok, "Can't find expect \"if\" token").setInfoId("IF_NO_IF").addArg(tok.beginLine + ":" + tok.beginColumn).addArg(tok.toString());
    }
}

