/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.fieldrule.formula.runtime;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.lazyload.IObjectValueLazyLoader;
import com.kingdee.bos.dao.ormapping.lazyload.ObjectValueLazyLoaderFactory;
import com.kingdee.shr.base.syssetting.fieldrule.formula.IObjectLoaderProvider;
import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.PropertyExpr;
import com.kingdee.shr.base.syssetting.fieldrule.formula.runtime.InterpreterException;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldRuleScriptObjectLoader
implements IObjectLoaderProvider {
    private static Logger log = LoggerFactory.getLogger(FieldRuleScriptObjectLoader.class);
    private Context context = null;

    @Override
    public boolean lazyLoadFillValue(Object objValue) throws InterpreterException {
        boolean rtn = false;
        if (objValue instanceof IObjectValue) {
            IObjectValue objVal2 = (IObjectValue)objValue;
            boolean flag = true;
            if (objVal2.size() == 1 && objVal2.containsKey("id")) {
                flag = false;
            }
            if (!flag) {
                long startTime = System.currentTimeMillis();
                if (this.getContext() != null) {
                    try {
                        IObjectValueLazyLoader loader = ObjectValueLazyLoaderFactory.getLocalInstance((Context)this.getContext());
                        loader.fillValue(objVal2);
                        rtn = true;
                    }
                    catch (BOSException e) {
                        throw new InterpreterException("lazy load IObjectValue error." + e.getMessage(), e);
                    }
                } else {
                    log.warn("IObjectValue not exist , can not lazyload, because bosContext is null.");
                }
                long timeSpan = System.currentTimeMillis() - startTime;
                if (log.isDebugEnabled()) {
                    log.debug("Lazy IObjectValue, BOSType : {} , Cost : {}", (Object)objVal2.getBOSType(), (Object)timeSpan);
                }
            }
        }
        return rtn;
    }

    @Override
    public Object lazyLoadGetProperty(Object ownerValue, String propName, PropertyExpr propExpr) throws InterpreterException {
        Object rtn = null;
        if (ownerValue instanceof IObjectValue) {
            IObjectValue objValue = (IObjectValue)ownerValue;
            boolean isLoaded = true;
            if (!objValue.containsKey(propName)) {
                isLoaded = false;
            } else {
                IObjectCollection col;
                Object val = objValue.get(propName);
                if (val instanceof IObjectCollection && (col = (IObjectCollection)val).size() == 0) {
                    isLoaded = false;
                }
            }
            if (!isLoaded) {
                long startTime = System.currentTimeMillis();
                if (this.getContext() != null) {
                    try {
                        IObjectValueLazyLoader loader = ObjectValueLazyLoaderFactory.getLocalInstance((Context)this.getContext());
                        rtn = loader.getProperty(objValue, propName);
                    }
                    catch (BOSException e) {
                        throw new InterpreterException("lazy load IObjectValue error." + e.getMessage(), propExpr, e);
                    }
                } else {
                    log.warn("IObjectValue not exist property {}, can not lazyload, because bosContext is null.'", (Object)propName);
                }
                long timeSpan = System.currentTimeMillis() - startTime;
                if (log.isDebugEnabled()) {
                    log.debug("Lazy IObjectValue, BOSType : {} , Not exist propertyName : {}, Cost : {}", new Object[]{objValue.getBOSType(), propName, timeSpan});
                }
            }
        }
        return rtn;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public void setContext(Context context) {
        if (context == null) {
            this.context = null;
        } else if (context instanceof Context) {
            this.context = context;
        } else {
            this.context = null;
            log.warn("setContext Error: the Context Type is not available!");
        }
    }

    @Override
    public Object getObjectCollectionChildByIndex(Object value, int index) {
        if (this.getObjectCollectionSize(value) > index) {
            IObjectCollection objCol = (IObjectCollection)value;
            return objCol.getObject(index);
        }
        return null;
    }

    @Override
    public boolean isObjectCollection(Object value) {
        return value instanceof IObjectCollection;
    }

    @Override
    public boolean isObjectValue(Object value) {
        return value instanceof IObjectValue;
    }

    @Override
    public boolean isObjectValueContainPropName(Object value, String propName) {
        if (this.isObjectValue(value)) {
            IObjectValue objVal = (IObjectValue)value;
            return objVal.containsKey(propName);
        }
        return false;
    }

    @Override
    public int getObjectCollectionSize(Object value) {
        if (this.isObjectCollection(value)) {
            IObjectCollection objCol = (IObjectCollection)value;
            return objCol.size();
        }
        return -1;
    }

    @Override
    public Object getObjectValuePropValueByName(Object value, String propName) {
        if (this.isObjectValueContainPropName(value, propName)) {
            IObjectValue objVal = (IObjectValue)value;
            return objVal.get(propName);
        }
        return null;
    }

    @Override
    public void setObjectValuePropValue(Object value, String propName, Object val) {
        if (this.isObjectValue(value)) {
            IObjectValue objVal = (IObjectValue)value;
            objVal.put(propName, val);
        }
    }

    @Override
    public Iterator<?> getObjectCollectionIterator(Object value) {
        if (this.isObjectCollection(value)) {
            IObjectCollection objCol = (IObjectCollection)value;
            return objCol.iterator();
        }
        return null;
    }

    @Override
    public boolean isBOSContext(Object value) {
        return value instanceof Context;
    }

    @Override
    public boolean isObjectPK(Object value) {
        return value instanceof IObjectPK;
    }

    @Override
    public String getObjectValuePKField(Object value) {
        if (this.isObjectValue(value)) {
            IObjectValue objVal = (IObjectValue)value;
            return objVal.getPKField();
        }
        return null;
    }
}

