/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.osf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.MethodInfo;
import com.kingdee.bos.bsf.service.ParameterInfo;
import com.kingdee.bos.bsf.service.PermType;
import com.kingdee.bos.bsf.service.PermissionInfo;
import com.kingdee.bos.bsf.service.ReturnInfo;
import com.kingdee.bos.bsf.service.ServiceInfo;
import com.kingdee.bos.bsf.service.SubParameterInfo;
import com.kingdee.bos.bsf.service.SubResturnInfo;
import com.kingdee.bos.framework.cache.service.CacheService;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.util.XMLUtil;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;

public class OSFCacheHelper {
    private static Logger logger = Logger.getLogger(OSFCacheHelper.class);
    private static final String CACHE_TYPE = "shr.shrOsfCache";

    private OSFCacheHelper() {
    }

    public static ServiceInfo getServiceInfo(Context ctx, String serviceName) {
        ServiceInfo obj = (ServiceInfo)CacheService.getInstance().get(CACHE_TYPE, serviceName);
        if (null != obj) {
            return obj;
        }
        try {
            obj = OSFCacheHelper.getServiceInfoFromDB(ctx, serviceName);
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
        if (null != obj) {
            CacheService.getInstance().put(CACHE_TYPE, serviceName, (Object)obj);
        }
        return obj;
    }

    public static void removeServiceInfo(Context ctx, String serviceName) {
        CacheService.getInstance().remove(CACHE_TYPE, serviceName);
    }

    public static void removeAll() {
        CacheService.getInstance().removeAll(CACHE_TYPE);
    }

    private static ServiceInfo getServiceInfoFromDB(Context ctx, String serviceName) throws BOSException {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT T0.FSTATE,T0.FCONFIG,T1.FCONFIG FCONFIGEXT, T0.FSERVICETYPE,T0.FCATEGORYID,T0.FSERVICELEVEL,T0.FBELONGDOMAIN,EK.FEncryptKey");
        sb.append(" ,(select count(1) from T_SHR_MsfWhiteList wl where wl.FServiceName=? and FType=").append(10).append(") fres");
        sb.append(" ,(select count(1) from T_SHR_MsfWhiteList wl where wl.FServiceName=? and FType=").append(20).append(") fouter");
        sb.append(" ,(select count(1) from T_SHR_MsfWhiteList wl where wl.FServiceName=? and FType=").append(30).append(") log");
        sb.append(" FROM T_BD_MSFCONFIG T0 LEFT OUTER JOIN T_BD_MSFCONFIGEXT T1 ON T1.FPARENTID = T0.FID ");
        sb.append(" LEFT OUTER JOIN T_SHR_MSFEncryptKey EK ON T0.FID = EK.FMsfconfigID");
        sb.append(" WHERE T0.FSERVICENAME = ? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{serviceName, serviceName, serviceName, serviceName});
        String config = "";
        String configExt = "";
        String category = "";
        String servicelevel = "";
        String belongdomain = "";
        int serviceType = 0;
        int state = 0;
        boolean isResFormat = true;
        boolean isOuterOsf = false;
        boolean isLogOsf = false;
        String ek = "";
        try {
            while (rs.next()) {
                config = rs.getString("FCONFIG");
                category = rs.getString("FCATEGORYID");
                servicelevel = rs.getString("FSERVICELEVEL");
                belongdomain = rs.getString("FBELONGDOMAIN");
                serviceType = rs.getInt("FSERVICETYPE");
                configExt = rs.getString("FCONFIGEXT");
                ek = rs.getString("FEncryptKey");
                int res = rs.getInt("fres");
                int outer = rs.getInt("fouter");
                int log = rs.getInt("log");
                state = rs.getInt("FSTATE");
                if (res > 0) {
                    isResFormat = false;
                }
                if (outer > 0 || 20 == serviceType || 10 == serviceType) {
                    isOuterOsf = true;
                }
                if (!isOuterOsf && log <= 0) continue;
                isLogOsf = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (StringUtils.isEmpty((String)config) && StringUtils.isEmpty((String)configExt)) {
            return null;
        }
        if (!StringUtils.isEmpty((String)configExt)) {
            config = configExt;
        }
        ServiceInfo serviceInfo = OSFCacheHelper.parseConfig(config);
        serviceInfo.setServiceType(serviceType);
        serviceInfo.setServiceName(serviceName);
        serviceInfo.setCategory(category);
        serviceInfo.setBelongdomain(belongdomain);
        serviceInfo.setServicelevel(servicelevel);
        serviceInfo.setResFormat(isResFormat);
        serviceInfo.setOuterOsf(isOuterOsf);
        serviceInfo.setLogEnable(isLogOsf);
        serviceInfo.setEncryptKey(ek);
        serviceInfo.setState(state);
        return serviceInfo;
    }

    private static ServiceInfo parseConfig(String config) throws BOSException {
        List ms;
        Element methods;
        Document doc = XMLUtil.parseXML((String)config);
        Element rootElement = doc.getRootElement();
        ServiceInfo serviceInfo = new ServiceInfo();
        serviceInfo.setServiceInterfaceName(rootElement.getAttributeValue("interface"));
        serviceInfo.setServiceClassName(rootElement.getAttributeValue("class"));
        Element e = rootElement.getChild("description");
        if (null != e) {
            serviceInfo.setDescription(e.getText());
        }
        if (null != (methods = rootElement.getChild("methods")) && null != (ms = methods.getChildren("method")) && !ms.isEmpty()) {
            ArrayList<MethodInfo> ll = new ArrayList<MethodInfo>(ms.size());
            for (Element ee : ms) {
                PermissionInfo perm;
                MethodInfo mi = new MethodInfo();
                mi.setName(ee.getAttributeValue("name"));
                mi.setDescription(ee.getAttributeValue("description"));
                List<ParameterInfo> p = OSFCacheHelper.getParameters(ee);
                if (null != p) {
                    mi.setParameters(p);
                }
                if (null != (perm = OSFCacheHelper.getPermission(ee))) {
                    mi.setPermission(perm);
                }
                mi.setRes(OSFCacheHelper.getRes(ee));
                ll.add(mi);
            }
            serviceInfo.setMethod(ll);
        }
        return serviceInfo;
    }

    private static ReturnInfo getRes(Element ee) {
        List<SubResturnInfo> sri;
        Element e = ee.getChild("return");
        if (null == e) {
            return null;
        }
        ReturnInfo ri = new ReturnInfo();
        ri.setType(e.getAttributeValue("type"));
        ri.setDescription(e.getAttributeValue("description"));
        String encrypt = e.getAttributeValue("encrypt");
        if ("true".equals(encrypt)) {
            ri.setEncrypt(true);
        }
        if (null != (sri = OSFCacheHelper.getSubResturnInfo(e))) {
            ri.setSubResturn(sri);
        }
        return ri;
    }

    private static List<SubResturnInfo> getSubResturnInfo(Element e) {
        List sri = e.getChildren("property");
        if (null == sri || sri.isEmpty()) {
            return null;
        }
        ArrayList<SubResturnInfo> ll = new ArrayList<SubResturnInfo>(sri.size());
        for (Element sr : sri) {
            SubResturnInfo t = new SubResturnInfo();
            t.setName(sr.getAttributeValue("name"));
            t.setType(sr.getAttributeValue("type"));
            t.setDescription(sr.getAttributeValue("description"));
            ll.add(t);
        }
        return ll;
    }

    private static PermissionInfo getPermission(Element ee) {
        List<PermType> pts;
        Element e = ee.getChild("permission");
        if (null == e) {
            return null;
        }
        PermissionInfo p = new PermissionInfo();
        String validateFun = e.getAttributeValue("validateFun");
        if ("true".equals(validateFun)) {
            p.setValidateFun(true);
        }
        if (null != (pts = OSFCacheHelper.getPermTypeInfo(e))) {
            p.setPermType(pts);
        }
        return p;
    }

    private static List<PermType> getPermTypeInfo(Element e) {
        List pts = e.getChildren("permType");
        if (null == pts || pts.isEmpty()) {
            return null;
        }
        ArrayList<PermType> ptsl = new ArrayList<PermType>(pts.size());
        for (Element pt : pts) {
            PermType ptt = new PermType();
            ptt.setName(pt.getAttributeValue("name"));
            ptt.setType(pt.getAttributeValue("type"));
            ptt.setValue(pt.getAttributeValue("value"));
            ptt.setDescription(pt.getAttributeValue("description"));
            ptsl.add(ptt);
        }
        return ptsl;
    }

    private static List<ParameterInfo> getParameters(Element ee) {
        Element e = ee.getChild("parameters");
        if (null == e) {
            return null;
        }
        List parameters = e.getChildren("parameter");
        if (null == parameters || parameters.isEmpty()) {
            return null;
        }
        ArrayList<ParameterInfo> ll = new ArrayList<ParameterInfo>(parameters.size());
        for (Element pe : parameters) {
            ParameterInfo pi = new ParameterInfo();
            pi.setName(pe.getAttributeValue("name"));
            pi.setType(pe.getAttributeValue("type"));
            String isRequired = pe.getAttributeValue("isRequired");
            if ("true".equals(isRequired)) {
                pi.setRequired(true);
            }
            pi.setDescription(pe.getAttributeValue("description"));
            List<SubParameterInfo> sp = OSFCacheHelper.getSubParameterInfo(pe);
            if (null != sp) {
                pi.setSubparameters(sp);
            }
            ll.add(pi);
        }
        return ll;
    }

    private static List<SubParameterInfo> getSubParameterInfo(Element pe) {
        List sps = pe.getChildren("subparameter");
        if (null == sps || sps.isEmpty()) {
            return null;
        }
        ArrayList<SubParameterInfo> ll = new ArrayList<SubParameterInfo>(sps.size());
        for (Element sp : sps) {
            String isRequired;
            SubParameterInfo spi = new SubParameterInfo();
            spi.setName(sp.getAttributeValue("name"));
            spi.setType(sp.getAttributeValue("type"));
            spi.setDescription(sp.getAttributeValue("description"));
            String encrypt = sp.getAttributeValue("encrypt");
            if ("true".equals(encrypt)) {
                spi.setEncrypt(true);
            }
            if ("true".equals(isRequired = sp.getAttributeValue("isRequired"))) {
                spi.setRequired(true);
            }
            spi.setValue(sp.getAttributeValue("value"));
            spi.setBindPermValue(sp.getAttributeValue("bindPermValue"));
            ll.add(spi);
        }
        return ll;
    }
}

