/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.ueditor.util;

import com.kingdee.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

public class FileUtil {
    private FileUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void handlerFile(ZipOutputStream zip, File file, String dir, Set<String> urlSet) throws Exception {
        if (file.isDirectory()) {
            boolean result = true;
            for (String url : urlSet) {
                if (!url.contains(file.getPath().replace("\\", "/"))) continue;
                result = false;
                break;
            }
            if (result) {
                return;
            }
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return;
            }
            int num = 0;
            for (int i = 0; i < fileArray.length; ++i) {
                if (FileUtil.isCopyImage(file, fileArray[i], urlSet)) continue;
                ++num;
            }
            if (num <= 0) {
                return;
            }
            zip.putNextEntry(new ZipEntry(dir + "/"));
            dir = dir.length() == 0 ? "" : dir + "/";
            File[] fileArray2 = fileArray;
            int n = fileArray2.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray2[n2];
                if (!FileUtil.isCopyImage(file, f, urlSet)) {
                    FileUtil.handlerFile(zip, f, dir + f.getName(), urlSet);
                }
                ++n2;
            }
            return;
        }
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            fis = new FileInputStream(file);
            bis = new BufferedInputStream(fis);
            ZipEntry entry = new ZipEntry(dir);
            zip.putNextEntry(entry);
            zip.write(FileUtils.readFileToByteArray((File)file));
            zip.flush();
            zip.closeEntry();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bis);
            IOUtils.closeQuietly((InputStream)fis);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)bis);
        IOUtils.closeQuietly((InputStream)fis);
    }

    private static boolean isCopyImage(File file, File f, Set<String> urlSet) {
        String path;
        File[] newFiles;
        File newFile = new File(file.getPath() + File.separator + f.getName());
        return newFile.isDirectory() ? (newFiles = newFile.listFiles()) == null : !urlSet.contains(path = newFile.getPath().replace("\\", "/"));
    }

    public static void getAllUrlPath(File file, Set<String> urlSet, String s) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return;
            }
            for (File srcFile : fileArray) {
                FileUtil.getAllUrlPath(srcFile, urlSet, "");
            }
        } else if (FileUtil.isImageType(file.getPath())) {
            urlSet.add(file.getPath());
        }
    }

    public static boolean isImageType(String source) {
        try {
            source = source.replace("\\", "/");
            String imagesName = FileUtil.getImagesName(source);
            String substring = imagesName.substring(imagesName.lastIndexOf(".") + 1);
            return FileUtil.isImage(substring.toLowerCase(Locale.ENGLISH));
        }
        catch (Exception var4) {
            return false;
        }
    }

    public static boolean isImage(String imageType) {
        boolean isImage = false;
        if ("gif".equals(imageType) || "jpeg".equals(imageType) || "jpg".equals(imageType) || "png".equals(imageType)) {
            isImage = true;
        }
        return isImage;
    }

    public static String getImageFormat(Object obj) {
        try {
            ImageInputStream iis = ImageIO.createImageInputStream(obj);
            Iterator<ImageReader> iterator = ImageIO.getImageReaders(iis);
            if (iterator.hasNext()) {
                ImageReader reader = iterator.next();
                return reader.getFormatName();
            }
        }
        catch (IOException var4) {
            var4.printStackTrace();
        }
        return null;
    }

    public static String getImagesName(String urlPath) {
        String suffixes = "jpeg|jpg|png|gif";
        Pattern pat = Pattern.compile("[\\w]+[\\.](" + suffixes + ")");
        Matcher mc = pat.matcher(urlPath);
        String fileName = null;
        while (mc.find()) {
            fileName = mc.group();
        }
        return fileName;
    }

    public static String getFileNameByUrl(String path) {
        if (StringUtils.isEmpty((String)path)) {
            return "";
        }
        String[] split = path.replace("\\", "/").split("/");
        return split[split.length - 1];
    }
}

