/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.validaterule.formula.base;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.SqlParam;
import com.kingdee.eas.hr.base.app.filter.FilterUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.baseconfig.StructureConfigInfo;
import com.kingdee.shr.validaterule.BaseFormulaCollection;
import com.kingdee.shr.validaterule.BaseFormulaInfo;
import com.kingdee.shr.validaterule.exception.SalaryException;
import com.kingdee.shr.validaterule.formula.SalaryCalFunMgr2;
import com.kingdee.shr.validaterule.formula.SalaryCalFunction2;
import com.kingdee.shr.validaterule.formula.base.ICalculatorBusinessData;
import com.kingdee.shr.validaterule.formula.base.data.DataAccess;
import com.kingdee.shr.validaterule.formula.base.data.DataSet;
import com.kingdee.shr.validaterule.formula.base.data.DataTable;
import com.kingdee.shr.validaterule.formula.base.vo.InitCalData;
import com.kingdee.shr.validaterule.util.FunUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class AbstractCalculatorBusinessData
implements ICalculatorBusinessData {
    private static Logger logger = Logger.getLogger(AbstractCalculatorBusinessData.class);

    @Override
    public Map<String, String> combineTableItems(Context ctx, BaseFormulaCollection formulaInfos) throws SalaryException {
        HashMap<String, String> assTable = new HashMap<String, String>();
        String[] item = null;
        String[] items = null;
        String clm = null;
        String listItems = null;
        int size = formulaInfos.size();
        for (int i = 0; i < size; ++i) {
            BaseFormulaInfo formulaInfo = formulaInfos.get(i);
            listItems = formulaInfo.getListItem();
            if (listItems == null || "".equals(listItems)) continue;
            items = listItems.split(";");
            for (int loop = 0; loop < items.length; ++loop) {
                item = items[loop].split("~");
                if (item[1].startsWith("TEMP")) continue;
                String columns = "";
                String tableKey = "";
                if (item.length > 3) {
                    tableKey = item[1] + "~" + item[3];
                    if (assTable.containsKey(tableKey)) {
                        columns = (String)assTable.get(tableKey) + ",";
                        if (columns.indexOf(clm = item[1] + "." + item[2] + ",") != -1) continue;
                        columns = columns.substring(0, columns.length() - 1) + ", " + clm.substring(0, clm.length() - 1);
                        assTable.put(tableKey, columns);
                        continue;
                    }
                    columns = item[1] + "." + item[2];
                    assTable.put(tableKey, columns);
                    continue;
                }
                if (assTable.containsKey(item[1])) {
                    columns = (String)assTable.get(item[1]) + ",";
                    if (columns.indexOf(clm = item[1] + "." + item[2] + ",") != -1) continue;
                    columns = columns.substring(0, columns.length() - 1) + ", " + clm.substring(0, clm.length() - 1);
                    assTable.put(item[1], columns);
                    continue;
                }
                columns = item[1] + "." + item[2];
                assTable.put(item[1], columns);
            }
        }
        return assTable;
    }

    @Override
    public SalaryCalFunction2 initCalInstance(InitCalData initCalData) throws SalaryException {
        SalaryCalFunction2 calObj = null;
        try {
            calObj = SalaryCalFunMgr2.getInstance(initCalData);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (calObj == null) {
            throw new SalaryException(SalaryException.FORMULAERROR);
        }
        return calObj;
    }

    @Override
    public DataSet initCalData(InitCalData initCalData) throws EASBizException {
        DataSet dataSet = new DataSet();
        Map<String, String> assTable = initCalData.getAssTable();
        Iterator<String> iter = assTable.keySet().iterator();
        DataAccess DAC = new DataAccess();
        Object sq = null;
        DataTable dt = null;
        try {
            String tempSql = this.buildDataSetSql(initCalData);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("---initCalData: SQL " + tempSql));
            }
            DataTable baseDt = DAC.getDataForDataTable(initCalData.getCtx(), tempSql);
            while (iter.hasNext()) {
                String tableName = iter.next();
                dt = new DataTable();
                dt.tablename = tableName;
                dt.columns = baseDt.columns;
                dt.datas = baseDt.datas;
                dt.datasIndexMap = baseDt.datasIndexMap;
                dt.emptyrow = baseDt.emptyrow;
                dataSet.addTable(dt);
            }
        }
        catch (Exception e) {
            throw new SalaryException(SalaryException.QUERYFAIL, e, new Object[]{sq});
        }
        return dataSet;
    }

    protected String buildDataSetSql(InitCalData initCalData) throws Exception {
        FilterInfo filterInfo = this.assembleDataSetFilter(initCalData);
        Map<String, String> selectMapping = this.buildSelector(initCalData);
        SqlParam sqlParam = new SqlParam();
        sqlParam.setSelectMapping(selectMapping);
        sqlParam.setFilterInfo(filterInfo);
        sqlParam.setSortStr(initCalData.getMainTableAlias() + ".id");
        sqlParam.setScheme(initCalData.getConfigNum());
        sqlParam.setFilterDate(initCalData.getEndDate());
        sqlParam.setHistoryMode(true);
        sqlParam.setIgnoreNowDateFilter(true);
        this.afterAssembleSqlParam(initCalData, sqlParam);
        String sql = FilterUtil.getSql((Context)initCalData.getCtx(), (SqlParam)sqlParam);
        sql = this.afterBuildDataSetSql(initCalData, sql);
        return sql;
    }

    protected String afterBuildDataSetSql(InitCalData initCalData, String sql) {
        return sql;
    }

    protected void afterAssembleSqlParam(InitCalData initCalData, SqlParam sqlParam) throws Exception {
    }

    protected abstract FilterInfo assembleDataSetFilter(InitCalData var1) throws Exception;

    protected Map<String, String> buildSelector(InitCalData initCalData) throws BOSException {
        HashMap<String, String> selectMapping = new HashMap<String, String>();
        String mainTableAlias = initCalData.getMainTableAlias();
        selectMapping.put(mainTableAlias + ".id", "fid");
        selectMapping.put(mainTableAlias + ".person", "FPERSONID");
        Map<String, String> assTable = initCalData.getAssTable();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("assTable:" + assTable.keySet() + "\uff1b" + assTable.values()));
        }
        Set<Map.Entry<String, String>> entrySet = assTable.entrySet();
        Iterator<Map.Entry<String, String>> it = entrySet.iterator();
        String tableName = "";
        String field = "";
        String strucNum = "";
        String entityName = "";
        String tableField = "";
        String columns = "";
        String column = "";
        String[] tableArr = null;
        String[] columnArr = null;
        StructureConfigInfo structureInfo = null;
        Context ctx = initCalData.getCtx();
        Map<String, StructureConfigInfo> structMap = FunUtils.getCmpStructureMapByNum(ctx, initCalData.getConfigNum());
        Map<String, PropertyInfo> properties = null;
        Map.Entry<String, String> next = null;
        String mainTableName = initCalData.getMainTableName();
        while (it.hasNext()) {
            next = it.next();
            tableArr = next.getKey().split("~");
            tableName = tableArr[0];
            if (mainTableName.equals(tableName) && tableArr.length == 1) {
                columns = assTable.get(tableName);
                if (null == columns) {
                    columns = assTable.get(tableName + "~" + initCalData.getMainTableAlias());
                }
                columnArr = columns.split(",");
                for (int i = 0; i < columnArr.length; ++i) {
                    column = mainTableAlias + "." + columnArr[i].split("\\.")[1];
                    selectMapping.put(column, column);
                }
                continue;
            }
            strucNum = tableArr[1];
            structureInfo = structMap.get(strucNum);
            if (structureInfo == null) continue;
            entityName = structureInfo.getEntityName();
            properties = FunUtils.getProperties(ctx, entityName);
            field = next.getValue();
            String[] singleField = field.split(",");
            for (int i = 0; i < singleField.length; ++i) {
                field = singleField[i];
                tableField = field.split("\\.")[1];
                field = properties.get(tableField).getName();
                if (selectMapping.containsKey(strucNum + "." + field)) continue;
                selectMapping.put(strucNum + "." + field, strucNum + "." + tableField);
            }
        }
        return selectMapping;
    }

    protected Map<String, String> getF7TableValue(Context ctx, String language, String table) throws BOSException, SQLException {
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuilder sql = new StringBuilder();
        sql.append("select fid id, fname_").append(language).append(" name from ").append(table);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rs.next()) {
            map.put(rs.getString("id"), rs.getString("name"));
        }
        return map;
    }

    protected String getCurrentLanguageBySchemeLocal(Context ctx, String schemeID) throws BOSException {
        return ctx.getLocale().getLanguage();
    }
}

