/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.validaterule.formula.base.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.integrate.CalSubmitSchemeFactory;
import com.kingdee.shr.compensation.app.integrate.CalSubmitSchemeInfo;
import com.kingdee.shr.validaterule.CmpItemDataDot;
import com.kingdee.shr.validaterule.formula.base.AbstractCalculatorBusinessData;
import com.kingdee.shr.validaterule.formula.base.vo.InitCalData;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CalculatorBusinessDataCommon
extends AbstractCalculatorBusinessData {
    private static Logger logger = Logger.getLogger(CalculatorBusinessDataCommon.class);

    @Override
    protected FilterInfo assembleDataSetFilter(InitCalData initCalData) throws Exception {
        return new FilterInfo("CMP_SMT001.id in (" + initCalData.getCondition() + ")");
    }

    @Override
    protected String afterBuildDataSetSql(InitCalData initCalData, String sql) {
        sql = sql.replace("T_HR_SADJUSTSALARYAPPLYENTRY", initCalData.getMainTable().toUpperCase(Locale.ENGLISH));
        return sql;
    }

    @Override
    public Map<String, Object> getAllCnSnMap(Context ctx, String schemeID) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String language = this.getCurrentLanguageBySchemeLocal(ctx, schemeID);
        sql.append(" SELECT ");
        sql.append(" ITEM.FID ITEMID,ITEM.FNAME_" + language + " ITEMNAME,ITEM.FNUMBER ITEMNUMBER, ");
        sql.append(" ITEM.FIELDSN,ITEM.FDATADOT,ITEM.FDATATYPE,ITEM.FDATALENGTH,F7.FTABLE ");
        sql.append(" FROM ");
        sql.append(" T_HR_ADJUSTSALARYITEM ITEM ");
        sql.append(" LEFT JOIN T_HR_SCalSchemeItemForF7 F7 on ITEM.FilterFieldID = F7.FID ");
        sql.append(" WHERE FSTATE = 1  ");
        sql.append(" ORDER BY FIELDSN ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<String> sn = new ArrayList<String>();
        ArrayList<String> cn = new ArrayList<String>();
        HashMap<String, CmpItemDataDot> dataDotMap = new HashMap<String, CmpItemDataDot>();
        HashMap<String, Integer> dataTypeMap = new HashMap<String, Integer>();
        HashMap<String, Map<String, String>> f7TypeMap = new HashMap<String, Map<String, String>>();
        HashMap<String, String> idItemMap = new HashMap<String, String>();
        HashMap<String, Integer> strItemLenMap = new HashMap<String, Integer>();
        try {
            while (rs.next()) {
                CmpItemDataDot dataDot = CmpItemDataDot.getEnum(rs.getInt("FDATADOT"));
                Integer dataType = rs.getInt("FDATATYPE");
                String name = rs.getString("ITEMNAME");
                int fieldSn = rs.getInt("FIELDSN");
                String f7TableName = rs.getString("FTABLE");
                if (fieldSn <= 0) continue;
                String fieldName = "s" + fieldSn;
                sn.add(fieldName);
                cn.add(name);
                dataDotMap.put(fieldName, dataDot);
                dataTypeMap.put(fieldName, dataType);
                if (dataType == 1) {
                    strItemLenMap.put(fieldName, rs.getInt("FDATALENGTH"));
                }
                if (dataType == 3 && !StringUtils.isEmpty((String)f7TableName)) {
                    f7TypeMap.put(fieldName, this.getF7TableValue(ctx, language, f7TableName));
                }
                idItemMap.put(fieldName.toUpperCase(Locale.ENGLISH), rs.getString("ITEMID"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        HashMap<String, Object> res = new HashMap<String, Object>();
        sn.add("forwarncontent");
        cn.add(EASResource.getString((String)"com.kingdee.shr.validaterule.resource.BaseStrResource", (String)"warnContent", (Locale)ctx.getLocale()));
        dataTypeMap.put("forwarncontent", 1);
        res.put("sn", sn);
        res.put("cn", cn);
        res.put("dataDotMap", dataDotMap);
        res.put("dataTypeMap", dataTypeMap);
        res.put("fieldSnAndId", idItemMap);
        res.put("strLengthMap", strItemLenMap);
        res.put("f7TypeMap", f7TypeMap);
        return res;
    }

    @Override
    protected String getCurrentLanguageBySchemeLocal(Context ctx, String schemeID) throws BOSException {
        try {
            CalSubmitSchemeInfo adjScheme = CalSubmitSchemeFactory.getLocalInstance((Context)ctx).getCalSubmitSchemeInfo((IObjectPK)new ObjectUuidPK(schemeID));
            if (adjScheme == null || adjScheme.getLanType() == null) {
                return super.getCurrentLanguageBySchemeLocal(ctx, schemeID);
            }
            return adjScheme.getLanType().getValue();
        }
        catch (EASBizException e) {
            throw new RuntimeException(e);
        }
    }
}

