/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.validaterule.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ICommonBOSType;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ep.CoreBillBaseCustomInfo;
import com.kingdee.eas.ep.DataBaseCustomInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.shr.base.syssetting.BaseItemCustomInfo;
import com.kingdee.shr.base.syssetting.app.util.MetaDataUtil;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.Enum;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class EntityUtil {
    private static Logger logger = Logger.getLogger(EntityUtil.class);

    public static String getEntityFieldName(Context ctx, String entityName, String fieldName) {
        if (StringUtils.isEmpty((String)fieldName) || StringUtils.isEmpty((String)entityName)) {
            return null;
        }
        PropertyInfo propertyInfo = EntityUtil.getPropertyInfo(ctx, entityName, fieldName);
        if (propertyInfo == null || propertyInfo.getMappingField() == null || StringUtils.isEmpty((String)propertyInfo.getMappingField().getName())) {
            return null;
        }
        if (null == ctx) {
            return null;
        }
        String language = ctx.getLocale().getLanguage().toUpperCase(Locale.ENGLISH);
        if (propertyInfo.getMappingField().isMultilingual()) {
            return propertyInfo.getMappingField().getName() + "_" + language;
        }
        return propertyInfo.getMappingField().getName();
    }

    public static PropertyInfo getPropertyInfo(Context ctx, String entityName, String fieldName) {
        if (StringUtils.isEmpty((String)fieldName) || StringUtils.isEmpty((String)entityName)) {
            return null;
        }
        if (!fieldName.contains(".")) {
            MetaDataPK pk = MetaDataPK.create((String)entityName);
            if (null != pk) {
                EntityObjectInfo entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)pk);
                return entityInfo.getPropertyByNameRuntime(fieldName);
            }
            return null;
        }
        return EntityUtil.getPropertyInfo(ctx, entityName, fieldName.split("\\."));
    }

    public static PropertyInfo getPropertyInfo(Context ctx, String entityName, String[] fieldNames) {
        String fieldName;
        if (fieldNames == null || StringUtils.isEmpty((String)entityName)) {
            return null;
        }
        PropertyInfo propertyInfo = null;
        String[] stringArray = fieldNames;
        int n = stringArray.length;
        for (int i = 0; i < n && (propertyInfo = EntityUtil.getPropertyInfo(ctx, entityName, fieldName = stringArray[i])) != null; ++i) {
            if (!(propertyInfo instanceof LinkPropertyInfo)) continue;
            entityName = EntityUtil.getEntityNameByPropertyInfo(ctx, entityName, propertyInfo);
        }
        return propertyInfo;
    }

    public static String getEntityNameByPropertyInfo(Context ctx, String entityName, PropertyInfo propertyInfo) {
        String subEntityName = null;
        if (propertyInfo instanceof LinkPropertyInfo) {
            if (((LinkPropertyInfo)propertyInfo).getRelationship() != null && ((LinkPropertyInfo)propertyInfo).getRelationship().getSupplierObject() != null) {
                subEntityName = ((LinkPropertyInfo)propertyInfo).getRelationship().getSupplierObject().getFullName();
                if (entityName.equals(subEntityName)) {
                    subEntityName = ((LinkPropertyInfo)propertyInfo).getRelationship().getClientObject().getFullName();
                }
            } else {
                logger.info((Object)("property " + propertyInfo.getName() + " cannot find relationship or relationship's supplierObject"));
            }
        }
        return subEntityName;
    }

    public static String getEntityTableName(Context ctx, String entityName) {
        if (StringUtils.isEmpty((String)entityName)) {
            return null;
        }
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)new MetaDataPK(entityName));
        return entityInfo.getTable().getName();
    }

    public static <T> T getNewObjectInfoWithId(T info, String id) {
        if (!(info instanceof CoreBaseInfo) || StringUtils.isEmpty((String)id)) {
            return info;
        }
        ((CoreBaseInfo)info).setId(BOSUuid.read((String)id));
        return info;
    }

    public static Object getPropertyValue(Object model, String key) {
        Object result = null;
        if (StringUtils.isEmpty((String)key)) {
            return null;
        }
        if (null != model && model instanceof IObjectValue) {
            String[] keys;
            IObjectValue obj = (IObjectValue)model;
            if (key.indexOf(".") == -1) {
                return obj.get(key);
            }
            IObjectValue tempCoreBase = obj;
            IObjectCollection tempObjectCollection = null;
            for (String k : keys = key.split("\\.")) {
                if (tempCoreBase == null) {
                    return null;
                }
                result = tempCoreBase.get(k);
                if (null == result) {
                    return null;
                }
                if (result instanceof IObjectValue) {
                    tempCoreBase = (CoreBaseInfo)result;
                    continue;
                }
                if (!(result instanceof IObjectCollection)) break;
                tempObjectCollection = (IObjectCollection)result;
                tempCoreBase = tempObjectCollection.getObject(0);
            }
            return result;
        }
        if (null == model || model instanceof IObjectCollection) {
            // empty if block
        }
        return null;
    }

    public static CoreBaseInfo createBlankCoreObject(Context ctx, String entityFullName) throws BOSException {
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        MetaDataPK metaDataPK = MetaDataPK.create((String)entityFullName);
        EntityObjectInfo eoInfo = loader.getEntity((IMetaDataPK)metaDataPK);
        String valueClassName = eoInfo.getObjectValueClass();
        CoreBaseInfo info = null;
        try {
            Class<?> c = Class.forName(valueClassName);
            Constructor<?> cst = c.getConstructor(new Class[0]);
            info = (CoreBaseInfo)cst.newInstance(new Object[0]);
            if (info instanceof DataBaseCustomInfo) {
                ((DataBaseCustomInfo)info).setBOSType(eoInfo.getType());
            } else if (info instanceof BaseItemCustomInfo) {
                ((BaseItemCustomInfo)info).setBOSType(eoInfo.getType());
            } else if (info instanceof CoreBillBaseCustomInfo) {
                ((CoreBillBaseCustomInfo)info).setBOSType(eoInfo.getType());
            } else if (eoInfo.isDynamic() && info instanceof ICommonBOSType) {
                ICommonBOSType commonObject = (ICommonBOSType)info;
                commonObject.setBOSType(eoInfo.getType());
                commonObject.setPK((IMetaDataPK)metaDataPK);
            }
        }
        catch (Exception e) {
            BOSException exception = new BOSException(SHRServerResource.getString((String)"com.kingdee.shr.base.syssetting.CommonserviceResource", (String)"creat_object_fails", (Context)ctx), (Throwable)e);
            throw exception;
        }
        return info;
    }

    public static ICoreBase getBizInterface(Context ctx, String entityName) throws BOSException {
        return null == ctx ? (ICoreBase)BOSObjectFactory.createRemoteCommonBOSObject((IMetaDataPK)MetaDataPK.create((String)entityName)) : (ICoreBase)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)entityName));
    }

    public static Object getEnumByAlias(String enumSource, Object name) {
        List enumList = MetaDataUtil.getEnumList((String)enumSource);
        int size = enumList.size();
        for (int i = 0; i < size; ++i) {
            Enum objEnum = (Enum)enumList.get(i);
            if (!objEnum.getAlias().equals(name)) continue;
            return objEnum;
        }
        return null;
    }
}

