/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.message.common;

import com.kingdee.bos.message.common.IllegalStreamException;
import com.kingdee.bos.message.common.KDDiskAttachment;
import com.kingdee.bos.message.common.KDMemAttachment;
import com.kingdee.bos.message.common.KDMessage;
import com.kingdee.bos.message.common.KDMessageAddress;
import com.kingdee.bos.message.common.KDMessageAttachment;
import com.kingdee.bos.message.common.KDMessageConverter;
import com.kingdee.bos.message.common.KDMessageType;
import com.kingdee.bos.message.common.KDMimeType;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class KDMessageConverterImpl
implements KDMessageConverter {
    private static final int FILE_BLOCK_SIZE = 4096;
    private static final String CHARSETNAME = "UTF-8";
    private static final int MAX_FILE_SIZE = 40960;

    public KDMessage importMessage(InputStream in) throws IllegalStreamException, IOException {
        DataInputStream ins = new DataInputStream(in);
        if (ins.readInt() == 0) {
            return null;
        }
        return this.readMessage(ins);
    }

    public void exportMessage(KDMessage msg, OutputStream outStream) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bos);
        this.writeMessage(msg, out);
        byte[] bytes = bos.toByteArray();
        int length = bytes.length;
        out = new DataOutputStream(outStream);
        out.writeInt(length);
        out.write(bytes);
        out.flush();
    }

    private void writeMessage(KDMessage msg, DataOutputStream out) throws IOException {
        if (msg == null) {
            return;
        }
        this.writeMsgHead(out, msg);
        this.writeMsgBody(out, msg);
        this.writeAddrBlock(out, msg);
        this.writeAccessories(out, msg);
        out.flush();
    }

    private KDMessage readMessage(DataInputStream ins) throws IOException, IllegalStreamException {
        KDMessage msg = new KDMessage();
        msg = this.readMsgHead(ins, msg);
        msg = this.readMsgBody(ins, msg);
        msg = this.readAddrBlock(ins, msg);
        this.readAccessories(ins, msg);
        return msg;
    }

    private void writeMsgHead(DataOutputStream out, KDMessage msg) throws IOException {
        int type = msg.getType().getIntValue();
        out.writeInt(type);
        out.writeInt(msg.getPriority());
        String bizName = msg.getBizName();
        if (bizName == null) {
            out.writeInt(0);
        } else {
            out.writeInt(bizName.length());
            out.write(bizName.getBytes(CHARSETNAME));
        }
        out.writeInt(msg.getMimeType().getValue());
        out.writeInt(0);
        out.writeInt(0);
        out.writeInt(0);
    }

    private KDMessage readMsgHead(DataInputStream ins, KDMessage msg) throws IOException, IllegalStreamException {
        msg.setType(KDMessageType.create(ins.readInt()));
        msg.setPriority(ins.readInt());
        int bizNameLen = ins.readInt();
        if (bizNameLen != 0) {
            byte[] bytes = this.getBytes(ins, bizNameLen);
            msg.setBizName(new String(bytes, CHARSETNAME));
        }
        int mimeType = ins.readInt();
        msg.setMimeType(KDMimeType.create(mimeType));
        ins.readInt();
        ins.readInt();
        ins.readInt();
        return msg;
    }

    private void writeMsgBody(DataOutputStream out, KDMessage msg) throws IOException {
        int idLen = msg.getId() == null ? 0 : msg.getId().getBytes().length;
        out.writeInt(idLen);
        if (msg.getId() != null) {
            out.write(msg.getId().getBytes());
        }
        int relativeIdLen = msg.getRelativeId() == null ? 0 : msg.getRelativeId().getBytes().length;
        out.writeInt(relativeIdLen);
        if (msg.getRelativeId() != null) {
            out.write(msg.getRelativeId().getBytes());
        }
        int customIdLen = msg.getCustomId() == null ? 0 : msg.getCustomId().getBytes().length;
        out.writeInt(customIdLen);
        if (msg.getCustomId() != null) {
            out.write(msg.getCustomId().getBytes());
        }
        int titleLen = msg.getTitle() == null ? 0 : msg.getTitle().getBytes(CHARSETNAME).length;
        out.writeInt(titleLen);
        if (msg.getTitle() != null) {
            out.write(msg.getTitle().getBytes(CHARSETNAME));
        }
        int txtBodyLen = msg.getContent() == null ? 0 : msg.getContent().getBytes(CHARSETNAME).length;
        out.writeInt(txtBodyLen);
        if (msg.getContent() != null) {
            out.write(msg.getContent().getBytes(CHARSETNAME));
        }
        out.flush();
    }

    private KDMessage readMsgBody(DataInputStream ins, KDMessage msg) throws IOException, IllegalStreamException {
        int txtBodyLen;
        int titleLen;
        int customIdLen;
        int relativeIdLen;
        int idLen = ins.readInt();
        if (idLen > 0) {
            byte[] bytes = this.getBytes(ins, idLen);
            msg.setId(new String(bytes));
        }
        if ((relativeIdLen = ins.readInt()) > 0) {
            byte[] bytes = this.getBytes(ins, relativeIdLen);
            msg.setRelativeId(new String(bytes));
        }
        if ((customIdLen = ins.readInt()) > 0) {
            byte[] bytes = this.getBytes(ins, customIdLen);
            msg.setCustomId(new String(bytes));
        }
        if ((titleLen = ins.readInt()) > 0) {
            byte[] bytes = this.getBytes(ins, titleLen);
            msg.setTitle(new String(bytes, CHARSETNAME));
        }
        if ((txtBodyLen = ins.readInt()) > 0) {
            byte[] bytes = this.getBytes(ins, txtBodyLen);
            msg.setContent(new String(bytes, CHARSETNAME));
        }
        return msg;
    }

    private void writeAccessories(DataOutputStream out, KDMessage msg) throws IOException {
        if (msg.getAttachments() == null) {
            out.writeInt(0);
        } else {
            out.writeInt(msg.getAttachments().length);
            for (int i = 0; i < msg.getAttachments().length; ++i) {
                this.writeAttachment(out, msg.getAttachments()[i]);
            }
        }
    }

    private KDMessage readAccessories(DataInputStream ins, KDMessage msg) throws IOException {
        int count = ins.readInt();
        KDMessageAttachment[] accessories = null;
        if (count > 0) {
            accessories = new KDMessageAttachment[count];
            for (int i = 0; i < count; ++i) {
                accessories[i] = this.readAttachment(ins, msg.getId());
            }
        }
        msg.setAttachments(accessories);
        return msg;
    }

    private void writeAttachment(DataOutputStream dos, KDMessageAttachment attachment) throws IOException {
        if (attachment == null) {
            dos.writeInt(0);
            dos.flush();
            return;
        }
        dos.writeInt(1);
        String fileName = attachment.getName();
        int fileNameLen = fileName.getBytes(CHARSETNAME).length;
        dos.writeInt(fileNameLen);
        if (fileNameLen == 0) {
            dos.flush();
            return;
        }
        dos.write(fileName.getBytes(CHARSETNAME));
        int fileSize = attachment.getSize();
        dos.writeInt(fileSize);
        dos.flush();
        if (fileSize == 0) {
            return;
        }
        InputStream ins = attachment.getInputStream();
        if (fileSize > 0 && ins != null) {
            byte[] datas;
            int readed;
            while ((readed = ins.read(datas = new byte[4096])) != -1) {
                dos.write(datas, 0, readed);
                dos.flush();
            }
            ins.close();
        }
    }

    private KDMessageAttachment readAttachment(InputStream ins, String id) throws IOException {
        KDMessageAttachment attachment = null;
        DataInputStream dis = new DataInputStream(ins);
        int isNull = dis.readInt();
        if (isNull == 0) {
            return null;
        }
        int fileNameLength = dis.readInt();
        if (fileNameLength == 0) {
            return attachment;
        }
        byte[] bytes = new byte[]{};
        try {
            bytes = this.getBytes(ins, fileNameLength);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String fileName = new String(bytes, CHARSETNAME);
        int fileSize = dis.readInt();
        if (fileSize == 0) {
            return attachment;
        }
        attachment = fileSize > 40960 ? KDDiskAttachment.getAttachment(fileName, id) : new KDMemAttachment();
        attachment.setName(fileName);
        attachment.setData(this.getBytes(ins, fileSize));
        return attachment;
    }

    private void writeAddrBlock(DataOutputStream out, KDMessage msg) throws IOException {
        this.writeMsgAddress(out, msg.getSender());
        if (msg.getSender() == null) {
            out.writeInt(0);
        } else if (msg.getReceivers() == null) {
            out.writeInt(0);
        } else {
            out.writeInt(msg.getReceivers().length);
            for (int i = 0; i < msg.getReceivers().length; ++i) {
                this.writeMsgAddress(out, msg.getReceivers()[i]);
            }
        }
        out.flush();
    }

    private KDMessage readAddrBlock(DataInputStream ins, KDMessage msg) throws IOException, IllegalStreamException {
        KDMessageAddress sender = this.readMsgAddress(ins);
        msg.setSender(sender);
        int receiversLen = ins.readInt();
        if (receiversLen > 0) {
            KDMessageAddress[] receivers = new KDMessageAddress[receiversLen];
            for (int i = 0; i < receiversLen; ++i) {
                receivers[i] = this.readMsgAddress(ins);
            }
            msg.setReceivers(receivers);
        } else {
            msg.setReceivers(new KDMessageAddress[0]);
        }
        return msg;
    }

    private void writeMsgAddress(DataOutputStream out, KDMessageAddress address) throws IOException {
        if (address == null) {
            out.writeInt(0);
            return;
        }
        out.writeInt(1);
        out.writeInt(0);
        out.writeInt(address.getLevel());
        String id = address.getDetail();
        if (id == null) {
            out.writeInt(0);
        } else {
            int length = id.getBytes(CHARSETNAME).length;
            out.writeInt(length);
            out.write(id.getBytes(CHARSETNAME));
        }
        String detail = address.getDeviceName();
        if (detail == null) {
            out.writeInt(0);
        } else {
            int length = detail.getBytes(CHARSETNAME).length;
            out.writeInt(length);
            out.write(detail.getBytes(CHARSETNAME));
        }
    }

    private KDMessageAddress readMsgAddress(DataInputStream ins) throws IOException, IllegalStreamException {
        int detailLen;
        KDMessageAddress address = null;
        int isNull = ins.readInt();
        if (isNull == 0) {
            return address;
        }
        ins.readInt();
        int level = ins.readInt();
        int idLen = ins.readInt();
        String deviceType = "";
        String detail = "";
        if (idLen > 0) {
            byte[] bytes = this.getBytes(ins, idLen);
            detail = new String(bytes);
        }
        if ((detailLen = ins.readInt()) > 0) {
            byte[] bytes = this.getBytes(ins, detailLen);
            deviceType = new String(bytes, CHARSETNAME);
        }
        address = new KDMessageAddress(deviceType, detail);
        address.setLevel(level);
        return address;
    }

    private final byte[] getBytes(InputStream ins, int size) throws IOException {
        int prepare;
        int readed;
        byte[] bytes = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (int leaved = size; leaved > 0 && (readed = ins.read(bytes = new byte[prepare = leaved > 4096 ? 4096 : leaved])) != -1; leaved -= readed) {
            bos.write(bytes, 0, readed);
        }
        return bos.toByteArray();
    }
}

