/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.startup;

import com.kingdee.eas.client.startup.JnlpFileDeleteUtil;
import com.kingdee.eas.client.startup.classloader.ClassLoaderListenerFactory;
import com.kingdee.eas.client.startup.classloader.SmartClassLoader;
import com.kingdee.eas.client.startup.config.ClientConfigUtil;
import com.kingdee.eas.client.startup.exception.ConfigException;
import com.kingdee.eas.client.startup.exception.EASClientException;
import com.kingdee.eas.client.startup.exception.ExceptionHandler;
import com.kingdee.eas.client.startup.log.ClientStartLogger;
import com.kingdee.eas.client.startup.update.EasClientExplicitUpdater;
import com.kingdee.eas.client.startup.update.check.EASClientFile;
import com.kingdee.eas.client.startup.update.check.EASClientFileList;
import com.kingdee.eas.client.startup.update.check.EASJnlpCacheEntryManager;
import com.kingdee.eas.client.startup.util.HttpUtil;
import com.kingdee.eas.client.startup.util.URLUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientUpdater {
    private static final Logger logger = ClientStartLogger.getLogger();

    public static Map<EASClientFile, List<String>> update() {
        try {
            HttpUtil.testEasUpdateServer();
            EasClientExplicitUpdater explicitUpdater = EasClientExplicitUpdater.getInstance();
            ClientUpdater.changeUpdateServer();
            HttpUtil.testDownloadServer();
            ClientUpdater.initClassLoader();
            return explicitUpdater.update();
        }
        catch (Throwable t) {
            EASClientException ex = ExceptionHandler.handle(t);
            logger.error((Object)("\u51fa\u9519\u5566\uff1a" + ex.getSolution()), (Throwable)ex);
            JnlpFileDeleteUtil.delete();
            throw ex;
        }
    }

    private static void changeUpdateServer() {
        File baseDir = ClientConfigUtil.getLocalDirFile();
        File serverCacheBaseDir = new File(baseDir, "cache");
        File file = new File(serverCacheBaseDir, "eas.jnlp");
        EASClientFileList serverCache = EASJnlpCacheEntryManager.load(file);
        URL href = serverCache.getHref();
        String easUpdateServer = ClientConfigUtil.getUpdateServer();
        URL updateServerUrl = URLUtil.convertString2URL(easUpdateServer);
        URL newuUdateServerUrl = null;
        try {
            newuUdateServerUrl = new URL(updateServerUrl.getProtocol(), href.getHost(), href.getPort(), updateServerUrl.getFile());
        }
        catch (MalformedURLException e) {
            throw EASClientException.convert(e);
        }
        String newUpdateServer = newuUdateServerUrl.toString();
        logger.info((Object)("\u65b0\u7684\u66f4\u65b0\u5730\u5740\u4e3a" + newUpdateServer + ",\u6839\u636e" + file.getAbsolutePath() + "\u4e2d\u7684<jnlp>\u7684codebase\u5c5e\u6027"));
        ClientConfigUtil.changeUpdateServer(newUpdateServer);
    }

    private static void initClassLoader() {
        SmartClassLoader.ClassLoaderListener cll = ClassLoaderListenerFactory.getInstance();
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        if (!(systemClassLoader instanceof SmartClassLoader)) {
            ConfigException ex = new ConfigException("\u9519\u8bef\u7684classloader" + systemClassLoader.getClass().getName());
            ex.setSolution("\u8bf7\u8054\u7cfb\u6280\u672f\u652f\u6301\u4eba\u5458,\u786e\u4fddclassloader\u662f" + SmartClassLoader.class.getName());
            throw ex;
        }
        SmartClassLoader applicationClassLoader = (SmartClassLoader)ClassLoader.getSystemClassLoader();
        applicationClassLoader.setClassLoaderListener(cll);
    }
}

