/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.startup.update.check;

import com.kingdee.eas.client.startup.config.ClientConfigUtil;
import com.kingdee.eas.client.startup.exception.EASClientException;
import com.kingdee.eas.client.startup.log.ClientStartLogger;
import com.kingdee.eas.client.startup.update.check.AbstractCacheStateImpl;
import com.kingdee.eas.client.startup.update.check.CreateJNLPResource;
import com.kingdee.eas.client.startup.update.check.DownloadTraceInfo;
import com.kingdee.eas.client.startup.update.check.DownloadTraceUtil;
import com.kingdee.eas.client.startup.update.check.EASClientFile;
import com.kingdee.eas.client.startup.update.check.EASJnlpCacheEntryManager;
import com.kingdee.eas.client.startup.update.check.JnlpServerCtrlParameter;
import com.kingdee.eas.client.startup.update.check.JnlpServerCtrlParamsUtils;
import com.kingdee.eas.client.startup.update.check.JnlpVersionInfo;
import com.kingdee.eas.client.startup.update.check.JnlpVersionUtil;
import com.kingdee.eas.client.startup.update.download.EasClientDownloaderFactory;
import com.kingdee.eas.client.startup.update.download.IEasClientDownloader;
import com.kingdee.eas.client.startup.update.download.URLUtils;
import com.kingdee.eas.client.startup.util.StringUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheStateImpl
extends AbstractCacheStateImpl {
    private static final Logger logger = ClientStartLogger.getLogger();
    private String localResxFilted = "/logs/,/cache/,/classloader/kdclassloader.jar,/classloader/eas.policy,onDemandTrace.properties,update.properties";
    private String relativeResxPaths = "/";
    private JnlpServerCtrlParameter ctrlParams = null;
    private DownloadTraceInfo traceInfo = null;

    public CacheStateImpl(String downloadAddress, String fileName, String modifyFileName) {
        super(downloadAddress, fileName);
        this.traceInfo = DownloadTraceUtil.load(modifyFileName);
        this.loadServerCache();
        this.ctrlParams = JnlpServerCtrlParamsUtils.parse(this.serverCache.getHref());
        this.loadLocalCacheFile();
        this.compare();
    }

    private void loadServerCache() {
        JnlpVersionInfo info;
        File baseDir = ClientConfigUtil.getLocalDirFile();
        File serverCacheBaseDir = new File(baseDir, "cache");
        if (!serverCacheBaseDir.exists()) {
            serverCacheBaseDir.mkdirs();
        }
        if (!JnlpVersionUtil.isNewestJnlp(info = JnlpVersionUtil.downloadJnlpVersion(), this.traceInfo)) {
            this.downloadFile(serverCacheBaseDir);
            this.storeJnlpVersion(info);
            DownloadTraceUtil.storeTraceInfo(this.traceInfo);
        }
        File jnlpFile = new File(serverCacheBaseDir, this.fileName);
        try {
            this.serverCache = EASJnlpCacheEntryManager.load(jnlpFile);
        }
        catch (Throwable ex) {
            logger.info((Object)" Cache\u76ee\u5f55\u4e0b\u7684jnlp\u6587\u4ef6\u89e3\u6790\u9519\u8bef,\u53ef\u80fd\u662f\u6587\u4ef6\u635f\u574f\u6216\u8005\u88ab\u4eba\u4e3a\u4fee\u6539,\u91cd\u65b0\u4eceServer\u4e0b\u8f7d ...");
            this.downloadFile(serverCacheBaseDir);
            this.storeJnlpVersion(info);
            DownloadTraceUtil.storeTraceInfo(this.traceInfo);
            this.serverCache = EASJnlpCacheEntryManager.load(jnlpFile);
        }
        this.dirtyResources.clear();
        List<EASClientFile> allCacheEntries = this.serverCache.getCacheEntries();
        this.dirtyResources.addAll(allCacheEntries);
    }

    private void downloadFile(File serverCacheBaseDir) {
        File file = new File(serverCacheBaseDir, this.fileName);
        IEasClientDownloader downloader = EasClientDownloaderFactory.getDownloader("http");
        downloader.downloadFile(this.downloadAddress, file);
    }

    private void storeJnlpVersion(JnlpVersionInfo info) {
        this.traceInfo.setFulljnlpversion(info.getFulljnlpVersion());
        this.traceInfo.setOndemandjnlpversion(info.getOndemandJnlpVersion());
    }

    private void loadLocalCacheFile() {
        File baseDir = ClientConfigUtil.getLocalDirFile();
        File fl = new File(baseDir, this.fileName);
        if (!this.traceInfo.isDownloadCompleted() || !fl.exists() || this.reGenLocalJnlp()) {
            if (this.ctrlParams.getResItemsExcluded() != null && !"".equals(this.ctrlParams.getResItemsExcluded())) {
                this.localResxFilted = this.ctrlParams.getResItemsExcluded().replaceAll(this.ctrlParams.getSeperator(), ",");
            }
            if (this.ctrlParams.getResPaths() != null && !"".equals(this.ctrlParams.getResPaths())) {
                this.relativeResxPaths = this.ctrlParams.getResPaths().replaceAll(this.ctrlParams.getSeperator(), ",");
            }
            CreateJNLPResource.createLocalJNLPResource(baseDir, this.traceInfo.getTraceFileName(), this.fileName, this.localResxFilted, this.relativeResxPaths);
            this.traceInfo.setJnlpVersionFiles(this.fileName);
            this.traceInfo.setDownloadCompleted(true);
            DownloadTraceUtil.storeTraceInfo(this.traceInfo);
        }
        File jnlpFile = new File(baseDir, this.fileName);
        this.localCache = EASJnlpCacheEntryManager.load(jnlpFile);
    }

    private boolean reGenLocalJnlp() {
        boolean localJnlpIsCurrentVersion = "0.0.0".equals(this.traceInfo.getVersion());
        logger.info((Object)("\u672c\u5730\u7248\u672c\u6587\u4ef6\u7684\u7248\u672c\u53f7\u662f\u5426\u662f\u6700\u65b0\u7684:" + localJnlpIsCurrentVersion));
        String reGenLocalJnlpStr = URLUtils.getParameter(this.serverCache.getHref().getQuery(), "reGenLocalJnlp");
        boolean reGenLocalJnlp = "true".equals(reGenLocalJnlpStr);
        logger.info((Object)("\u670d\u52a1\u7aef\u63a7\u5236\u5f00\u5173\uff0c\u975e\u5f53\u524d\u7248\u672c\u7684\u672c\u5730jnlp\u6587\u4ef6\u662f\u5426\u9700\u8981\u91cd\u65b0\u751f\u6210:" + reGenLocalJnlp));
        boolean result = !localJnlpIsCurrentVersion && reGenLocalJnlp;
        logger.info((Object)("\u662f\u5426\u91cd\u65b0\u751f\u6210\u672c\u5730jnlp\u6587\u4ef6:" + result));
        return result;
    }

    private void compare() {
        int size = this.serverCache.getCacheEntries().size();
        if (size == 0) {
            EASClientException ex = new EASClientException("\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\uff0c\u53ef\u80fd\u662f\u66f4\u65b0\u529f\u80fd\u7684\u670d\u52a1\u7aef\u95ee\u9898\uff0c\u8bf7\u68c0\u67e5" + this.downloadAddress);
            ex.setSolution("\u8bf7\u8054\u7cfb\u6280\u672f\u652f\u6301\u4eba\u5458\uff0c\u68c0\u67e5" + this.downloadAddress);
            throw ex;
        }
        Map<String, EASClientFile> localResources = this.toMap(this.localCache.getCacheEntries());
        String[] resExclude = null;
        Iterator<Object> it = this.serverCache.getCacheEntries().iterator();
        String temp = null;
        while (it.hasNext()) {
            EASClientFile entry = it.next();
            this.checkResource(localResources, entry);
        }
        if (this.ctrlParams != null) {
            resExclude = this.ctrlParams.getResItemsExcluded().replaceAll(this.ctrlParams.getSeperator(), ",").split(",");
        }
        if (!localResources.isEmpty()) {
            it = localResources.entrySet().iterator();
            EASClientFile localEntry = null;
            while (it.hasNext()) {
                localEntry = (EASClientFile)((Map.Entry)it.next()).getValue();
                temp = localEntry.getPath();
                if (resExclude != null && this.isResExcludeRes(resExclude, temp)) continue;
                this.deletedResources.add(localEntry);
            }
        }
    }

    private Map<String, EASClientFile> toMap(List<EASClientFile> cacheEntries) {
        HashMap<String, EASClientFile> map = new HashMap<String, EASClientFile>();
        for (EASClientFile entry : cacheEntries) {
            map.put(entry.getPath(), entry);
        }
        return map;
    }

    private boolean isResExcludeRes(String[] resExclude, String temp) {
        for (int i = 0; i < resExclude.length; ++i) {
            String resExcludeRes = resExclude[i];
            if (temp.indexOf(resExcludeRes) < 0) continue;
            return true;
        }
        return false;
    }

    private void checkResource(Map entries, EASClientFile serverEntry) {
        String href = serverEntry.getPath();
        String serverMD5 = serverEntry.getMd5Version();
        String serverMD5New = serverEntry.getMd5VersionNew();
        if (StringUtil.isEmptyValue(serverMD5)) {
            throw new EASClientException("\u670d\u52a1\u7aef\u7684jnlp\u6587\u4ef6\u4e2d" + serverEntry.getPath().toString() + "\u7684md5\u503c\u4e3a\u7a7a");
        }
        if (StringUtil.isEmptyValue(serverMD5New)) {
            throw new EASClientException("\u670d\u52a1\u7aef\u7684jnlp\u6587\u4ef6\u4e2d" + serverEntry.getPath().toString() + "\u7684new md5\u503c\u4e3a\u7a7a");
        }
        if (entries.containsKey(href)) {
            EASClientFile localResource = (EASClientFile)entries.get(href);
            String localMD5 = localResource.getMd5Version();
            String localMD5New = localResource.getMd5VersionNew();
            if (StringUtil.isEmptyValue(localMD5)) {
                throw new EASClientException("\u672c\u5730\u626b\u63cf\u751f\u6210\u7684jnlp\u6587\u4ef6\u4e2d" + localResource.getPath().toString() + "\u7684md5\u503c\u4e3a\u7a7a");
            }
            if (serverMD5.equals(localMD5) || serverMD5New.equals(localMD5New)) {
                this.dirtyResources.remove(serverEntry);
            }
            entries.remove(href);
        }
    }

    @Override
    public void updateSucess(List<EASClientFile> successEntries) {
        if (successEntries == null) {
            return;
        }
        if (successEntries.isEmpty()) {
            return;
        }
        for (EASClientFile success : successEntries) {
            String path = success.getPath();
            EASClientFile serverEntry = this.serverCache.getResourceInfo(path);
            if (null == serverEntry) continue;
            EASClientFile localEntry = this.localCache.getResourceInfo(path);
            if (null == localEntry) {
                this.localCache.addResourceInfo(success);
                continue;
            }
            localEntry.setMd5Version(success.getMd5Version());
        }
        CreateJNLPResource.store(this.traceInfo.getJnlpVersionFiles(), this.localCache.getCacheEntries());
        this.traceInfo.setDownloadCompleted(true);
        DownloadTraceUtil.storeTraceInfo(this.traceInfo);
    }

    @Override
    public void deleteSucess(List<EASClientFile> deletedEntries) {
        if (deletedEntries == null) {
            return;
        }
        if (deletedEntries.isEmpty()) {
            return;
        }
        for (EASClientFile deleted : deletedEntries) {
            String path = deleted.getPath();
            EASClientFile localEntry = this.localCache.getResourceInfo(path);
            if (null == localEntry) continue;
            this.localCache.removeResourceInfo(deleted);
        }
        CreateJNLPResource.store(this.traceInfo.getJnlpVersionFiles(), this.localCache.getCacheEntries());
        this.traceInfo.setDownloadCompleted(true);
        DownloadTraceUtil.storeTraceInfo(this.traceInfo);
    }

    @Override
    public void startTrace() {
        this.traceInfo.setDownloadCompleted(false);
        DownloadTraceUtil.storeTraceInfo(this.traceInfo);
    }
}

