/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.startup.update.check;

import com.kingdee.eas.client.startup.config.ClientConfigUtil;
import com.kingdee.eas.client.startup.exception.EASClientException;
import com.kingdee.eas.client.startup.log.ClientStartLogger;
import com.kingdee.eas.client.startup.update.check.DownloadTraceInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class DownloadTraceUtil {
    private static final Logger logger = ClientStartLogger.getLogger();

    public static void storeTraceInfo(DownloadTraceInfo traceInfo) {
        Properties prop = DownloadTraceUtil.toProp(traceInfo);
        DownloadTraceUtil.modifyDownLoadFiles(traceInfo.getBaseDir(), traceInfo.getTraceFileName(), prop);
    }

    private static Properties toProp(DownloadTraceInfo traceInfo) {
        Properties properties = new Properties();
        properties.setProperty("downloadCompleted", new Boolean(traceInfo.isDownloadCompleted()).toString());
        properties.setProperty("jnlpVersionFiles", traceInfo.getJnlpVersionFiles());
        properties.setProperty("ondemandjnlpversion", traceInfo.getOndemandjnlpversion());
        properties.setProperty("fulljnlpversion", traceInfo.getFulljnlpversion());
        properties.setProperty("Version", "0.0.0");
        return properties;
    }

    public static DownloadTraceInfo load(String updateTraceFileName) {
        File baseDir = ClientConfigUtil.getLocalDirFile();
        File updatePropertiesFile = new File(baseDir, updateTraceFileName);
        Properties properties = null;
        properties = !updatePropertiesFile.exists() ? DownloadTraceUtil.createDefaultClientUpdateTraceFile(baseDir, updateTraceFileName) : DownloadTraceUtil.readUpdatePropertiesFile(baseDir, updateTraceFileName);
        DownloadTraceInfo info = DownloadTraceUtil.toTraceInfo(baseDir, updateTraceFileName, properties);
        return info;
    }

    private static DownloadTraceInfo toTraceInfo(File baseDir, String updateTraceFileName, Properties properties) {
        String jnlpVersionFiles = properties.getProperty("jnlpVersionFiles", "eas.jnlp");
        Object object = properties.get("downloadCompleted");
        boolean downloadCompleted = new Boolean((String)object);
        String ondemandjnlpversion = properties.getProperty("ondemandjnlpversion", new Long(0L).toString());
        String fulljnlpversion = properties.getProperty("fulljnlpversion", new Long(0L).toString());
        String version = properties.getProperty("Version", "");
        DownloadTraceInfo info = new DownloadTraceInfo(baseDir, updateTraceFileName, downloadCompleted);
        info.setFulljnlpversion(fulljnlpversion);
        info.setOndemandjnlpversion(ondemandjnlpversion);
        info.setJnlpVersionFiles(jnlpVersionFiles);
        info.setVersion(version);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties readUpdatePropertiesFile(File baseDir, String updateTraceFileName) {
        File updatePropertiesFile = new File(baseDir, updateTraceFileName);
        Properties properties = new Properties();
        try {
            FileInputStream inputStream = null;
            File file = updatePropertiesFile;
            synchronized (file) {
                inputStream = new FileInputStream(updatePropertiesFile);
            }
            properties.load(inputStream);
            inputStream.close();
        }
        catch (Throwable t) {
            throw new EASClientException("\u8bfb\u53d6\u6587\u4ef6" + updatePropertiesFile.getAbsolutePath() + "\u51fa\u9519", t);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void modifyDownLoadFiles(File baseDir, String updateTraceFileName, Properties properties) {
        File updateFile = new File(baseDir, updateTraceFileName);
        try {
            if (!updateFile.exists()) {
                updateFile.createNewFile();
            }
            File file = updateFile;
            synchronized (file) {
                FileOutputStream fos = new FileOutputStream(updateFile);
                properties.store(fos, null);
                fos.close();
            }
        }
        catch (Throwable t) {
            throw new EASClientException("\u4fdd\u5b58\u6587\u4ef6" + updateFile.getAbsolutePath() + "\u51fa\u9519", t);
        }
    }

    private static Properties createDefaultClientUpdateTraceFile(File baseDir, String updateTraceFileName) {
        File defaultClientUpdateTraceFile = new File(baseDir, updateTraceFileName);
        Properties properties = new Properties();
        if (defaultClientUpdateTraceFile.exists()) {
            defaultClientUpdateTraceFile.delete();
        }
        try {
            defaultClientUpdateTraceFile.createNewFile();
            FileOutputStream outputStream = new FileOutputStream(defaultClientUpdateTraceFile);
            properties.setProperty("downloadCompleted", "false");
            properties.setProperty("jnlpVersionFiles", "eas.jnlp");
            properties.setProperty("ondemandjnlpversion", new Long(0L).toString());
            properties.setProperty("fulljnlpversion", new Long(0L).toString());
            properties.setProperty("Version", "0.0.0");
            properties.store(outputStream, null);
            outputStream.close();
        }
        catch (Throwable t) {
            throw new EASClientException("\u521b\u5efa\u6587\u4ef6" + defaultClientUpdateTraceFile.getAbsolutePath() + "\u51fa\u9519", t);
        }
        return properties;
    }
}

