/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.startup.update.check;

import com.kingdee.eas.client.startup.config.ClientConfigUtil;
import com.kingdee.eas.client.startup.log.ClientStartLogger;
import com.kingdee.eas.client.startup.update.check.EASClientFile;
import com.kingdee.eas.client.startup.update.check.ICacheState;
import java.io.File;
import java.util.List;
import org.apache.log4j.Logger;

public class EASClientFileDeleteUtil {
    private static final String logTitle = "[\u5220\u9664\u591a\u4f59\u7684\u6587\u4ef6]";
    private static final Logger logger = ClientStartLogger.getLogger();

    static void delete(ICacheState cacheState) {
        cacheState.deleteSucess(cacheState.getDeletedResources());
        List<EASClientFile> files2Delete = cacheState.getDeletedResources();
        int size = files2Delete.size();
        logger.info((Object)("[\u5220\u9664\u591a\u4f59\u7684\u6587\u4ef6]\u9700\u8981\u5220\u9664\u7684\u591a\u4f59\u6587\u4ef6\u6709" + size + "\u4e2a"));
        if (size == 0) {
            return;
        }
        for (EASClientFile clientFile : files2Delete) {
            EASClientFileDeleteUtil.delete(clientFile);
        }
        logger.info((Object)("[\u5220\u9664\u591a\u4f59\u7684\u6587\u4ef6]\u5220\u9664\u4e86" + files2Delete.size() + "\u4e2a\u591a\u4f59\u7684\u6587\u4ef6: " + files2Delete));
    }

    private static boolean delete(EASClientFile clientFile) {
        File baseDir = ClientConfigUtil.getLocalDirFile();
        String fileName = clientFile.getPath();
        File localFile = new File(baseDir, fileName);
        try {
            boolean result = localFile.delete();
            if (result) {
                logger.info((Object)("[\u5220\u9664\u591a\u4f59\u7684\u6587\u4ef6]\u5220\u9664\u6210\u529f:" + localFile.getAbsolutePath()));
                return true;
            }
            logger.info((Object)("[\u5220\u9664\u591a\u4f59\u7684\u6587\u4ef6]\u5220\u9664\u5931\u8d25:" + localFile.getAbsolutePath()));
            return false;
        }
        catch (Throwable t) {
            logger.info((Object)("[\u5220\u9664\u591a\u4f59\u7684\u6587\u4ef6]\u5220\u9664\u5931\u8d25:" + localFile.getAbsolutePath()), t);
            return false;
        }
    }
}

