/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.startup.update.check;

import com.kingdee.eas.client.startup.update.check.EASClientFile;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EASClientFileList {
    private URL href;
    private final List<EASClientFile> cacheEntries = new ArrayList<EASClientFile>();
    private final Map<String, EASClientFile> cacheEntriesIndex = new HashMap<String, EASClientFile>();

    public EASClientFileList(URL href) {
        this.href = href;
    }

    public void addResourceInfo(EASClientFile entry) {
        this.cacheEntries.add(entry);
        this.cacheEntriesIndex.put(entry.getPath(), entry);
    }

    public void removeResourceInfo(EASClientFile entry) {
        String path = entry.getPath();
        this.cacheEntries.remove(this.cacheEntriesIndex.get(path));
        this.cacheEntriesIndex.remove(path);
    }

    public synchronized List<EASClientFile> getCacheEntries() {
        return this.cacheEntries;
    }

    public synchronized EASClientFile[] getResources() {
        return this.cacheEntries.toArray(new EASClientFile[0]);
    }

    public URL getHref() {
        return this.href;
    }

    public EASClientFile getResourceInfo(String path) {
        return this.cacheEntriesIndex.get(path);
    }
}

