/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.startup.update.handler.odds.config;

import com.kingdee.eas.client.startup.config.ClientConfigUtil;
import com.kingdee.eas.client.startup.exception.EASClientException;
import com.kingdee.eas.client.startup.log.ClientStartLogger;
import com.kingdee.eas.client.startup.update.handler.odds.config.PropertiesFileUtil;
import com.kingdee.eas.client.startup.util.StringUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;

class ClientOddsProperties {
    private static final Logger logger = ClientStartLogger.getLogger();
    private Properties clientOddsProperties;
    private File file;

    ClientOddsProperties() {
        String baseDirPath = ClientConfigUtil.getLocalDirPath();
        this.file = new File(baseDirPath + "/clientodds.properties");
        if (!this.file.exists()) {
            logger.warn((Object)("Properties\u6587\u4ef6[" + this.file.getAbsolutePath() + "]\u4e0d\u5b58\u5728"));
            this.clientOddsProperties = PropertiesFileUtil.createEmptyPropertiesFile(this.file, "clientOddsProperties");
        } else {
            this.clientOddsProperties = PropertiesFileUtil.read(this.file);
        }
    }

    boolean existLocalVersion(String filePath) {
        return !StringUtil.isEmptyValue(this.getLocalVersion(filePath));
    }

    String getLocalVersion(String filePath) {
        return this.clientOddsProperties.getProperty(filePath);
    }

    void update2NewVersion(String filePath, String newVersion) {
        this.clientOddsProperties.put(filePath, newVersion);
    }

    void store() {
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.file));
            this.clientOddsProperties.store(out, "clientodds.properties");
            out.flush();
            out.close();
        }
        catch (IOException e) {
            throw EASClientException.convert(e);
        }
    }
}

