/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.cloud.command.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.cloud.bean.AppInfo;
import com.kingdee.bos.cloud.bean.AppManager;
import com.kingdee.bos.cloud.command.AbstractCommand;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.mdfs.MDProject;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.ServletException;

public class AddProjectCommand
extends AbstractCommand {
    public AddProjectCommand() {
        this.setNeedLogin(false);
    }

    @Override
    public boolean doCheckValidate() throws IOException, ServletException {
        String ip = (String)this.request.getSession().getServletContext().getAttribute("bosCom_ip");
        if (!StringUtils.isEmpty((String)ip) && !ip.equals(this.request.getRemoteAddr())) {
            this.response.sendError(500, "Must request from bos.com!");
            return false;
        }
        return true;
    }

    @Override
    public void execute() throws IOException, ServletException {
        AppManager.init();
        String ip = AppManager.getLocleAddress().getHostAddress();
        String projectName = this.request.getParameter("name");
        String rpcPort = this.request.getParameter("rpcPort");
        String httpPort = this.request.getParameter("httpPort");
        String ais = this.request.getParameter("ais");
        AppInfo info = new AppInfo();
        Context ctx = new Context();
        ctx.setAIS(ais);
        ctx.setSolution("eas");
        ctx.setLocale(new Locale("zh_CN"));
        info.setContext(ctx);
        String appPath = System.getProperty("%cloud_app_root%");
        File baseRoot = new File(StringUtils.replace((String)AppManager.defaultBaseMetaRoot, (String)"%cloud_app_root%", (String)appPath));
        File projectRoot = new File(StringUtils.replace((String)AppManager.defaultProjectRoot, (String)"%cloud_app_root%", (String)appPath));
        projectRoot = new File(projectRoot, projectName);
        MDProject project = new MDProject(projectRoot, projectName, baseRoot, new File(projectRoot, "metadata"));
        info.setProject((IMDProject)project);
        info.setOrmrpcUrl("tcp://" + ip + ":" + rpcPort);
        info.setTestUrl("http://" + ip + ":" + httpPort);
        info.setSave2Disk(true);
        AppManager.add(projectName, info);
    }
}

