/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.cloud.command.impl;

import com.kingdee.bos.cloud.bean.AppManager;
import com.kingdee.bos.cloud.bean.UserManager;
import com.kingdee.bos.cloud.command.AbstractCommand;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;

public class LoginCommand
extends AbstractCommand {
    public LoginCommand() {
        this.setNeedLogin(false);
    }

    private void clearSession(HttpSession session) {
        try {
            session.removeAttribute("projectname");
            session.removeAttribute("username");
            session.removeAttribute("password");
            session.removeAttribute("appusername");
            session.removeAttribute("apppassword");
            session.removeAttribute("rpc_session_id");
            session.removeAttribute("metadata_loader");
            session.removeAttribute("mdengineinited");
            session.removeAttribute("metadata_storer");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws IOException, ServletException {
        String key;
        String password;
        String projectName = this.request.getParameter("projectname");
        String username = this.request.getParameter("username");
        if (!UserManager.checkUser(username, password = this.request.getParameter("password"))) {
            this.response.sendError(-10001, "wrong username & password");
            return;
        }
        HttpSession session = this.request.getSession();
        ServletContext context = this.request.getSession().getServletContext();
        HttpSession otherSession = (HttpSession)context.getAttribute(key = projectName + ":" + username);
        if (otherSession != null) {
            try {
                this.clearSession(otherSession);
                otherSession.setAttribute("kick_out", (Object)(this.request.getRemoteHost() + ":" + this.request.getRemoteAddr()));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        this.clearSession(session);
        if (!AppManager.checkValid(projectName, username)) {
            this.response.sendError(-10002, "current user [" + username + "] hasn't right for project [" + projectName + "]");
            return;
        }
        session.setAttribute("projectname", (Object)projectName);
        session.setAttribute("username", (Object)username);
        session.setAttribute("password", (Object)password);
        session.setMaxInactiveInterval(-1);
        context.setAttribute(key, (Object)session);
        Connection conn = null;
        String querySql = "SELECT COUNT(1) FROM KSQL_USERTABLES WHERE KSQL_TABNAME = 'T_BIM_MDVIEW'";
        String createTable = "CREATE TABLE T_BIM_MDVIEW (fProjectName varchar(255), fPath varchar(255), fMD5 varchar(40), fAlias varchar(255), fCheckOutUser varchar(255), fCheckOutTime DateTime,fCreator varchar(255), fCreateTime DateTime,fLastModifyUser varchar(255),fLastModifyTime DateTime,fDeployUser VARCHAR(255),fDeployTime DateTime,CONSTRAINT PK_BIM_MDVIEW primary key (fProjectName, fPath)); ";
        try {
            conn = this.getConnection();
            PreparedStatement pstmt = conn.prepareStatement(querySql);
            ResultSet rs = pstmt.executeQuery();
            rs.next();
            if (rs.getInt(1) < 1) {
                rs.close();
                pstmt.close();
                pstmt = conn.prepareStatement(createTable);
                pstmt.execute();
                pstmt.close();
            } else {
                rs.close();
                pstmt.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

