/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.eventbus.definition;

import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.util.Collection;
import org.apache.commons.beanutils.ConvertUtils;

public final class MethodDefinition {
    private String name;
    private Collection<ParamDefinition> params;

    public MethodDefinition(String name) {
        this.name = name;
    }

    public Collection<ParamDefinition> getParams() {
        return this.params;
    }

    void setParams(Collection<ParamDefinition> params) {
        this.params = params;
    }

    public String getName() {
        return this.name;
    }

    public void execute(Object instance) throws Exception {
        if (StringUtils.isEmpty((String)this.name)) {
            return;
        }
        Class[] paramTypes = null;
        Object[] paramValues = null;
        if (this.params != null && this.params.size() > 0) {
            int size = this.params.size();
            paramTypes = new Class[size];
            paramValues = new Object[size];
            this.populateParams(instance, paramTypes, paramValues);
        }
        Method method = instance.getClass().getMethod(this.name, paramTypes);
        method.invoke(instance, paramValues);
    }

    private void populateParams(Object instance, Class[] paramTypes, Object[] paramValues) throws ClassNotFoundException {
        int idx = 0;
        for (ParamDefinition param : this.params) {
            if (StringUtils.isEmpty((String)param.type)) {
                paramTypes[idx] = String.class;
                paramValues[idx] = param.value;
            } else {
                paramTypes[idx] = instance.getClass().getClassLoader().loadClass(param.type);
                if (paramTypes[idx].isInstance(param.value)) {
                    paramValues[idx] = param.value;
                } else if (param.value != null) {
                    paramValues[idx] = ConvertUtils.convert((String)param.value.toString(), (Class)paramTypes[idx]);
                }
            }
            ++idx;
        }
    }

    public static class ParamDefinition {
        private Object value;
        private String type;

        public ParamDefinition(Object value, String type) {
            this.value = value;
            this.type = type;
        }
    }
}

