/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.eventbus.definition;

import com.kingdee.bos.eventbus.PointCutEnum;
import com.kingdee.bos.eventbus.annotation.OnEvent;
import com.kingdee.bos.eventbus.annotation.PointCut;
import com.kingdee.bos.eventbus.definition.Event;
import com.kingdee.bos.eventbus.definition.Handler;
import com.kingdee.bos.eventbus.definition.UIConfig;
import com.kingdee.bos.eventbus.exception.PluginRegisterException;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public final class Plugin
implements Serializable,
Cloneable {
    private static final Logger logger = Logger.getLogger(Plugin.class);
    private String eventType;
    private String actionName;
    private String script;
    private Handler handler;
    private PointCutEnum pointcut = PointCutEnum.AFTER;

    public Handler getHandler() {
        return this.handler;
    }

    public Plugin(String eventType, Handler handler) {
        this.eventType = eventType;
        this.handler = handler;
    }

    void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public PointCutEnum getPointcut() {
        return this.pointcut;
    }

    void setPointcut(PointCutEnum pointcut) {
        this.pointcut = pointcut;
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getActionName() {
        return this.actionName;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    protected Object clone() throws CloneNotSupportedException {
        Plugin plugin = (Plugin)super.clone();
        plugin.handler = (Handler)this.handler.clone();
        return plugin;
    }

    public Class getEventClass() {
        try {
            return this.handler.getDefaultClassLoader().loadClass(this.getEventType());
        }
        catch (ClassNotFoundException e) {
            throw new PluginRegisterException(String.format("Invalid plugin %s", this.getEventType()));
        }
    }

    public void collectPlugin(Map<String, Collection<Plugin>> map, PointCutEnum pointcut, Set<String> overwrited, UIConfig uic) {
        if (!this.collectAnnotationPlugin(map, pointcut, overwrited, uic)) {
            if (pointcut != null && !pointcut.equals((Object)this.getPointcut())) {
                return;
            }
            if (this.getHandler().getHandlerLevel() == 0 && overwrited.contains(this.getEventType() + "&" + uic.getName())) {
                ArrayList plugins = (ArrayList)map.get(this.getEventType());
                plugins.set(plugins.size() - 1, this);
                return;
            }
            for (String eventType : overwrited) {
                String tempEventType = eventType.substring(0, eventType.indexOf("&"));
                if (!tempEventType.equals(this.getEventType()) || !PointCutEnum.OVERWRITE.equals((Object)this.getPointcut())) continue;
                return;
            }
            if (PointCutEnum.BEFORE.equals((Object)this.getPointcut())) {
                this.insertPluginIntoMap(map, this);
            } else {
                this.putPluginIntoMap(map, this);
                if (PointCutEnum.OVERWRITE.equals((Object)this.getPointcut())) {
                    overwrited.add(this.getEventType() + "&" + uic.getName());
                }
            }
        }
    }

    private boolean collectAnnotationPlugin(Map<String, Collection<Plugin>> map, PointCutEnum pointcut, Set<String> overwrited, UIConfig uic) {
        if (!this.getHandler().isAnnotation()) {
            return false;
        }
        return this.handlePointCutForAnnotationPlugin(map, pointcut, overwrited, uic);
    }

    private boolean handlePointCutForAnnotationPlugin(Map<String, Collection<Plugin>> map, PointCutEnum pointcut, Set<String> overwrited, UIConfig uic) {
        Method[] methods;
        boolean result = true;
        Class handlerClass = this.getHandler().findClass();
        int level = Handler.getHandlerLevel(handlerClass);
        for (Method method : methods = handlerClass.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(OnEvent.class)) continue;
            PointCutEnum pcValue = this.getPointCutAnnotation(method);
            if (pointcut != null && !pointcut.equals((Object)pcValue)) continue;
            OnEvent onEvent = method.getAnnotation(OnEvent.class);
            Class eventClass = Event.getEventClass(onEvent, method);
            String source = onEvent.source();
            String eventType = eventClass.getName();
            if (!this.getEventType().equals(eventType)) continue;
            Plugin p = this.cloneAPlugin(pcValue);
            p.setEventType(eventType);
            p.getHandler().setAnnotationMethod(method);
            if (!StringUtils.isEmpty((String)source)) {
                p.getHandler().setSource(source);
            }
            if (overwrited.contains(this.getEventType() + "&" + uic.getName())) {
                ArrayList plugins = (ArrayList)map.get(p.getEventType());
                plugins.set(plugins.size() - 1, p);
                continue;
            }
            for (String eventType1 : overwrited) {
                String tempEventType = eventType1.substring(0, eventType1.indexOf("&"));
                if (!tempEventType.equals(this.getEventType())) continue;
            }
            if (PointCutEnum.BEFORE.equals((Object)pcValue)) {
                this.insertPluginIntoMap(map, p);
            } else {
                this.putPluginIntoMap(map, p);
                if (PointCutEnum.OVERWRITE.equals((Object)pcValue)) {
                    overwrited.add(eventType + "&" + uic.getName());
                }
            }
            result = true;
        }
        return result;
    }

    public void findInvokeMethod() {
        Method[] methods;
        Class handlerClass = this.getHandler().findClass();
        for (Method method : methods = handlerClass.getDeclaredMethods()) {
            OnEvent onEvent;
            Class eventClass;
            if (!method.isAnnotationPresent(OnEvent.class) || !(eventClass = Event.getEventClass(onEvent = method.getAnnotation(OnEvent.class), method)).equals(this.getEventClass())) continue;
            this.getHandler().setAnnotationMethod(method);
        }
    }

    private Plugin cloneAPlugin(PointCutEnum pointcut) {
        Plugin p = null;
        try {
            p = (Plugin)this.clone();
            p.setPointcut(pointcut);
        }
        catch (CloneNotSupportedException e) {
            throw new PluginRegisterException(e);
        }
        return p;
    }

    private void putPluginIntoMap(Map<String, Collection<Plugin>> map, Plugin plugin) {
        Collection<Plugin> plugins = map.get(plugin.getEventType());
        if (plugins == null) {
            plugins = new ArrayList<Plugin>();
            map.put(plugin.getEventType(), plugins);
        }
        plugins.add(plugin);
    }

    private void insertPluginIntoMap(Map<String, Collection<Plugin>> map, Plugin plugin) {
        Collection<Plugin> plugins = map.get(plugin.getEventType());
        if (plugins == null) {
            plugins = new ArrayList<Plugin>();
            map.put(plugin.getEventType(), plugins);
        }
        ArrayList<Plugin> plusNew = new ArrayList<Plugin>();
        plusNew.add(plugin);
        Object[] plustemp = plugins.toArray();
        if (plustemp != null && plustemp.length != 0) {
            for (int i = 0; plustemp.length != 0 && i < plustemp.length; ++i) {
                plusNew.add((Plugin)plustemp[i]);
            }
        }
        plugins = plusNew;
        map.put(plugin.getEventType(), plugins);
    }

    private PointCutEnum getPointCutAnnotation(Method method) {
        if (!method.isAnnotationPresent(PointCut.class)) {
            return PointCutEnum.AFTER;
        }
        PointCut pointCut = method.getAnnotation(PointCut.class);
        PointCutEnum pcValue = pointCut.value();
        return pcValue;
    }
}

