/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.eventbus.definition;

import com.kingdee.bos.eventbus.HandlerType;
import com.kingdee.bos.eventbus.PointCutEnum;
import com.kingdee.bos.eventbus.definition.AbstractComponentMeta;
import com.kingdee.bos.eventbus.definition.ActionDefinition;
import com.kingdee.bos.eventbus.definition.ApplicationDefinition;
import com.kingdee.bos.eventbus.definition.Condition;
import com.kingdee.bos.eventbus.definition.Event;
import com.kingdee.bos.eventbus.definition.Handler;
import com.kingdee.bos.eventbus.definition.IUIConfigCache;
import com.kingdee.bos.eventbus.definition.MethodDefinition;
import com.kingdee.bos.eventbus.definition.Plugin;
import com.kingdee.bos.eventbus.definition.Property;
import com.kingdee.bos.eventbus.definition.Reference;
import com.kingdee.bos.eventbus.definition.RuleDefinition;
import com.kingdee.bos.eventbus.definition.Service;
import com.kingdee.bos.eventbus.definition.UIConfig;
import com.kingdee.bos.eventbus.parse.ConfigurationParseException;
import com.kingdee.bos.eventbus.parse.IConfigurationParser;
import com.kingdee.bos.eventbus.parse.ParserContext;
import com.kingdee.bos.eventbus.parse.XmlFileReader;
import com.kingdee.bos.expression.function.FunctionXmlParser;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jdom2.Element;

public final class UIConfigXmlParser
implements IConfigurationParser {
    private ParserContext parserContext;
    private String uiName;
    private String xmlString;
    private IUIConfigCache uiConfigCache;

    public UIConfigXmlParser(IUIConfigCache uiConfigCache, ParserContext parserContext, String uiName) {
        this.uiConfigCache = uiConfigCache;
        this.parserContext = parserContext;
        this.uiName = uiName;
    }

    public UIConfigXmlParser(IUIConfigCache uiConfigCache, String uiName, String xmlString) {
        this.uiConfigCache = uiConfigCache;
        this.uiName = uiName;
        this.xmlString = xmlString;
    }

    @Override
    public void parse() throws ConfigurationParseException {
        XmlFileReader reader = new XmlFileReader();
        Element root = this.parserContext != null ? reader.read(this.parserContext) : reader.read(this.xmlString);
        this.doParse(root);
        this.parseFunctions(root);
    }

    private void doParse(Element root) {
        String resource = null;
        if (this.parserContext != null) {
            resource = this.parserContext.getResource();
            resource = resource.replaceAll("/", ".");
        }
        UIConfig uic = new UIConfig(this.uiName, resource);
        uic.setParent(this.parseParent(root));
        uic.setImports(this.parseImports(root));
        this.parsePlugins(uic, root);
        this.parseServerPlugins(uic, root);
        uic.setActionDefinitions(this.parseActions(root));
        uic.setServices(this.parseServices(root));
        uic.setRuleset(this.parseRuleset(root));
        uic.setApplicationDefinition(this.parsePresenter(root));
        this.uiConfigCache.putUIConfig(this.uiName, uic);
    }

    private UIConfig parseParent(Element root) {
        Element parent = root.getChild("parent");
        if (parent == null) {
            return null;
        }
        return this.parseAImport(parent);
    }

    private UIConfig parseAImport(Element parent) {
        String uiName = parent.getText();
        UIConfig parentUic = this.uiConfigCache.getUIConfig(uiName);
        return parentUic;
    }

    private void parsePlugins(UIConfig uic, Element root) {
        Element elePlugins = root.getChild("plugins");
        if (elePlugins == null) {
            return;
        }
        Collection<Plugin> plugins = this.parsePlugins(elePlugins, false);
        uic.setPlugins(plugins);
    }

    private Collection<Plugin> parsePlugins(Element elePlugins, boolean isServer) {
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        for (Element element : elePlugins.getChildren()) {
            Plugin plugin = this.parsePlugin(element, isServer);
            plugins.add(plugin);
        }
        return plugins;
    }

    private void parseServerPlugins(UIConfig uic, Element root) {
        Element elePlugins = root.getChild("srv-plugins");
        if (elePlugins == null) {
            return;
        }
        Collection<Plugin> plugins = this.parsePlugins(elePlugins, true);
        uic.setServerPlugins(plugins);
    }

    private Plugin parsePlugin(Element element, boolean isServer) {
        String event = element.getChildText("event");
        Handler handler = this.parseHandler(element.getChild("handler"), isServer);
        Plugin plugin = new Plugin(event, handler);
        String pointcut = element.getChildText("pointcut");
        if (!StringUtils.isEmpty((String)pointcut)) {
            plugin.setPointcut(PointCutEnum.valueOf(pointcut.toUpperCase()));
        }
        plugin.setActionName(element.getChildText("actionName"));
        plugin.setScript(element.getChildText("script"));
        return plugin;
    }

    private Handler parseHandler(Element element, boolean isServer) {
        if (element.getChildText("name") == null) {
            return this.createHandler(element.getText(), isServer);
        }
        Handler handler = this.createHandler(element.getChildText("name"), isServer);
        this.parseAbstractComponentMeta(element, handler);
        handler.setSource(element.getChildText("source"));
        return handler;
    }

    private Handler createHandler(String name, boolean isServer) {
        if (isServer) {
            return new Handler(name, HandlerType.SERVER);
        }
        return new Handler(name);
    }

    private Collection<Property> parseProperties(Element element) {
        if (element == null || element.getChildren().size() == 0) {
            return null;
        }
        ArrayList<Property> properties = new ArrayList<Property>(element.getChildren().size());
        Iterator iter = element.getChildren().iterator();
        while (iter.hasNext()) {
            properties.add(this.parseProperty((Element)iter.next()));
        }
        return properties;
    }

    private Property parseProperty(Element element) {
        Object value = this.parseValue(element);
        return new Property(element.getAttributeValue("name"), value);
    }

    private Object parseValue(Element element) {
        Object value = element.getChild("value") == null ? this.parseSimpleValue(element) : element.getChildText("value");
        return value;
    }

    private Object parseSimpleValue(Element element) {
        Object value = element.getAttribute("value") != null ? element.getAttributeValue("value") : this.parseReference(element);
        return value;
    }

    private Reference parseReference(Element element) {
        return new Reference(element.getAttributeValue("ref"));
    }

    private Map<String, ActionDefinition> parseActions(Element root) {
        Element eleActions = root.getChild("actions");
        if (eleActions == null) {
            return null;
        }
        HashMap<String, ActionDefinition> actions = new HashMap<String, ActionDefinition>();
        for (Element element : eleActions.getChildren()) {
            ActionDefinition action = this.parseAction(element);
            actions.put(action.getActionName(), action);
        }
        return actions;
    }

    private ActionDefinition parseAction(Element element) {
        String name = element.getChildText("name");
        Event event = this.parseEvent(element.getChild("event"));
        String method = element.getChildText("method");
        String batchAction = element.getChildText("batchAction");
        ActionDefinition action = new ActionDefinition(name, event, method, batchAction);
        action.setPreCondition(this.parseCondition(element.getChild("precondition")));
        return action;
    }

    private Condition parseCondition(Element element) {
        if (element == null) {
            return null;
        }
        Element exprElement = element.getChild("expression");
        if (exprElement == null) {
            return null;
        }
        String expression = exprElement.getText();
        String ruleId = exprElement.getAttributeValue("rule");
        Condition condition = new Condition();
        condition.setExpression(expression);
        condition.setRuleId(ruleId);
        return condition;
    }

    private Event parseEvent(Element element) {
        if (element == null) {
            return null;
        }
        if (element.getChild("name") == null) {
            return new Event(element.getText());
        }
        Event event = new Event(element.getChildText("name"));
        this.parseAbstractComponentMeta(element, event);
        return event;
    }

    private boolean parseBoolean(Element element, String eleName) {
        String value = element.getChildText(eleName);
        if (!StringUtils.isEmpty((String)value)) {
            return Boolean.valueOf(value);
        }
        return false;
    }

    private Map<String, Service> parseServices(Element root) {
        Element children = root.getChild("services");
        if (children == null) {
            return null;
        }
        HashMap<String, Service> services = new HashMap<String, Service>();
        Iterator iter = children.getChildren().iterator();
        while (iter.hasNext()) {
            Service service = this.parseService((Element)iter.next());
            services.put(service.getId(), service);
        }
        return services;
    }

    private Service parseService(Element element) {
        String interfaceName = element.getChildText("interface");
        String id = element.getChildText("name");
        Service service = new Service(element.getChildText("class"), id, interfaceName);
        String lazyInit = element.getAttributeValue("lazy-init");
        if (!StringUtils.isEmpty((String)lazyInit)) {
            service.setLazyInit(Boolean.valueOf(lazyInit));
        }
        this.parseAbstractComponentMeta(element, service);
        return service;
    }

    private void parseAbstractComponentMeta(Element element, AbstractComponentMeta component) {
        component.setProperties(this.parseProperties(element.getChild("properties")));
        component.setInitMethod(this.parseMethodDefinition(element.getChild("init")));
        component.setDestroyMethod(this.parseMethodDefinition(element.getChild("destroy")));
    }

    private MethodDefinition parseMethodDefinition(Element element) {
        if (element == null) {
            return null;
        }
        if (element.getChildren().size() == 0) {
            return new MethodDefinition(element.getText());
        }
        MethodDefinition method = new MethodDefinition(element.getAttributeValue("name"));
        method.setParams(this.parseParams(element.getChild("params")));
        return method;
    }

    private MethodDefinition.ParamDefinition parseParamDefinition(Element element) {
        String type = element.getAttributeValue("type");
        Object value = this.parseSimpleValue(element);
        return new MethodDefinition.ParamDefinition(value, type);
    }

    private Collection<MethodDefinition.ParamDefinition> parseParams(Element element) {
        ArrayList<MethodDefinition.ParamDefinition> params = new ArrayList<MethodDefinition.ParamDefinition>();
        if (element == null || element.getChildren().size() == 0) {
            return params;
        }
        Iterator iter = element.getChildren().iterator();
        while (iter.hasNext()) {
            params.add(this.parseParamDefinition((Element)iter.next()));
        }
        return params;
    }

    private Collection<UIConfig> parseImports(Element root) {
        Element element = root.getChild("imports");
        if (element == null || element.getChildren().size() == 0) {
            return null;
        }
        ArrayList<UIConfig> imports = new ArrayList<UIConfig>(element.getChildren().size());
        Iterator iter = element.getChildren().iterator();
        while (iter.hasNext()) {
            imports.add(this.parseAImport((Element)iter.next()));
        }
        return imports;
    }

    private Map<String, RuleDefinition> parseRuleset(Element root) {
        Element children = root.getChild("ruleset");
        if (children == null) {
            return null;
        }
        HashMap<String, RuleDefinition> ruleset = new HashMap<String, RuleDefinition>();
        Iterator iter = children.getChildren().iterator();
        while (iter.hasNext()) {
            RuleDefinition rule = this.parseRule((Element)iter.next());
            ruleset.put(rule.getId(), rule);
        }
        return ruleset;
    }

    private RuleDefinition parseRule(Element element) {
        String id = element.getAttributeValue("id");
        String description = element.getChildText("description");
        String expression = element.getChildText("expression");
        return new RuleDefinition(id, description, expression);
    }

    private ApplicationDefinition parsePresenter(Element root) {
        Element element = root.getChild("application");
        if (element == null) {
            return null;
        }
        ApplicationDefinition presenter = new ApplicationDefinition(element.getChildText("class"));
        this.parseAbstractComponentMeta(element, presenter);
        this.parseInitilizeServices(element.getChild("initialize"), presenter);
        return presenter;
    }

    private void parseInitilizeServices(Element element, ApplicationDefinition presenter) {
        if (element == null || element.getChildren().size() == 0) {
            return;
        }
        ArrayList<Reference> initializeServices = new ArrayList<Reference>(element.getChildren().size());
        Iterator iter = element.getChildren().iterator();
        while (iter.hasNext()) {
            initializeServices.add(this.parseReference((Element)iter.next()));
        }
        presenter.setInitializeServices(initializeServices);
    }

    private void parseFunctions(Element root) {
        Element eleFunctions = root.getChild("functions");
        if (eleFunctions == null) {
            return;
        }
        FunctionXmlParser functionParser = new FunctionXmlParser();
        functionParser.doParse(eleFunctions);
    }
}

