/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.eventbus.support;

import com.kingdee.bos.eventbus.IEventBusMonitor;
import com.kingdee.bos.eventbus.IEventFilter;
import com.kingdee.bos.eventbus.IEventHandler;
import com.kingdee.bos.eventbus.KDEvent;
import com.kingdee.bos.eventbus.support.SimpleEventBus;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.log4j.Logger;

public final class EventBusDebugLogMonitor
implements IEventBusMonitor {
    private static final Logger logger = Logger.getLogger(SimpleEventBus.class);
    private static final String LINE = "\r\n";
    private static final String TAB = "\t";
    private Map<Object, Long> times = new HashMap<Object, Long>();

    @Override
    public void beginExecuteEventFilter(KDEvent event, IEventFilter filter) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        this.times.put(filter, Calendar.getInstance().getTimeInMillis());
    }

    @Override
    public void beginFireEvent(KDEvent event, Object source, List<IEventHandler> handlers) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("\u89e6\u53d1Event\uff1a\r\n\tevent(" + event.toDebugString() + "), " + LINE + TAB + "source(" + (source != null ? source.toString() : "") + "), " + LINE + TAB + "handers[" + handlers.size() + "](");
        ListIterator<IEventHandler> it = handlers.listIterator();
        while (it.hasNext()) {
            IEventHandler handler = it.next();
            sb.append(handler.getClass().getName()).append(";");
            sb.append(LINE).append(TAB).append(TAB);
        }
        if (handlers.size() > 0) {
            sb.setLength(sb.length() - 3);
        }
        sb.append(")");
        logger.debug((Object)sb.toString());
    }

    @Override
    public void endExecuteEventFilter(KDEvent event, IEventFilter filter) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        Long time = this.times.get(filter);
        if (time != null) {
            long consume = Calendar.getInstance().getTimeInMillis() - time;
            logger.debug((Object)("\u6267\u884cfilter(" + filter.getClass().getName() + ")\u8017\u65f6\uff1a" + consume + "ms"));
        }
    }

    @Override
    public void endFireEvent(KDEvent event, Object source, List<IEventHandler> handlers) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("\u5b8c\u6210Event\uff1a\r\n\tevent(" + event.toDebugString() + "), " + LINE + TAB + "source(" + (source != null ? source.toString() : "") + "), " + LINE + TAB + "handers[" + handlers.size() + "](");
        ListIterator<IEventHandler> it = handlers.listIterator();
        while (it.hasNext()) {
            IEventHandler handler = it.next();
            sb.append(handler.getClass().getName()).append(";");
            sb.append(LINE).append(TAB).append(TAB);
        }
        if (handlers.size() > 0) {
            sb.setLength(sb.length() - 3);
        }
        sb.append(")");
        logger.debug((Object)sb.toString());
    }

    @Override
    public void onSubscribeEventFilter(Object key, IEventFilter filter) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        logger.debug((Object)("\u8ba2\u9605Filter\uff1a\r\n\tkey(" + key.toString() + "), " + LINE + TAB + "filter(" + filter.getClass().toString() + ")"));
    }

    @Override
    public void onSubscribeEventHandler(Class eventClass, Object source, IEventHandler handler) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        logger.debug((Object)("\u8ba2\u9605EventHandler\uff1a\r\n\tevent(" + eventClass.toString() + "), " + LINE + TAB + "source(" + (source != null ? source.toString() : "") + ")," + LINE + TAB + "handler(" + handler.getClass().getName() + "), ClassLoader(" + this.getClassLoaderName(handler) + ")"));
    }

    private String getClassLoaderName(Object obj) {
        String classLoader = obj.getClass().getClassLoader().toString();
        int idx = classLoader.indexOf(64);
        return classLoader.substring(0, idx);
    }

    @Override
    public void beginExecuteEventHandler(KDEvent event, IEventHandler handler) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        this.times.put(handler, Calendar.getInstance().getTimeInMillis());
    }

    @Override
    public void endExecuteEventHandler(KDEvent event, IEventHandler handler) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        Long time = this.times.get(handler);
        if (time != null) {
            long consume = Calendar.getInstance().getTimeInMillis() - time;
            logger.debug((Object)("\u6267\u884chandler(" + handler.getClass().getName() + ")\u8017\u65f6\uff1a" + consume + "ms"));
        }
    }
}

