/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.eventbus.support;

import com.kingdee.bos.eventbus.IEventFilter;
import com.kingdee.bos.eventbus.application.IApplication;
import com.kingdee.bos.eventbus.application.IEventRegiterAssistant;
import com.kingdee.bos.eventbus.definition.ActionDefinition;
import com.kingdee.bos.eventbus.definition.IComponentInitialize;
import com.kingdee.bos.eventbus.definition.UIConfig;
import com.kingdee.bos.eventbus.register.IEventFilterRegister;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class EventFilterRegister
implements IEventFilterRegister {
    private IApplication application;
    private IEventRegiterAssistant filterFactory;

    public EventFilterRegister(IApplication application, IEventRegiterAssistant filterFactory) {
        this.application = application;
        this.filterFactory = filterFactory;
    }

    @Override
    public void registerActionFilters() {
        HashSet actionSet = new HashSet();
        UIConfig uiConfig = this.application.getUIConfig();
        this.registerActionFilters(actionSet, uiConfig);
    }

    private void registerActionFilters(Set actionSet, UIConfig uiConfig) {
        Map<String, ActionDefinition> actions = uiConfig.getActions();
        if (actions != null) {
            for (String actionName : actions.keySet()) {
                this.registerActionFilter(actionSet, uiConfig, actionName);
            }
        }
        if (uiConfig.getParent() != null) {
            this.registerActionFilters(actionSet, uiConfig.getParent());
        }
    }

    private void registerActionFilter(Set actionSet, UIConfig uiConfig, String actionName) {
        if (actionSet.contains(actionName)) {
            return;
        }
        ActionDefinition action = uiConfig.getActionDefinition(actionName);
        if (action.getPreCondition() == null) {
            return;
        }
        IEventFilter filter = this.filterFactory.createPreActionFilter(actionName);
        if (this.application instanceof IComponentInitialize) {
            ((IComponentInitialize)((Object)this.application)).afterComponentCreate(filter);
        }
        Class eventClass = action.getEvent().findClass();
        this.application.getEventBus().addEventFilter(eventClass, filter);
    }
}

