/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.expression.op.define;

import com.kingdee.bos.expression.IllegalExpressionException;
import com.kingdee.bos.expression.datameta.BaseDataMeta;
import com.kingdee.bos.expression.datameta.Constant;
import com.kingdee.bos.expression.datameta.Reference;
import com.kingdee.bos.expression.op.IOperatorExecution;
import com.kingdee.bos.expression.op.Operator;

public abstract class Op_Compare
implements IOperatorExecution {
    protected abstract Operator getThisOperator();

    @Override
    public Constant execute(Constant[] args) throws IllegalExpressionException {
        if (args == null || args.length != 2) {
            throw new IllegalArgumentException("\u64cd\u4f5c\u7b26\"" + this.getThisOperator().getToken() + "\u53c2\u6570\u4e2a\u6570\u4e0d\u5339\u914d");
        }
        Constant first = args[1];
        Constant second = args[0];
        this.verifyOperateValue(first, second);
        first = this.executeAsReference(first);
        second = this.executeAsReference(second);
        if (BaseDataMeta.DataType.DATATYPE_NULL.equals((Object)first.getDataType()) || BaseDataMeta.DataType.DATATYPE_NULL.equals((Object)second.getDataType())) {
            return this.compareAsNullType(first, second);
        }
        if (BaseDataMeta.DataType.DATATYPE_STRING.equals((Object)first.getDataType()) && BaseDataMeta.DataType.DATATYPE_STRING.equals((Object)second.getDataType())) {
            return this.compareAsStringType(first, second);
        }
        if (BaseDataMeta.DataType.DATATYPE_BOOLEAN.equals((Object)first.getDataType()) && BaseDataMeta.DataType.DATATYPE_BOOLEAN.equals((Object)second.getDataType())) {
            return this.compareAsBooleanType(first, second);
        }
        if (BaseDataMeta.DataType.DATATYPE_DATE.equals((Object)first.getDataType()) && BaseDataMeta.DataType.DATATYPE_DATE.equals((Object)second.getDataType())) {
            return this.compareAsDateType(first, second);
        }
        if (BaseDataMeta.DataType.DATATYPE_BIGDECIMAL == first.getDataType() || BaseDataMeta.DataType.DATATYPE_BIGDECIMAL == second.getDataType()) {
            return this.compareAsBigDecimalType(first, second);
        }
        if (BaseDataMeta.DataType.DATATYPE_INTENUM == first.getDataType() || BaseDataMeta.DataType.DATATYPE_INTENUM == second.getDataType()) {
            return this.compareAsIntEnumType(first, second);
        }
        if ((BaseDataMeta.DataType.DATATYPE_DOUBLE.equals((Object)first.getDataType()) || BaseDataMeta.DataType.DATATYPE_FLOAT.equals((Object)first.getDataType()) || BaseDataMeta.DataType.DATATYPE_LONG.equals((Object)first.getDataType()) || BaseDataMeta.DataType.DATATYPE_INT.equals((Object)first.getDataType())) && (BaseDataMeta.DataType.DATATYPE_DOUBLE == second.getDataType() || BaseDataMeta.DataType.DATATYPE_FLOAT == second.getDataType() || BaseDataMeta.DataType.DATATYPE_LONG == second.getDataType() || BaseDataMeta.DataType.DATATYPE_INT == second.getDataType())) {
            return this.compareAsDoubleCompatibleType(first, second);
        }
        if (BaseDataMeta.DataType.DATATYPE_LIST.equals((Object)first.getDataType()) || BaseDataMeta.DataType.DATATYPE_LIST.equals((Object)second.getDataType())) {
            throw new IllegalArgumentException("\u64cd\u4f5c\u7b26\"" + this.getThisOperator().getToken() + "\"\u53c2\u6570\u7c7b\u578b\u9519\u8bef");
        }
        if (BaseDataMeta.DataType.DATATYPE_OBJECT.equals((Object)first.getDataType()) && BaseDataMeta.DataType.DATATYPE_OBJECT.equals((Object)second.getDataType())) {
            return this.compareAsObjectType(first, second);
        }
        throw new IllegalArgumentException("\u64cd\u4f5c\u7b26\"" + this.getThisOperator().getToken() + "\"\u53c2\u6570\u7c7b\u578b\u9519\u8bef");
    }

    protected Constant compareAsBooleanType(Constant first, Constant second) {
        throw new IllegalArgumentException("\u64cd\u4f5c\u7b26\"" + this.getThisOperator().getToken() + "\"\u53c2\u6570\u7c7b\u578b\u9519\u8bef");
    }

    protected Constant compareAsObjectType(Constant first, Constant second) {
        throw new IllegalArgumentException("\u64cd\u4f5c\u7b26\"" + this.getThisOperator().getToken() + "\"\u53c2\u6570\u7c7b\u578b\u9519\u8bef");
    }

    protected Constant compareAsNullType(Constant first, Constant second) {
        throw new IllegalArgumentException("\u64cd\u4f5c\u7b26\"" + this.getThisOperator().getToken() + "\"\u53c2\u6570\u7c7b\u578b\u9519\u8bef");
    }

    private Constant executeAsReference(Constant constant) {
        if (constant.isReference()) {
            Reference firstRef = (Reference)constant.getDataValue();
            constant = firstRef.execute();
        }
        return constant;
    }

    private void verifyOperateValue(Constant first, Constant second) {
        if (this.isNotAllowedAsNull(first, second)) {
            throw new NullPointerException("\u64cd\u4f5c\u7b26\"" + this.getThisOperator().getToken() + "\"\u53c2\u6570\u4e3a\u7a7a");
        }
    }

    protected boolean isNotAllowedAsNull(Constant first, Constant second) {
        return null == first || null == first.getDataValue() || null == second || null == second.getDataValue();
    }

    protected Constant compareAsDoubleCompatibleType(Constant first, Constant second) {
        int result = first.getDoubleValue().compareTo(second.getDoubleValue());
        return this.compareResultToConstant(result);
    }

    private Constant compareResultToConstant(int result) {
        if (this.evaluateCompareResult(result)) {
            return this.trueConstant();
        }
        return this.falseConstant();
    }

    protected final Constant falseConstant() {
        return new Constant(BaseDataMeta.DataType.DATATYPE_BOOLEAN, Boolean.FALSE);
    }

    protected final Constant trueConstant() {
        return new Constant(BaseDataMeta.DataType.DATATYPE_BOOLEAN, Boolean.TRUE);
    }

    protected Constant compareAsIntEnumType(Constant first, Constant second) {
        int result = first.getIntegerValue().compareTo(second.getIntegerValue());
        return this.compareResultToConstant(result);
    }

    protected Constant compareAsBigDecimalType(Constant first, Constant second) {
        int result = first.getBigDecimalValue().compareTo(second.getBigDecimalValue());
        return this.compareResultToConstant(result);
    }

    protected Constant compareAsStringType(Constant first, Constant second) {
        int result = first.getStringValue().compareTo(second.getStringValue());
        return this.compareResultToConstant(result);
    }

    protected Constant compareAsDateType(Constant first, Constant second) {
        int result = first.getDateValue().compareTo(second.getDateValue());
        return this.compareResultToConstant(result);
    }

    protected abstract boolean evaluateCompareResult(int var1);

    @Override
    public Constant verify(int opPositin, BaseDataMeta[] args) throws IllegalExpressionException {
        if (args == null) {
            throw new IllegalArgumentException("\u8fd0\u7b97\u64cd\u4f5c\u7b26\u53c2\u6570\u4e3a\u7a7a");
        }
        if (args.length != 2) {
            throw new IllegalExpressionException("\u64cd\u4f5c\u7b26\"" + this.getThisOperator().getToken() + "\"\u53c2\u6570\u4e2a\u6570\u4e0d\u5339\u914d", this.getThisOperator().getToken(), opPositin);
        }
        BaseDataMeta first = args[1];
        BaseDataMeta second = args[0];
        if (first == null || second == null) {
            throw new NullPointerException("\u64cd\u4f5c\u7b26\"" + this.getThisOperator().getToken() + "\"\u53c2\u6570\u4e3a\u7a7a");
        }
        if (BaseDataMeta.DataType.DATATYPE_NULL.equals((Object)first.getDataType()) || BaseDataMeta.DataType.DATATYPE_NULL.equals((Object)second.getDataType())) {
            return this.verifyAsNullType();
        }
        if (BaseDataMeta.DataType.DATATYPE_DATE == first.getDataType() && BaseDataMeta.DataType.DATATYPE_DATE == second.getDataType()) {
            return this.falseConstant();
        }
        if (BaseDataMeta.DataType.DATATYPE_STRING == first.getDataType() && BaseDataMeta.DataType.DATATYPE_STRING == second.getDataType()) {
            return this.falseConstant();
        }
        if (BaseDataMeta.DataType.DATATYPE_BOOLEAN.equals((Object)first.getDataType()) && BaseDataMeta.DataType.DATATYPE_BOOLEAN.equals((Object)second.getDataType())) {
            return this.verifyAsBooleanType();
        }
        if ((BaseDataMeta.DataType.DATATYPE_BIGDECIMAL == first.getDataType() || BaseDataMeta.DataType.DATATYPE_DOUBLE.equals((Object)first.getDataType()) || BaseDataMeta.DataType.DATATYPE_FLOAT.equals((Object)first.getDataType()) || BaseDataMeta.DataType.DATATYPE_LONG.equals((Object)first.getDataType()) || BaseDataMeta.DataType.DATATYPE_INT.equals((Object)first.getDataType())) && (BaseDataMeta.DataType.DATATYPE_BIGDECIMAL == second.getDataType() || BaseDataMeta.DataType.DATATYPE_DOUBLE.equals((Object)second.getDataType()) || BaseDataMeta.DataType.DATATYPE_FLOAT.equals((Object)second.getDataType()) || BaseDataMeta.DataType.DATATYPE_LONG.equals((Object)second.getDataType()) || BaseDataMeta.DataType.DATATYPE_INT.equals((Object)second.getDataType()))) {
            return this.falseConstant();
        }
        if (!(BaseDataMeta.DataType.DATATYPE_INT != first.getDataType() && BaseDataMeta.DataType.DATATYPE_INTENUM != first.getDataType() || BaseDataMeta.DataType.DATATYPE_INT != second.getDataType() && BaseDataMeta.DataType.DATATYPE_INTENUM != second.getDataType())) {
            return this.falseConstant();
        }
        if (BaseDataMeta.DataType.DATATYPE_LIST.equals((Object)first.getDataType()) || BaseDataMeta.DataType.DATATYPE_LIST.equals((Object)second.getDataType())) {
            throw new IllegalExpressionException("\u64cd\u4f5c\u7b26\"" + this.getThisOperator().getToken() + "\"\u53c2\u6570\u7c7b\u578b\u9519\u8bef", this.getThisOperator().getToken(), opPositin);
        }
        if (BaseDataMeta.DataType.DATATYPE_OBJECT.equals((Object)first.getDataType()) && BaseDataMeta.DataType.DATATYPE_OBJECT.equals((Object)second.getDataType())) {
            return this.verifyAsObjectType();
        }
        throw new IllegalExpressionException("\u64cd\u4f5c\u7b26\"" + this.getThisOperator().getToken() + "\"\u53c2\u6570\u7c7b\u578b\u9519\u8bef");
    }

    protected Constant verifyAsNullType() {
        throw new IllegalArgumentException("\u64cd\u4f5c\u7b26\"" + this.getThisOperator().getToken() + "\"\u53c2\u6570\u7c7b\u578b\u9519\u8bef");
    }

    protected Constant verifyAsBooleanType() {
        throw new IllegalArgumentException("\u64cd\u4f5c\u7b26\"" + this.getThisOperator().getToken() + "\"\u53c2\u6570\u7c7b\u578b\u9519\u8bef");
    }

    protected Constant verifyAsObjectType() {
        throw new IllegalArgumentException("\u64cd\u4f5c\u7b26\"" + this.getThisOperator().getToken() + "\"\u53c2\u6570\u7c7b\u578b\u9519\u8bef");
    }
}

