/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.expression.op.define;

import com.kingdee.bos.expression.datameta.BaseDataMeta;
import com.kingdee.bos.expression.datameta.Constant;
import com.kingdee.bos.expression.op.Operator;
import com.kingdee.bos.expression.op.define.Op_Compare;
import java.math.BigDecimal;

public class Op_NEQ
extends Op_Compare {
    public static final Operator THIS_OPERATOR = Operator.NEQ;

    @Override
    protected Constant compareAsNullType(Constant first, Constant second) {
        if (null == first.getDataValue() && null == second.getDataValue()) {
            return this.falseConstant();
        }
        return this.trueConstant();
    }

    @Override
    protected boolean isNotAllowedAsNull(Constant first, Constant second) {
        return first == null || second == null;
    }

    @Override
    protected Constant compareAsDateType(Constant first, Constant second) {
        String firstValue = first.getDataValueText();
        String secondValue = second.getDataValueText();
        if (firstValue != null) {
            return super.compareAsDateType(first, second);
        }
        return this.compareWhenFirstIsNull(secondValue);
    }

    private Constant compareWhenFirstIsNull(Object secondValue) {
        if (secondValue != null) {
            return this.falseConstant();
        }
        return this.trueConstant();
    }

    @Override
    protected Constant compareAsBigDecimalType(Constant first, Constant second) {
        BigDecimal firstValue = first.getBigDecimalValue();
        BigDecimal secondValue = second.getBigDecimalValue();
        if (firstValue != null) {
            return super.compareAsBigDecimalType(first, second);
        }
        return this.compareWhenFirstIsNull(secondValue);
    }

    @Override
    protected Constant compareAsDoubleCompatibleType(Constant first, Constant second) {
        Double firstValue = first.getDoubleValue();
        Double secondValue = second.getDoubleValue();
        if (firstValue != null) {
            return super.compareAsDoubleCompatibleType(first, second);
        }
        return this.compareWhenFirstIsNull(secondValue);
    }

    @Override
    protected Constant compareAsIntEnumType(Constant first, Constant second) {
        Integer firstValue = first.getIntegerValue();
        Integer secondValue = second.getIntegerValue();
        if (firstValue != null) {
            return super.compareAsIntEnumType(first, second);
        }
        return this.compareWhenFirstIsNull(secondValue);
    }

    @Override
    protected Constant compareAsStringType(Constant first, Constant second) {
        String firstValue = first.getStringValue();
        String secondValue = second.getStringValue();
        if (firstValue != null) {
            return super.compareAsStringType(first, second);
        }
        return this.compareWhenFirstIsNull(secondValue);
    }

    @Override
    protected Constant compareAsObjectType(Constant first, Constant second) {
        Object firstValue = first.getDataValue();
        Object secondValue = second.getDataValue();
        if (firstValue != null) {
            return this.compareWhenFirstNotNull(firstValue, secondValue);
        }
        return this.compareWhenFirstIsNull(secondValue);
    }

    protected Constant compareWhenFirstNotNull(Object firstValue, Object secondValue) {
        return new Constant(BaseDataMeta.DataType.DATATYPE_BOOLEAN, this.trueAsThenAreEquals(firstValue, secondValue) == false);
    }

    private Boolean trueAsThenAreEquals(Object firstValue, Object secondValue) {
        return firstValue.equals(secondValue);
    }

    @Override
    protected Constant compareAsBooleanType(Constant first, Constant second) {
        Boolean firstValue = first.getBooleanValue();
        Boolean secondValue = second.getBooleanValue();
        if (firstValue != null) {
            return this.compareWhenFirstNotNull(firstValue, secondValue);
        }
        if (secondValue == null) {
            return this.trueConstant();
        }
        return this.falseConstant();
    }

    @Override
    protected Constant verifyAsNullType() {
        return this.falseConstant();
    }

    @Override
    protected Constant verifyAsBooleanType() {
        return this.falseConstant();
    }

    @Override
    protected Constant verifyAsObjectType() {
        return this.falseConstant();
    }

    @Override
    protected Operator getThisOperator() {
        return THIS_OPERATOR;
    }

    @Override
    protected boolean evaluateCompareResult(int result) {
        return result != 0;
    }
}

