/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.meta.ui;

import com.kingdee.bos.dao.xml.impl.AbstractMDElement;
import com.kingdee.bos.meta.ui.IVisitorTransformCallBack;
import com.kingdee.bos.meta.ui.MetaAction;
import com.kingdee.bos.meta.ui.MetaComponent;
import com.kingdee.bos.meta.ui.MetaComponentProperty;
import com.kingdee.bos.meta.ui.MetaDataObject;
import com.kingdee.bos.meta.ui.MetaEndlessException;
import com.kingdee.bos.meta.ui.MetaEventBinding;
import com.kingdee.bos.meta.ui.MetaLayout;
import com.kingdee.bos.meta.ui.MetaMeta;
import com.kingdee.bos.meta.ui.MetaPropertyBinding;
import com.kingdee.bos.meta.ui.MetaScript;
import com.kingdee.bos.meta.ui.MetaStateItem;
import com.kingdee.bos.meta.ui.MetaStatus;
import com.kingdee.bos.meta.ui.MetaStyleSheet;
import com.kingdee.bos.meta.ui.MetaWebEditPage;
import com.kingdee.bos.metadata.ui.ActionInfo;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.DataObjectInfo;
import com.kingdee.bos.metadata.ui.EventBindingInfo;
import com.kingdee.bos.metadata.ui.LayoutInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.ui.StatusInfo;
import com.kingdee.bos.metadata.ui.StatusItemInfo;
import com.kingdee.bos.metadata.ui.WebEventInfo;
import com.kingdee.bos.metadata.webcommon.WebResourceInfo;
import com.kingdee.bos.metadata.webpage.MetaInfo;
import com.kingdee.bos.metadata.webpage.ScriptInfo;
import com.kingdee.bos.metadata.webpage.StyleSheetInfo;
import com.kingdee.bos.metadata.webpage.WebActionInfo;
import com.kingdee.bos.metadata.webpage.WebPageObjectInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.Logger;

public class WebEditPageObjectInfoVisitorImpl {
    private MetaWebEditPage metaUI = new MetaWebEditPage();
    private Stack stack = new Stack();
    private Map<String, MetaPropertyBinding> proptyBindings = new HashMap<String, MetaPropertyBinding>();
    private Map localeResource = null;
    private IVisitorTransformCallBack transformCallBack;
    private static final Logger logger = Logger.getLogger(WebEditPageObjectInfoVisitorImpl.class);

    public WebEditPageObjectInfoVisitorImpl() {
    }

    public WebEditPageObjectInfoVisitorImpl(IVisitorTransformCallBack transformCallBack) {
        this.transformCallBack = transformCallBack;
    }

    public Map getLocaleResource() {
        return this.localeResource;
    }

    public void setLocaleResource(Map localeResource) {
        this.localeResource = localeResource;
    }

    public MetaWebEditPage getMetaWebPage() {
        return this.metaUI;
    }

    public void accept(WebPageObjectInfo uiObject) {
        this.metaUI.packageName = uiObject.getPackage();
        this.metaUI.name = uiObject.getFullName();
        this.metaUI.alias = uiObject.getAlias();
        this.metaUI.title = uiObject.getTitle();
        this.metaUI.description = uiObject.getDescription();
        this.metaUI.userDefined = uiObject.isUserDefined();
        Iterator iter = uiObject.getScripts().iterator();
        while (iter.hasNext()) {
            this.accept((ScriptInfo)iter.next());
        }
        iter = uiObject.getStyleSheets().iterator();
        while (iter.hasNext()) {
            this.accept((StyleSheetInfo)iter.next());
        }
        iter = uiObject.getMetas().iterator();
        while (iter.hasNext()) {
            this.accept((MetaInfo)iter.next());
        }
        iter = uiObject.getComponents().iterator();
        while (iter.hasNext()) {
            this.accept((ComponentInfo)iter.next());
        }
        iter = uiObject.getDataObjects().iterator();
        while (iter.hasNext()) {
            this.accept((DataObjectInfo)iter.next());
        }
        iter = uiObject.getActions().iterator();
        while (iter.hasNext()) {
            this.accept((ActionInfo)iter.next());
        }
        iter = uiObject.getStatuses().iterator();
        while (iter.hasNext()) {
            this.accept((StatusInfo)iter.next());
        }
        iter = uiObject.getWebResources().iterator();
        while (iter.hasNext()) {
            this.accept((WebResourceInfo)iter.next());
        }
        iter = uiObject.getWebActions().iterator();
        while (iter.hasNext()) {
            this.accept((WebActionInfo)iter.next());
        }
        this.finish();
    }

    public void accept(ScriptInfo script) {
        if (this.metaUI.scripts == null) {
            this.metaUI.scripts = new ArrayList<MetaScript>();
        }
        MetaScript metaScript = new MetaScript();
        metaScript.setReference(script.getReference());
        metaScript.setName(script.getName());
        this.metaUI.getScripts().add(metaScript);
        if (this.transformCallBack != null) {
            this.transformCallBack.execute(script);
        }
    }

    public void accept(StyleSheetInfo styleSheet) {
        if (this.metaUI.getStyleSheets() == null) {
            this.metaUI.styleSheets = new ArrayList<MetaStyleSheet>();
        }
        MetaStyleSheet metaStyleSheet = new MetaStyleSheet();
        metaStyleSheet.setReference(styleSheet.getReference());
        metaStyleSheet.setName(styleSheet.getName());
        this.metaUI.getStyleSheets().add(metaStyleSheet);
        if (this.transformCallBack != null) {
            this.transformCallBack.execute(styleSheet);
        }
    }

    public void accept(MetaInfo metaInfo) {
        if (this.metaUI.getMetaMetas() == null) {
            this.metaUI.metaMetas = new ArrayList<MetaMeta>();
        }
        MetaMeta metaMeta = new MetaMeta();
        metaMeta.setName(metaInfo.getName());
        metaMeta.setType(metaInfo.getType());
        metaMeta.setCondition(metaInfo.getCondition());
        metaMeta.setContent(metaInfo.getContent());
        this.metaUI.getMetaMetas().add(metaMeta);
        if (this.transformCallBack != null) {
            this.transformCallBack.execute(metaInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(ComponentInfo component) {
        if (this.transformCallBack != null) {
            this.transformCallBack.setContext((AbstractMDElement)component);
        }
        if (this.metaUI.components == null) {
            this.metaUI.components = new ArrayList<MetaComponent>();
        }
        MetaComponent mc = new MetaComponent();
        this.metaUI.components.add(mc);
        mc.name = component.getName();
        mc.alias = component.getAlias();
        mc.classType = component.getClassType();
        mc.constraints = component.getConstraint();
        mc.herited = component.isHerited();
        mc.isContainer = component.isContainer();
        if (component.getParent() != null) {
            mc.parentName = component.getParent().getName();
        }
        try {
            this.stack.push(mc);
            if (component.getLayoutInfo() != null) {
                this.accept(component.getLayoutInfo());
            }
            MetaComponentProperty mp = new MetaComponentProperty();
            mp.name = "id";
            mp.type = "String";
            mp.userDefined = false;
            mp.value = component.getName();
            mp.setMultiLan(false);
            mc.getProperties().add(mp);
            Iterator iter = component.getProperties().iterator();
            while (iter.hasNext()) {
                this.accept((PropertyInfo)iter.next());
            }
            iter = component.getPropertyBindings().iterator();
            while (iter.hasNext()) {
                this.accept((PropertyBindingInfo)iter.next());
            }
            iter = component.getWebEvents().iterator();
            while (iter.hasNext()) {
                this.accept((WebEventInfo)iter.next());
            }
            if (this.transformCallBack != null) {
                this.transformCallBack.execute(component);
            }
        }
        finally {
            this.stack.pop();
        }
    }

    public void accept(DataObjectInfo dataObject) {
        MetaDataObject mdo = new MetaDataObject();
        mdo.name = dataObject.getName();
        mdo.type = dataObject.getType();
        mdo.objectType = dataObject.getObjectType();
        mdo.userDefined = dataObject.isUserDefined();
        mdo.herited = dataObject.isHerited();
        if (this.metaUI.dataObjects == null) {
            this.metaUI.dataObjects = new ArrayList<MetaDataObject>();
        }
        this.metaUI.dataObjects.add(mdo);
        if (this.transformCallBack != null) {
            this.transformCallBack.execute(dataObject);
        }
    }

    public void accept(ActionInfo action) {
        MetaAction ma = new MetaAction();
        ma.name = action.getName();
        ma.alias = action.getControlName();
        ma.acceleratorKey = action.getAcceleratorKey();
        ma.actionCommandKey = action.getActionCommandKey();
        ma.actionExtendProperty = action.getActionExtendProperty();
        ma.actionPerformed = action.getActionPerformed();
        ma.afterActionPerformed = action.getAfterActionPerformed();
        ma.batchMethodName = action.getBatchMethodName();
        ma.beforeActionPerformed = action.getBeforeActionPerformed();
        ma.className = action.getClassName();
        ma.daemonRun = action.isDaemonRun();
        ma.enable = action.isEnabled();
        ma.smallIcon = action.getSmallIcon();
        ma.shortDescription = action.getShortDesc();
        ma.longDescription = action.getLongDesc();
        ma.services = action.getServices();
        if (this.metaUI.actions == null) {
            this.metaUI.actions = new ArrayList<MetaAction>();
        }
        this.metaUI.actions.add(ma);
        if (this.transformCallBack != null) {
            this.transformCallBack.execute(action);
        }
    }

    public void accept(WebActionInfo action) {
        WebActionInfo ma = new WebActionInfo();
        ma.setName(action.getName());
        ma.setActionAsi(action.getActionAsi());
        ma.setActionDesc(action.getActionDesc());
        ma.setActionRef(action.getActionRef());
        ma.setRefCom(action.getRefCom());
        ma.setRefClass(action.getRefClass());
        ma.setActionBind(action.getActionBind());
        ma.setHerited(action.isHerited());
        ma.setOverride(action.isOverride());
        ma.setSubmit(action.isSubmit());
        ma.setCallFunction(action.getCallFunction());
        ma.setBindPage(action.isBindPage());
        ma.setBindButton(action.isBindButton());
        ma.setPageType(action.getPageType());
        ma.setBindPermissionItemId(action.getBindPermissionItemId());
        ma.setBindButton(action.isBindButton());
        ma.setExtendedProperty("permission", action.getExtendedProperty("permission"));
        ma.setExtendedProperty("pageActionPermission", action.getExtendedProperty("pageActionPermission"));
        ma.setExtendedProperty("isStrongControl", action.getExtendedProperty("isStrongControl"));
        ma.setExtendedProperty("mappingfields", action.getExtendedProperty("mappingfields"));
        ma.setExtendedProperty("isBackGroundRunning", action.getExtendedProperty("isBackGroundRunning"));
        ma.setExtendedProperty("flushprogressForBallMethod", action.getExtendedProperty("flushprogressForBallMethod"));
        ma.setExtendedProperty("successForBallMethod", action.getExtendedProperty("successForBallMethod"));
        ma.setExtendedProperty("stopActionForBallMethod", action.getExtendedProperty("stopActionForBallMethod"));
        ma.setExtendedProperty("pageActionBgr", action.getExtendedProperty("pageActionBgr"));
        ma.setExtendedProperty("serverActionBgr", action.getExtendedProperty("serverActionBgr"));
        ma.setExtendedProperty("mutex", action.getExtendedProperty("mutex"));
        if (this.metaUI.getWebActions() == null) {
            this.metaUI.webActions = new ArrayList<WebActionInfo>();
        }
        this.metaUI.webActions.add(ma);
        if (this.transformCallBack != null) {
            this.transformCallBack.execute(action);
        }
    }

    public void accept(WebResourceInfo webResourceInfo) {
        WebResourceInfo ma = new WebResourceInfo();
        ma.setName(webResourceInfo.getName());
        ma.setCn(webResourceInfo.getCn());
        ma.setUs(webResourceInfo.getUs());
        ma.setTw(webResourceInfo.getTw());
        if (this.metaUI.getWebResources() == null) {
            this.metaUI.webResources = new ArrayList<WebResourceInfo>();
        }
        this.metaUI.webResources.add(ma);
        if (this.transformCallBack != null) {
            this.transformCallBack.execute(webResourceInfo);
        }
    }

    public void accept(PropertyInfo property) {
        MetaComponent mc = (MetaComponent)this.stack.peek();
        MetaComponentProperty mp = new MetaComponentProperty();
        mp.name = property.getName();
        mp.type = property.getType();
        mp.userDefined = property.isUserDefined();
        mp.value = property.getValue();
        mp.setMultiLan(property.isMultiLanguage());
        String localeResKey = mc.name + "." + mp.name;
        if (this.localeResource.containsKey(localeResKey) && this.localeResource.get(localeResKey) != null) {
            mp.value = this.localeResource.get(localeResKey).toString();
        }
        if (mc.properties == null) {
            mc.properties = new ArrayList<MetaComponentProperty>();
        }
        mc.properties.add(mp);
        if (this.transformCallBack != null) {
            this.transformCallBack.execute(property);
        }
    }

    public void accept(PropertyBindingInfo propertyBinding) {
        MetaPropertyBinding mpb = new MetaPropertyBinding();
        mpb.bindingField = propertyBinding.getBingdingField();
        mpb.bindingObject = propertyBinding.getBindingObject();
        mpb.fieldType = propertyBinding.getFieldType();
        mpb.propertyName = propertyBinding.getPropertyName();
        mpb.propertyType = propertyBinding.getPropertyType();
        MetaComponent mc = (MetaComponent)this.stack.peek();
        MetaComponentProperty nameProperty = new MetaComponentProperty();
        nameProperty.setName("name");
        nameProperty.setType("String");
        nameProperty.setValue(mpb.bindingField);
        nameProperty.setMultiLan(false);
        nameProperty.setUserDefined(false);
        mc.getProperties().add(nameProperty);
        if (mc.propertyBindings == null) {
            mc.propertyBindings = new ArrayList<MetaPropertyBinding>();
        }
        mc.propertyBindings.add(mpb);
        this.proptyBindings.put(mpb.propertyName, mpb);
        if (this.transformCallBack != null) {
            this.transformCallBack.execute(propertyBinding);
        }
    }

    public void accept(EventBindingInfo eventBinding) {
        MetaEventBinding meb = new MetaEventBinding();
        meb.code = eventBinding.getCode();
        meb.eventName = eventBinding.getEventName();
        meb.eventType = eventBinding.getEventType();
        meb.herited = eventBinding.isHerited();
        meb.isBindWorkFlow = eventBinding.isBindWorkFlow();
        meb.listenerAdapter = eventBinding.getListenerAdapter();
        meb.listenerType = eventBinding.getListenerType();
        meb.methodName = eventBinding.getMethodName();
        meb.userDefined = eventBinding.isUserDefined();
        MetaComponent mc = (MetaComponent)this.stack.peek();
        if (mc.eventBindings == null) {
            mc.eventBindings = new ArrayList<MetaEventBinding>();
        }
        mc.eventBindings.add(meb);
        if (this.transformCallBack != null) {
            this.transformCallBack.execute(eventBinding);
        }
    }

    public void accept(WebEventInfo webEventInfo) {
        MetaEventBinding meb = new MetaEventBinding();
        meb.code = webEventInfo.getEventName();
        meb.eventName = webEventInfo.getEventName();
        meb.methodName = webEventInfo.getMethodName();
        meb.setListenerAdapter(webEventInfo.getCallFunction());
        MetaComponent mc = (MetaComponent)this.stack.peek();
        if (mc.eventBindings == null) {
            mc.eventBindings = new ArrayList<MetaEventBinding>();
        }
        mc.eventBindings.add(meb);
        if (this.transformCallBack != null) {
            this.transformCallBack.execute(webEventInfo);
        }
    }

    public void accept(StatusInfo statusInfo) {
        MetaStatus ms = new MetaStatus();
        ms.name = statusInfo.getName();
        for (int nIndex = 0; nIndex < statusInfo.getStatusItems().size(); ++nIndex) {
            StatusItemInfo statusItemInfo = statusInfo.getStatusItems().get(nIndex);
            MetaStateItem mst = new MetaStateItem();
            mst.setName(statusItemInfo.getName());
            if (statusItemInfo.getEnabled() != null && statusItemInfo.getEnabled().length() > 0) {
                mst.setEnabled(Boolean.parseBoolean(statusItemInfo.getEnabled()));
            } else {
                mst.setEnabled(true);
            }
            if (statusItemInfo.getVisible() != null && statusItemInfo.getVisible().length() > 0) {
                mst.setVisible(Boolean.parseBoolean(statusItemInfo.getVisible()));
            } else {
                mst.setVisible(true);
            }
            ms.getStateItems().add(mst);
        }
        this.metaUI.getStatus().add(ms);
        if (this.transformCallBack != null) {
            this.transformCallBack.execute(statusInfo);
        }
    }

    public void accept(LayoutInfo layoutInfo) {
        MetaLayout ml = new MetaLayout();
        ml.name = layoutInfo.getName();
        ml.type = layoutInfo.getType();
        ml.value = layoutInfo.getValue();
        MetaComponent mc = (MetaComponent)this.stack.peek();
        mc.layout = ml;
        if (this.transformCallBack != null) {
            this.transformCallBack.execute(layoutInfo);
        }
    }

    public void finish() {
        if (this.metaUI.components == null) {
            return;
        }
        HashMap<String, MetaComponent> map = new HashMap<String, MetaComponent>();
        for (MetaComponent mc : this.metaUI.components) {
            map.put(mc.name, mc);
        }
        ArrayList<MetaComponent> aloneComponent = new ArrayList<MetaComponent>();
        for (MetaComponent mc : this.metaUI.components) {
            if (mc.parentName != null) {
                mc.parent = (MetaComponent)map.get(mc.parentName);
                if (mc.parent.components == null) {
                    mc.parent.components = new ArrayList<MetaComponent>();
                }
                mc.parent.components.add(mc);
                continue;
            }
            if ("com.kingdee.bos.ctrl.web.RootPane".equals(mc.getClassType())) continue;
            aloneComponent.add(mc);
        }
        for (MetaComponent mc : aloneComponent) {
            this.metaUI.components.remove(mc);
        }
        for (MetaComponent mc : this.metaUI.components) {
            ArrayList<String> currentNames = new ArrayList<String>();
            currentNames.add(mc.getName());
            while (mc.parent != null) {
                mc = mc.parent;
                if (currentNames.contains(mc.getName())) {
                    logger.error((Object)("meta component loops forever,please check;page:" + this.metaUI.getName() + ";component:" + mc.getName()));
                    throw new MetaEndlessException("meta component loops forever,please check");
                }
                currentNames.add(mc.getName());
            }
        }
    }
}

