/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.json.adapter;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.json.adapter.BosObjectTypeAdapter;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import java.lang.reflect.Type;
import org.apache.log4j.Logger;

public class BosObjectCollectionTypeAdapter
implements JsonSerializer<IObjectCollection>,
JsonDeserializer<IObjectCollection> {
    protected static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.json.adapter.BosObjectCollectionTypeAdapter");

    public JsonElement serialize(IObjectCollection coll, Type type, JsonSerializationContext context) {
        BosObjectTypeAdapter adapter = new BosObjectTypeAdapter();
        JsonArray ret = new JsonArray();
        try {
            for (int nIndex = 0; nIndex < coll.size(); ++nIndex) {
                JsonObject e = adapter.serialize(coll.getObject(nIndex), (Type)null, context);
                ret.add((JsonElement)e);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public IObjectCollection deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
        BosObjectTypeAdapter adapter = new BosObjectTypeAdapter();
        IObjectCollection objectCollection = null;
        if (!element.isJsonArray()) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(type.toString().substring(type.toString().indexOf(" ") + 1));
            JsonArray jsonArray = element.getAsJsonArray();
            if (IObjectCollection.class.isAssignableFrom(clazz) && jsonArray.size() > 0) {
                JsonObject jsonObject = jsonArray.get(0).getAsJsonObject();
                JsonElement bosType = jsonObject.get("bosType");
                if (bosType == null) {
                    logger.error((Object)"bosType is null,please check you data!");
                } else {
                    EntityObjectInfo entityObjectInfo = this.getEntityInfo(BOSObjectType.create((String)bosType.getAsString()));
                    clazz = Class.forName(entityObjectInfo.getObjectCollectionClass());
                }
            }
            if ((objectCollection = (IObjectCollection)clazz.newInstance()) != null) {
                Type itemType = this.getEntryValueType(objectCollection);
                for (int nIndex = 0; nIndex < jsonArray.size(); ++nIndex) {
                    objectCollection.addObject(adapter.deserialize(jsonArray.get(nIndex), itemType, context));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("deserialize object error !" + e));
        }
        return objectCollection;
    }

    private Type getEntryValueType(IObjectCollection collection) {
        long s11 = System.currentTimeMillis();
        Class<?> returnType = null;
        String collectionClassName = collection.getClass().getName();
        String entryInfoClassName = collectionClassName.substring(0, collectionClassName.indexOf("Collection"));
        entryInfoClassName = entryInfoClassName + "Info";
        try {
            returnType = Class.forName(entryInfoClassName);
        }
        catch (ClassNotFoundException exception) {
            logger.error((Object)exception);
        }
        long e11 = System.currentTimeMillis();
        if (returnType != null) {
            this.log("getEntryValueType: " + ((Object)returnType).toString(), e11, s11);
        }
        return returnType;
    }

    private EntityObjectInfo getEntityInfo(BOSObjectType bosType) {
        long s1 = System.currentTimeMillis();
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo entityInfo = loader.getEntity(bosType);
        this.log("getEntityInfo: " + bosType + " t1: ", System.currentTimeMillis(), s1);
        return entityInfo;
    }

    public void log(String msg) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)msg);
        }
    }

    public void log(String msg, long end, long start) {
        if (end - start > 1L) {
            logger.debug((Object)(msg + " t:" + (end - start)));
        }
    }
}

