/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.json.adapter;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.TypelessObjectValue;
import com.kingdee.bos.json.ConstructorConstructor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.apache.log4j.Logger;

public class ObjectCollectionTypeAdapterFactory
implements TypeAdapterFactory {
    private static final Logger logger = Logger.getLogger(ObjectCollectionTypeAdapterFactory.class);

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        Type type = typeToken.getType();
        Class rawType = typeToken.getRawType();
        if (!IObjectCollection.class.isAssignableFrom(rawType)) {
            return null;
        }
        Class<?> elementType = this.getCollectionElementType(type, rawType);
        TypeAdapter elementTypeAdapter = gson.getAdapter(TypeToken.get(elementType));
        ObjectConstructor constructor = new ConstructorConstructor().get(rawType);
        Adapter result = new Adapter(gson, elementType, elementTypeAdapter, constructor);
        return result;
    }

    private Class<?> getCollectionElementType(Type type, Class<?> rawType) {
        try {
            Method m = rawType.getMethod("get", Integer.TYPE);
            if (m != null) {
                return m.getReturnType();
            }
        }
        catch (Exception e) {
            logger.error((Object)("can't find get(int) method in " + rawType.getName()), (Throwable)e);
        }
        return TypelessObjectValue.class;
    }

    private static final class Adapter
    extends TypeAdapter<IObjectCollection> {
        private final TypeAdapter elementTypeAdapter;
        private final ObjectConstructor<?> constructor;

        public Adapter(Gson context, Type elementType, TypeAdapter<?> elementTypeAdapter2, ObjectConstructor<?> constructor2) {
            this.elementTypeAdapter = elementTypeAdapter2;
            this.constructor = constructor2;
        }

        public IObjectCollection read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            IObjectCollection collection = (IObjectCollection)this.constructor.construct();
            in.beginArray();
            while (in.hasNext()) {
                IObjectValue instance = (IObjectValue)this.elementTypeAdapter.read(in);
                collection.addObject(instance);
            }
            in.endArray();
            return collection;
        }

        public void write(JsonWriter out, IObjectCollection collection) throws IOException {
            if (collection == null) {
                out.nullValue();
                return;
            }
            out.beginArray();
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                this.elementTypeAdapter.write(out, (Object)collection.getObject(i));
            }
            out.endArray();
        }
    }
}

