/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.json.adapter;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.kingdee.bos.json.ConstructorConstructor;
import com.kingdee.util.IPropertyContainer;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

class PropertyContainerTypeAdapterFactory
implements TypeAdapterFactory {
    private static final Logger logger = Logger.getLogger(PropertyContainerTypeAdapterFactory.class);

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        Type type = typeToken.getType();
        Class rawType = typeToken.getRawType();
        if (!IPropertyContainer.class.isAssignableFrom(rawType)) {
            return null;
        }
        Class rawTypeOfSrc = .Gson.Types.getRawType((Type)type);
        Adapter result = new Adapter(gson, new ConstructorConstructor().get(rawTypeOfSrc));
        return result;
    }

    static class Adapter
    extends TypeAdapter<IPropertyContainer> {
        private final TypeAdapter<Map> mapAdaptor;
        private final ObjectConstructor<IPropertyContainer> constructor;

        public Adapter(Gson gson, ObjectConstructor<IPropertyContainer> constructor) {
            this.mapAdaptor = gson.getAdapter(Map.class);
            this.constructor = constructor;
        }

        public void write(JsonWriter out, IPropertyContainer value) throws IOException {
            HashMap<String, Object> map = null;
            if (value != null) {
                map = new HashMap<String, Object>(value.size());
                Enumeration enu = value.keys();
                while (enu.hasMoreElements()) {
                    String k = (String)enu.nextElement();
                    map.put(k, value.get(k));
                }
            }
            this.mapAdaptor.write(out, map);
        }

        public IPropertyContainer read(JsonReader in) throws IOException {
            Map map = (Map)this.mapAdaptor.read(in);
            IPropertyContainer pc = (IPropertyContainer)this.constructor.construct();
            this.setValue(pc, map);
            return pc;
        }

        void setValue(IPropertyContainer pc, String key, Object value) {
            String getter = "get" + key.substring(0, 1).toUpperCase() + key.substring(1);
            Class<?> clazz = pc.getClass();
            try {
                Method m = clazz.getMethod(getter, new Class[0]);
                Class<?> returnType = m.getReturnType();
                if (IPropertyContainer.class.isAssignableFrom(returnType)) {
                    ObjectConstructor<?> cons = new ConstructorConstructor().get(returnType);
                    IPropertyContainer subpc = (IPropertyContainer)cons.construct();
                    pc.put(key.toLowerCase(), (Object)subpc);
                    this.setValue(subpc, (Map)value);
                    return;
                }
            }
            catch (Exception e) {
                logger.warn((Object)("can't find getter for " + key + " in " + pc.getClass().getName()));
            }
            pc.put(key.toLowerCase(), value);
        }

        void setValue(IPropertyContainer pc, Map<String, Object> map) {
            Set<Map.Entry<String, Object>> entries = map.entrySet();
            for (Map.Entry<String, Object> e : entries) {
                this.setValue(pc, e.getKey(), e.getValue());
            }
        }
    }
}

