/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rabbitmq.amqp.impl.nio;

import com.kingdee.bos.rabbitmq.amqp.impl.nio.NioHelper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;

public class SslEngineHelper {
    public static boolean doHandshake(SocketChannel socketChannel, SSLEngine engine) throws IOException {
        ByteBuffer plainOut = ByteBuffer.allocate(engine.getSession().getApplicationBufferSize());
        ByteBuffer plainIn = ByteBuffer.allocate(engine.getSession().getApplicationBufferSize());
        ByteBuffer cipherOut = ByteBuffer.allocate(engine.getSession().getPacketBufferSize());
        ByteBuffer cipherIn = ByteBuffer.allocate(engine.getSession().getPacketBufferSize());
        SSLEngineResult.HandshakeStatus handshakeStatus = engine.getHandshakeStatus();
        while (handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED && handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            switch (handshakeStatus) {
                case NEED_TASK: {
                    handshakeStatus = SslEngineHelper.runDelegatedTasks(engine);
                    break;
                }
                case NEED_UNWRAP: {
                    handshakeStatus = SslEngineHelper.unwrap(cipherIn, plainIn, socketChannel, engine);
                    break;
                }
                case NEED_WRAP: {
                    handshakeStatus = SslEngineHelper.wrap(plainOut, cipherOut, socketChannel, engine);
                }
            }
        }
        return true;
    }

    private static SSLEngineResult.HandshakeStatus runDelegatedTasks(SSLEngine sslEngine) {
        Runnable runnable;
        while ((runnable = sslEngine.getDelegatedTask()) != null) {
            runnable.run();
        }
        return sslEngine.getHandshakeStatus();
    }

    private static SSLEngineResult.HandshakeStatus unwrap(ByteBuffer cipherIn, ByteBuffer plainIn, ReadableByteChannel channel, SSLEngine sslEngine) throws IOException {
        SSLEngineResult.HandshakeStatus handshakeStatus = sslEngine.getHandshakeStatus();
        if (channel.read(cipherIn) < 0) {
            throw new SSLException("Could not read from socket channel");
        }
        cipherIn.flip();
        do {
            SSLEngineResult unwrapResult = sslEngine.unwrap(cipherIn, plainIn);
            SSLEngineResult.Status status = unwrapResult.getStatus();
            switch (status) {
                case OK: {
                    plainIn.clear();
                    handshakeStatus = SslEngineHelper.runDelegatedTasks(sslEngine);
                    break;
                }
                case BUFFER_OVERFLOW: {
                    throw new SSLException("Buffer overflow during handshake");
                }
                case BUFFER_UNDERFLOW: {
                    cipherIn.compact();
                    int read = NioHelper.read(channel, cipherIn);
                    if (read <= 0) {
                        SslEngineHelper.retryRead(channel, cipherIn);
                    }
                    cipherIn.flip();
                    break;
                }
                case CLOSED: {
                    sslEngine.closeInbound();
                    break;
                }
                default: {
                    throw new SSLException("Unexpected status from " + unwrapResult);
                }
            }
        } while (cipherIn.hasRemaining());
        cipherIn.compact();
        return handshakeStatus;
    }

    private static int retryRead(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        int read = 0;
        for (int attempt = 0; attempt < 3; ++attempt) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            read = NioHelper.read(channel, buffer);
            if (read > 0) break;
        }
        return read;
    }

    private static SSLEngineResult.HandshakeStatus wrap(ByteBuffer plainOut, ByteBuffer cipherOut, WritableByteChannel channel, SSLEngine sslEngine) throws IOException {
        SSLEngineResult.HandshakeStatus handshakeStatus = sslEngine.getHandshakeStatus();
        SSLEngineResult.Status status = sslEngine.wrap(plainOut, cipherOut).getStatus();
        switch (status) {
            case OK: {
                handshakeStatus = SslEngineHelper.runDelegatedTasks(sslEngine);
                cipherOut.flip();
                while (cipherOut.hasRemaining()) {
                    channel.write(cipherOut);
                }
                cipherOut.clear();
                break;
            }
            case BUFFER_OVERFLOW: {
                throw new SSLException("Buffer overflow during handshake");
            }
            default: {
                throw new SSLException("Unexpected status " + (Object)((Object)status));
            }
        }
        return handshakeStatus;
    }

    static int bufferCopy(ByteBuffer from, ByteBuffer to) {
        int maxTransfer = Math.min(to.remaining(), from.remaining());
        ByteBuffer temporaryBuffer = from.duplicate();
        temporaryBuffer.limit(temporaryBuffer.position() + maxTransfer);
        to.put(temporaryBuffer);
        from.position(from.position() + maxTransfer);
        return maxTransfer;
    }

    public static void write(WritableByteChannel socketChannel, SSLEngine engine, ByteBuffer plainOut, ByteBuffer cypherOut) throws IOException {
        block6: while (plainOut.hasRemaining()) {
            cypherOut.clear();
            SSLEngineResult result = engine.wrap(plainOut, cypherOut);
            switch (result.getStatus()) {
                case OK: {
                    cypherOut.flip();
                    while (cypherOut.hasRemaining()) {
                        socketChannel.write(cypherOut);
                    }
                    continue block6;
                }
                case BUFFER_OVERFLOW: {
                    throw new SSLException("Buffer overflow occured after a wrap.");
                }
                case BUFFER_UNDERFLOW: {
                    throw new SSLException("Buffer underflow occured after a wrap.");
                }
                case CLOSED: {
                    throw new SSLException("Buffer closed");
                }
            }
            throw new IllegalStateException("Invalid SSL status: " + (Object)((Object)result.getStatus()));
        }
    }

    public static void close(WritableByteChannel channel, SSLEngine engine) throws IOException {
        ByteBuffer plainOut = ByteBuffer.allocate(engine.getSession().getApplicationBufferSize());
        ByteBuffer cipherOut = ByteBuffer.allocate(engine.getSession().getPacketBufferSize());
        engine.closeOutbound();
        while (!engine.isOutboundDone()) {
            int num;
            engine.wrap(plainOut, cipherOut);
            cipherOut.flip();
            while (cipherOut.hasRemaining() && (num = channel.write(cipherOut)) != -1) {
            }
            cipherOut.clear();
        }
    }
}

