/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rabbitmq.connection;

import com.kingdee.bos.rabbitmq.amqp.Channel;
import com.kingdee.bos.rabbitmq.amqp.Connection;
import com.kingdee.bos.rabbitmq.connection.RabbitConnectionFactory;
import com.kingdee.bos.rabbitmq.consumer.QueueManager;
import com.kingdee.bos.rabbitmq.entity.ConnectionEntity;
import java.io.IOException;
import org.apache.log4j.Logger;

public class ChannelFactory {
    private static Logger logger = Logger.getLogger((String)ChannelFactory.class.getName());

    private ChannelFactory() {
    }

    public static Channel getChannel(String region, ConnectionEntity xmlConInfo) {
        if (null == xmlConInfo) {
            logger.error((Object)"get MQ connection information failed.");
            throw new RuntimeException("create MQ channel ,get MQ connection information failed.");
        }
        String serverKey = QueueManager.getRegionServerKey(xmlConInfo.getUserName(), region);
        Connection con = null;
        Channel channel = null;
        try {
            con = RabbitConnectionFactory.getConnection(serverKey, xmlConInfo);
            channel = con.createChannel();
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage());
            throw new RuntimeException("can't create channel", e);
        }
        return channel;
    }
}

