/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rabbitmq.consumer;

import com.kingdee.bos.rabbitmq.amqp.Channel;
import com.kingdee.bos.rabbitmq.entity.ConnectionEntity;
import com.kingdee.bos.rabbitmq.entity.ConsumerDef;
import com.kingdee.bos.rabbitmq.entity.IERPConsumerQueue;
import com.kingdee.bos.rabbitmq.entity.ProductorEntity;
import com.kingdee.bos.rabbitmq.entity.QueueDef;
import com.kingdee.bos.rabbitmq.initialize.InitQueue;
import com.kingdee.bos.rabbitmq.util.CollectionUtils;
import com.kingdee.bos.rabbitmq.util.MD5EncryptUtils;
import com.kingdee.bos.rabbitmq.util.StringUtils;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class QueueManager {
    private static final Logger logger = Logger.getLogger((String)QueueManager.class.getName());
    private static ConcurrentHashMap<String, QueueDef> queueDefs = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Boolean> queueDeclared = new ConcurrentHashMap();
    private static String queueTag = null;
    private static final String CALLBACK = "callback";

    private QueueManager() {
    }

    public static String getRealQueueName(String userName, String pwd, String region, String queueName, boolean needCallBack, String tag) {
        if ("true".equalsIgnoreCase(System.getProperty("mq.forbbiden"))) {
            throw new RuntimeException("\u5f53\u524d\u670d\u52a1\u5668\u4e0d\u5141\u8bb8\u542f\u52a8\u6d88\u8d39\u8005");
        }
        StringBuilder queneBuffer = new StringBuilder();
        String encryptUserAndPwd = MD5EncryptUtils.encryptBy16BitMD5(userName + "_" + pwd);
        queneBuffer.append(userName).append(".").append(encryptUserAndPwd).append(".").append(region).append(".").append(queueName);
        if (StringUtils.isNotEmpty(tag)) {
            queneBuffer.append(".").append(tag);
        }
        if (StringUtils.isNotEmpty(queueTag = System.getProperty("mq.debug.queue.tag"))) {
            queneBuffer.append(".").append(queueTag);
        }
        return QueueManager.getCallbackQueueName(queneBuffer.toString(), needCallBack);
    }

    public static String getCallbackQueueName(String queueName, boolean needCallBack) {
        if (needCallBack) {
            queueName = queueName + ".callback";
        }
        return queueName;
    }

    public static String getRegionServerKey(String userName, String region) {
        return userName + ".mq.server." + region;
    }

    public static QueueDef get(String userName, String region, String queue) {
        return queueDefs.get(QueueManager.makeKey(userName, region, queue));
    }

    public static void declareIfNeed(Channel channel, String region, String queue) {
        String key = QueueManager.makeKey(region, queue);
        if (Boolean.TRUE.equals(queueDeclared.get(key))) {
            return;
        }
        try {
            channel.queueDeclare(queue, true, false, false, null);
            queueDeclared.putIfAbsent(key, true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void add(String region, QueueDef queueDef, ConnectionEntity conn) {
        String key = QueueManager.makeKey(conn.getUserName(), region, queueDef.getName());
        if (null != queueDefs && !queueDefs.containsKey(key)) {
            queueDefs.put(key, queueDef);
        }
        QueueManager.initQueue(region, queueDef, conn);
    }

    public static void initIerpPerConsumerQueue(IERPConsumerQueue consumerQueue, ConnectionEntity conn, ProductorEntity autoCallBackProductor, boolean isSubscribe) {
        if (null == conn) {
            logger.error((Object)"init ierp queue,the MQ connection information is null.");
            throw new RuntimeException("init ierp queue,the MQ connection information is null.");
        }
        String queueName = QueueManager.getRealQueueName(conn.getUserName(), conn.getPassword(), consumerQueue.getRegion(), consumerQueue.getQueueName(), isSubscribe, consumerQueue.getTag());
        try {
            for (int i = 0; i < consumerQueue.getThreadCount(); ++i) {
                InitQueue.initIerpConsumer(consumerQueue, queueName, conn, autoCallBackProductor);
            }
        }
        catch (Exception e) {
            logger.error((Object)("ierp system init consumer failed." + e.getMessage()));
        }
    }

    private static void initQueue(String region, QueueDef queueDef, ConnectionEntity conn) {
        if (null == queueDef) {
            return;
        }
        List<ConsumerDef> consumers = queueDef.getConsumers();
        if (CollectionUtils.isEmpty(consumers)) {
            logger.error((Object)("MQ config consumers is empty for " + region + "/" + queueDef.getName()));
            return;
        }
        String productorName = queueDef.getProductor();
        boolean needCallBack = StringUtils.isNotEmpty(productorName);
        String queueName = QueueManager.getRealQueueName(conn.getUserName(), conn.getPassword(), region, queueDef.getName(), false, null);
        int threadCount = queueDef.getThreadCount() == 0 ? 1 : queueDef.getThreadCount();
        for (ConsumerDef consumer : consumers) {
            try {
                for (int i = 0; i < threadCount; ++i) {
                    InitQueue.initConsumer(region, queueName, consumer.getClassName(), consumer.isAutoAck(), conn, needCallBack, productorName);
                }
            }
            catch (Exception e) {
                logger.error((Object)("init queue consumer failed.exception info:" + e.getMessage()));
            }
        }
        for (int i = 1; i < consumers.size(); ++i) {
            logger.warn((Object)("mq.usage consumer " + consumers.get(i).getClassName() + " ignored. only one cunsumer allowed."));
        }
    }

    public static String makeKey(String userName, String region, String queueName) {
        if (StringUtils.isEmpty(region)) {
            return userName + ".mq.server." + queueName;
        }
        return userName + "_" + region + "_" + queueName;
    }

    private static String makeKey(String region, String queue) {
        return region + "." + queue;
    }
}

