/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rabbitmq.thread;

import com.kingdee.bos.rabbitmq.constant.MQConstantEnum;
import com.kingdee.bos.rabbitmq.entity.MQConfInfoEntity;
import com.kingdee.bos.rabbitmq.initialize.InitConfig;
import com.kingdee.bos.rabbitmq.util.StringUtils;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class RefreshReadTask
implements Runnable {
    private static Logger log = Logger.getLogger((String)RefreshReadTask.class.getName());
    private Properties sysProperties;

    public RefreshReadTask(Properties sysProperties) {
        this.sysProperties = sysProperties;
    }

    @Override
    public void run() {
        if (null == this.sysProperties) {
            log.error((Object)"the rabbitmq system properties config file is null.");
            return;
        }
        String path = this.sysProperties.getProperty(MQConstantEnum.MQ_CONFIG_PATH.getDesc());
        String dealClass = this.sysProperties.getProperty(MQConstantEnum.MQ_CONFIG_INITCLASS.getDesc());
        String strRefreshTime = this.sysProperties.getProperty(MQConstantEnum.MQ_CONFIG_REFRESH.getDesc());
        String sysType = this.sysProperties.getProperty(MQConstantEnum.MQ_SERVER_TYPE.getDesc());
        try {
            MQConfInfoEntity mqConfig = null;
            while (true) {
                mqConfig = InitConfig.loadMQConfigInfo(dealClass, path);
                InitConfig.cacheMQConfigInfo(sysType, mqConfig);
                TimeUnit.MINUTES.sleep(StringUtils.isEmpty(strRefreshTime) ? 0L : (long)Integer.parseInt(strRefreshTime));
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            return;
        }
    }
}

