/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.webservice;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.webservice.BOSTypeConvertor;
import com.kingdee.bos.webservice.BeanConvertUtil;
import com.kingdee.bos.webservice.MetaDataHelper;
import com.kingdee.bos.webservice.WSBean;
import com.kingdee.bos.webservice.WSEntityViewInfo;
import com.kingdee.util.enums.Enum;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class BeanConvertHelper {
    public WSBean toWSBean(IObjectValue obj, EntityObjectInfo entityInfo) {
        Object result;
        if (obj == null) {
            return null;
        }
        if (entityInfo == null) {
            return null;
        }
        try {
            Class<?> entityInfoClass = Class.forName(entityInfo.getPackage() + ".WS" + entityInfo.getName());
            result = entityInfoClass.newInstance();
            PropertyCollection properties = entityInfo.getInheritedNoDuplicatedProperties();
            for (int i = 0; i < properties.size(); ++i) {
                IObjectValue value;
                int t;
                Object[] wsValues;
                IObjectCollection values;
                IObjectCollection field;
                PropertyInfo entityPropertyInfo = properties.get(i);
                if (entityPropertyInfo instanceof OwnPropertyInfo) {
                    OwnPropertyInfo ownerPropertyInfo = (OwnPropertyInfo)entityPropertyInfo;
                    this.copyOwnerProperty2WS(ownerPropertyInfo, this.getPropertyValue(obj, ownerPropertyInfo.getName()), result);
                }
                if (!(entityPropertyInfo instanceof LinkPropertyInfo)) continue;
                LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)entityPropertyInfo;
                EntityObjectInfo childEntityInfo = linkPropertyInfo.getRelationship().getChildObject(entityInfo);
                Object childFieldValue = null;
                if (linkPropertyInfo.getRelationship().getChildCardinality(entityInfo).equals((Object)CardinalityType.ONE)) {
                    childFieldValue = this.toWSBean(this.getPropertyObjectValue(obj, linkPropertyInfo.getName()), childEntityInfo);
                } else if (linkPropertyInfo.getRelationship().getChildCardinality(entityInfo).equals((Object)CardinalityType.ONE_TO_UNBOUNDED)) {
                    field = this.getPropertyObjectCollection(obj, linkPropertyInfo.getName());
                    if (field != null) {
                        values = field;
                        wsValues = new Object[values.size()];
                        for (t = 0; t < values.size(); ++t) {
                            value = values.getObject(t);
                            wsValues[t] = childFieldValue = this.toWSBean(value, childEntityInfo);
                        }
                        childFieldValue = wsValues;
                    }
                } else if (linkPropertyInfo.getRelationship().getChildCardinality(entityInfo).equals((Object)CardinalityType.ZERO_TO_ONE)) {
                    childFieldValue = this.toWSBean(this.getPropertyObjectValue(obj, linkPropertyInfo.getName()), childEntityInfo);
                } else if (linkPropertyInfo.getRelationship().getChildCardinality(entityInfo).equals((Object)CardinalityType.ZERO_TO_UNBOUNDED) && (field = this.getPropertyObjectCollection(obj, linkPropertyInfo.getName())) != null) {
                    values = field;
                    wsValues = new Object[values.size()];
                    for (t = 0; t < values.size(); ++t) {
                        value = values.getObject(t);
                        wsValues[t] = childFieldValue = this.toWSBean(value, childEntityInfo);
                    }
                    childFieldValue = wsValues;
                }
                this.copyLinkProperty2WS(linkPropertyInfo, childFieldValue, result);
            }
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        return (WSBean)result;
    }

    private void copyLinkProperty2WS(LinkPropertyInfo linkPropertyInfo, Object childFieldValue, Object result) {
        if (childFieldValue == null) {
            return;
        }
        this.setPropertyValue(result, linkPropertyInfo.getName(), childFieldValue);
    }

    private void copyOwnerProperty2WS(OwnPropertyInfo ownerPropertyInfo, Object fieldValue, Object result) {
        this.setPropertyValue(result, ownerPropertyInfo.getName(), BeanConvertUtil.convertToNative(ownerPropertyInfo, fieldValue));
    }

    private IObjectCollection getPropertyObjectCollection(IObjectValue obj, String name) {
        Object propValue = this.getPropertyValue(obj, name);
        if (propValue instanceof IObjectCollection) {
            return (IObjectCollection)propValue;
        }
        return null;
    }

    private IObjectValue getPropertyObjectValue(IObjectValue obj, String name) {
        Object propValue = this.getPropertyValue(obj, name);
        if (propValue instanceof IObjectValue) {
            return (IObjectValue)propValue;
        }
        return null;
    }

    private Object getPropertyValue(Object obj, String propertyName) {
        Object propValue;
        if (obj == null) {
            return null;
        }
        try {
            Method method = obj.getClass().getMethod("get" + this.getTokenName(propertyName), null);
            propValue = method.invoke(obj, null);
        }
        catch (SecurityException e) {
            try {
                Method method = obj.getClass().getMethod("is" + this.getTokenName(propertyName), null);
                propValue = method.invoke(obj, null);
            }
            catch (Exception ex) {
                propValue = null;
            }
        }
        catch (NoSuchMethodException e) {
            propValue = null;
        }
        catch (IllegalArgumentException e) {
            propValue = null;
        }
        catch (IllegalAccessException e) {
            propValue = null;
        }
        catch (InvocationTargetException e) {
            propValue = null;
        }
        return propValue;
    }

    private void setPropertyValue(Object obj, String propertyName, Object value) {
        if (obj == null) {
            return;
        }
        if (value == null) {
            return;
        }
        Method method = null;
        try {
            method = obj.getClass().getMethod("put", String.class, Object.class);
            if (method == null) {
                return;
            }
            method.invoke(obj, propertyName, value);
        }
        catch (Exception e) {
            method = this.loadMethod(obj, "set" + this.getTokenName(propertyName), value.getClass());
            if (method == null) {
                return;
            }
            try {
                method.invoke(obj, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Method loadMethod(Object obj, String methodName, Class clazz) {
        Method method = null;
        try {
            method = obj.getClass().getMethod(methodName, clazz);
        }
        catch (Exception e) {
            try {
                method = obj.getClass().getMethod(methodName, this.getNativeClass(clazz));
            }
            catch (Exception ex) {
                method = null;
            }
        }
        return method;
    }

    private Class getNativeClass(Class clazz) {
        if (clazz.isAssignableFrom(Byte.class)) {
            return Byte.TYPE;
        }
        if (clazz.isAssignableFrom(Short.class)) {
            return Short.TYPE;
        }
        if (clazz.isAssignableFrom(Integer.class)) {
            return Integer.TYPE;
        }
        if (clazz.isAssignableFrom(Long.class)) {
            return Long.TYPE;
        }
        if (clazz.isAssignableFrom(Float.class)) {
            return Float.TYPE;
        }
        if (clazz.isAssignableFrom(Double.class)) {
            return Double.TYPE;
        }
        if (clazz.isAssignableFrom(Character.class)) {
            return Character.TYPE;
        }
        if (clazz.isAssignableFrom(Boolean.class)) {
            return Boolean.TYPE;
        }
        return null;
    }

    private String getTokenName(String propertyName) {
        String rtn = "";
        rtn = propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        return rtn;
    }

    public IObjectValue toValueObject(EntityObjectInfo entityInfo, WSBean bean) {
        Object result;
        if (bean == null) {
            return null;
        }
        if (entityInfo == null) {
            return null;
        }
        try {
            Class<?> entityInfoClass = Class.forName(entityInfo.getObjectValueClass());
            result = entityInfoClass.newInstance();
            PropertyCollection properties = entityInfo.getInheritedNoDuplicatedProperties();
            for (int i = 0; i < properties.size(); ++i) {
                PropertyInfo entityPropertyInfo = properties.get(i);
                if (entityPropertyInfo.isConfigured()) continue;
                if (entityPropertyInfo instanceof OwnPropertyInfo) {
                    OwnPropertyInfo ownerPropertyInfo = (OwnPropertyInfo)entityPropertyInfo;
                    this.copyOwnerProperty2VO(ownerPropertyInfo, this.getPropertyValue(bean, ownerPropertyInfo.getName()), result);
                }
                if (!(entityPropertyInfo instanceof LinkPropertyInfo)) continue;
                LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)entityPropertyInfo;
                EntityObjectInfo childEntityInfo = linkPropertyInfo.getRelationship().getChildObject(entityInfo);
                IObjectValue childFieldValue = null;
                if (linkPropertyInfo.getRelationship().getChildCardinality(entityInfo).equals((Object)CardinalityType.ONE)) {
                    childFieldValue = this.toValueObject(childEntityInfo, this.getPropertyWSValue(bean, linkPropertyInfo.getName()));
                } else if (linkPropertyInfo.getRelationship().getChildCardinality(entityInfo).equals((Object)CardinalityType.ONE_TO_UNBOUNDED)) {
                    childFieldValue = this.toObjectCollection(childEntityInfo, this.getPropertyWSArray(bean, linkPropertyInfo.getName()));
                } else if (linkPropertyInfo.getRelationship().getChildCardinality(entityInfo).equals((Object)CardinalityType.ZERO_TO_ONE)) {
                    childFieldValue = this.toValueObject(childEntityInfo, this.getPropertyWSValue(bean, linkPropertyInfo.getName()));
                } else if (linkPropertyInfo.getRelationship().getChildCardinality(entityInfo).equals((Object)CardinalityType.ZERO_TO_UNBOUNDED)) {
                    childFieldValue = this.toObjectCollection(childEntityInfo, this.getPropertyWSArray(bean, linkPropertyInfo.getName()));
                }
                this.copyLinkProperty2VO(linkPropertyInfo, childFieldValue, result);
            }
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        return (IObjectValue)result;
    }

    private void copyOwnerProperty2VO(OwnPropertyInfo ownerPropertyInfo, Object fieldValue, Object result) {
        if (ownerPropertyInfo.getDataType().equals((Object)DataType.ENUM)) {
            String enumType = ownerPropertyInfo.getMetaDataRef();
            this.setPropertyValue(result, ownerPropertyInfo.getName(), this.toEnum(MetaDataHelper.getEnumMetaData(enumType), (String)fieldValue));
        } else {
            this.setPropertyValue(result, ownerPropertyInfo.getName(), BOSTypeConvertor.toBOSType(ownerPropertyInfo.getDataType(), fieldValue));
        }
    }

    private void copyLinkProperty2VO(LinkPropertyInfo linkPropertyInfo, Object childFieldValue, Object result) {
        if (childFieldValue == null) {
            return;
        }
        this.setPropertyValue(result, linkPropertyInfo.getName(), childFieldValue);
    }

    private WSBean[] getPropertyWSArray(WSBean obj, String name) {
        Object propValue = this.getPropertyValue(obj, name);
        if (propValue instanceof WSBean[]) {
            return (WSBean[])propValue;
        }
        return null;
    }

    private WSBean getPropertyWSValue(WSBean obj, String name) {
        Object propValue = this.getPropertyValue(obj, name);
        if (propValue instanceof WSBean) {
            return (WSBean)propValue;
        }
        return null;
    }

    public IObjectCollection toObjectCollection(EntityObjectInfo entityInfo, WSBean[] bean) {
        try {
            Class<?> entityCollectionClass = Class.forName(entityInfo.getObjectCollectionClass());
            Object result = entityCollectionClass.newInstance();
            if (result instanceof IObjectCollection) {
                IObjectCollection returnVal = (IObjectCollection)result;
                for (int i = 0; i < bean.length; ++i) {
                    returnVal.addObject(this.toValueObject(entityInfo, bean[i]));
                }
                return returnVal;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Enum toEnum(BizEnumInfo enumInfo, String enumName) {
        try {
            Class<?> enumClass = Class.forName(enumInfo.getFullName());
            Method getEnum = enumClass.getMethod("getEnum", String.class);
            Object result = null;
            if (getEnum != null) {
                result = getEnum.invoke(null, enumName);
            }
            return (Enum)result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public WSBean[] toWSBeanArray(IObjectCollection collection) {
        if (collection != null) {
            WSBean[] objs = new WSBean[collection.size()];
            for (int i = 0; i < objs.length; ++i) {
                objs[i] = this.toWSBean(collection.getObject(i), MetaDataHelper.getEntityMetaData(collection.getObject(i).getBOSType()));
            }
            return objs;
        }
        return null;
    }

    public String enumToWSType(Enum enumVal) {
        return enumVal.getName();
    }

    public EntityViewInfo toEntityViewInfo(WSEntityViewInfo wsEntityViewInfo) {
        return null;
    }
}

