/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.webservice;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.bo.AccessLevel;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.webservice.MetaDataHelper;
import com.kingdee.bos.webservice.WSTypeInfo;
import java.util.HashMap;
import java.util.Map;

public class WSValidator {
    private static final String[] CUSTYPES = new String[]{"com.kingdee.bos.metadata.entity.EntityViewInfo"};
    private Map types = new HashMap();
    private Context ctx = null;

    public boolean validateMethod(BusinessObjectInfo entityInfo, MethodInfo method) {
        if (!method.getAccessLevel().equals((Object)AccessLevel.PUBLIC)) {
            return false;
        }
        if (method.getName().equals("getCollection") && !entityInfo.getMethods().contains(method)) {
            return false;
        }
        if (method.getDataType() != null && method.getDataType().length() > 0 && !this.isValidType(entityInfo, method, method.getDataType(), method.getMetaDataRef())) {
            return false;
        }
        boolean isValid = true;
        if (method.getParameters() != null) {
            for (int j = 0; j < method.getParameters().size(); ++j) {
                if (this.isValidType(entityInfo, method, method.getParameters().get(j).getDataType(), method.getParameters().get(j).getMetaDataRef())) continue;
                isValid = false;
                break;
            }
        }
        return isValid;
    }

    public WSTypeInfo getWSType(BusinessObjectInfo entityInfo, MethodInfo method, String type, String metadataRefType) {
        DataType dataType;
        String returnType = null;
        if (type == null) {
            return null;
        }
        if (type.trim().length() == 0) {
            return null;
        }
        WSTypeInfo resultInfo = new WSTypeInfo();
        String realTypeName = type;
        String packageName = "";
        String lastChar = "";
        boolean isOwn = entityInfo.getMethods().contains(method);
        if (realTypeName.indexOf(91) > 0) {
            lastChar = realTypeName.substring(realTypeName.indexOf(91));
            realTypeName = realTypeName.substring(0, realTypeName.indexOf(91));
        }
        if (realTypeName.equals("com.kingdee.bos.dao.IObjectPK")) {
            if (entityInfo instanceof FacadeInfo) {
                return null;
            }
            returnType = entityInfo.getName() + "WSPK" + lastChar;
            resultInfo.setName(returnType);
            resultInfo.setPkField(true);
            return resultInfo;
        }
        if (realTypeName.lastIndexOf(46) > 0) {
            packageName = realTypeName.substring(0, realTypeName.lastIndexOf(46));
            realTypeName = realTypeName.substring(realTypeName.lastIndexOf(46) + 1);
        }
        if ((dataType = DataType.getEnum((String)realTypeName)) != null) {
            if (dataType.equals((Object)DataType.OBJECTPK)) {
                if (entityInfo instanceof FacadeInfo) {
                    return null;
                }
                if (packageName.length() > 0) {
                    returnType = packageName + ".";
                }
                returnType = entityInfo.getName() + "WSPK";
                resultInfo.setName(returnType);
                resultInfo.setPkField(true);
                resultInfo.setType(dataType);
                return resultInfo;
            }
            if (dataType.equals((Object)DataType.OBJECTVALUE) || dataType.equals((Object)DataType.ENUM) || dataType.equals((Object)DataType.OBJECTCOLLECTION)) {
                if (metadataRefType == null) {
                    return null;
                }
                if (metadataRefType.trim().length() == 0) {
                    return null;
                }
            }
            if (dataType.equals((Object)DataType.ROWSET)) {
                return null;
            }
            if (dataType.equals((Object)DataType.ENUM)) {
                resultInfo.setName("String");
                resultInfo.setBosType(true);
                resultInfo.setBosEnumType(true);
                resultInfo.setType(dataType);
                resultInfo.setRefObjectName(metadataRefType);
                return resultInfo;
            }
            if (dataType.equals((Object)DataType.OBJECTVALUE)) {
                packageName = metadataRefType.substring(0, metadataRefType.lastIndexOf(46));
                realTypeName = metadataRefType.substring(metadataRefType.lastIndexOf(46) + 1);
                resultInfo.setName(packageName + ".WS" + realTypeName + "");
                resultInfo.setBosType(true);
                resultInfo.setBosValueType(true);
                resultInfo.setType(dataType);
                resultInfo.setRefObjectName(metadataRefType);
                if (!isOwn && MetaDataHelper.getEntityMetaData(this.ctx, entityInfo.getFullName()) != null && MetaDataHelper.getEntityMetaData(this.ctx, entityInfo.getFullName()).isSubFrom((BusinessObjectInfo)MetaDataHelper.getEntityMetaData(this.ctx, metadataRefType))) {
                    resultInfo.setName(entityInfo.getPackage() + ".WS" + entityInfo.getName() + lastChar);
                    resultInfo.setRefObjectName(entityInfo.getFullName());
                }
                return resultInfo;
            }
            if (dataType.equals((Object)DataType.OBJECTCOLLECTION)) {
                packageName = metadataRefType.substring(0, metadataRefType.lastIndexOf(46));
                realTypeName = metadataRefType.substring(metadataRefType.lastIndexOf(46) + 1);
                resultInfo.setName(packageName + ".WS" + realTypeName + "[]");
                resultInfo.setBosType(true);
                resultInfo.setBosCollectionType(true);
                resultInfo.setType(dataType);
                resultInfo.setRefObjectName(metadataRefType);
                return resultInfo;
            }
            resultInfo.setName(this.getJavaTypeName(dataType) + lastChar);
            resultInfo.setBosType(true);
            resultInfo.setType(dataType);
            return resultInfo;
        }
        if ("byte".equals(realTypeName)) {
            resultInfo.setName("byte" + lastChar);
            resultInfo.setSimpleType(true);
            return resultInfo;
        }
        if ("short".equals(realTypeName)) {
            resultInfo.setName("short" + lastChar);
            resultInfo.setSimpleType(true);
            return resultInfo;
        }
        if ("int".equals(realTypeName)) {
            resultInfo.setName("int" + lastChar);
            resultInfo.setSimpleType(true);
            return resultInfo;
        }
        if ("long".equals(realTypeName)) {
            resultInfo.setName("long" + lastChar);
            resultInfo.setSimpleType(true);
            return resultInfo;
        }
        if ("float".equals(realTypeName)) {
            resultInfo.setName("float" + lastChar);
            resultInfo.setSimpleType(true);
            return resultInfo;
        }
        if ("double".equals(realTypeName)) {
            resultInfo.setName("double" + lastChar);
            resultInfo.setSimpleType(true);
            return resultInfo;
        }
        if ("char".equals(realTypeName)) {
            resultInfo.setName("char" + lastChar);
            resultInfo.setSimpleType(true);
            return resultInfo;
        }
        if ("boolean".equals(realTypeName)) {
            resultInfo.setName("boolean" + lastChar);
            resultInfo.setSimpleType(true);
            return resultInfo;
        }
        for (int i = 0; i < this.types.keySet().toArray().length; ++i) {
            if (!this.types.keySet().toArray()[i].equals(type)) continue;
            resultInfo.setName((String)this.types.get(this.types.keySet().toArray()[i]));
            resultInfo.setCustomType(true);
            resultInfo.setBosType(false);
            resultInfo.setPkField(false);
            resultInfo.setSimpleType(false);
            return resultInfo;
        }
        return null;
    }

    public boolean isValidType(BusinessObjectInfo entityInfo, MethodInfo method, String type, String metadataRefType) {
        return this.getWSType(entityInfo, method, type, metadataRefType) != null;
    }

    public String getJavaTypeName(DataType dataType) {
        if (dataType.equals((Object)DataType.SHORT)) {
            return "short";
        }
        if (dataType.equals((Object)DataType.INTEGER)) {
            return "int";
        }
        if (dataType.equals((Object)DataType.LONG)) {
            return "long";
        }
        if (dataType.equals((Object)DataType.FLOAT)) {
            return "float";
        }
        if (dataType.equals((Object)DataType.DOUBLE)) {
            return "double";
        }
        if (dataType.equals((Object)DataType.DECIMAL)) {
            return "double";
        }
        if (dataType.equals((Object)DataType.DATE)) {
            return "String";
        }
        if (dataType.equals((Object)DataType.TIME)) {
            return "String";
        }
        if (dataType.equals((Object)DataType.TIMESTAMP)) {
            return "String";
        }
        if (dataType.equals((Object)DataType.CHAR)) {
            return "char";
        }
        if (dataType.equals((Object)DataType.BOOLEAN)) {
            return "boolean";
        }
        if (dataType.equals((Object)DataType.BYTE)) {
            return "byte";
        }
        if (dataType.equals((Object)DataType.STRING)) {
            return "String";
        }
        if (dataType.equals((Object)DataType.OBJECTPK)) {
            return IObjectPK.class.getName();
        }
        if (dataType.equals((Object)DataType.BOSUUID)) {
            return "String";
        }
        if (dataType.equals((Object)DataType.UUID)) {
            return "String";
        }
        if (dataType.equals((Object)DataType.ROWSET)) {
            return null;
        }
        if (dataType.equals((Object)DataType.BYTEARRAY)) {
            return "byte[]";
        }
        return null;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }
}

