/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.webservice.tool;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterInfo;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.webservice.WSMethodInfo;
import com.kingdee.bos.webservice.WSParaMetersInfo;
import com.kingdee.bos.webservice.WSPropertyInfo;
import com.kingdee.bos.webservice.WSTypeInfo;
import com.kingdee.bos.webservice.WSValidator;
import com.kingdee.bos.webservice.tool.WSEntityFileGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class WSBizProxyFileGenerator {
    private static final String NEWLINE = "\n";
    private static final String INDENT = "    ";
    private String packageName;
    private String className;
    private Set needFiles = new HashSet();
    private Context ctx = null;

    public StringBuffer generateJavaFile(BusinessObjectInfo entityInfo, List methods) {
        this.packageName = entityInfo.getPackage() + ".webservice";
        this.className = "WS" + entityInfo.getName() + "SrvProxy";
        StringBuffer fileContent = new StringBuffer();
        fileContent.append("package " + this.packageName + ";");
        fileContent.append(NEWLINE);
        fileContent.append(NEWLINE);
        fileContent.append("import org.apache.axis.Message;");
        fileContent.append(NEWLINE);
        fileContent.append(NEWLINE);
        fileContent.append("import org.apache.axis.MessageContext;");
        fileContent.append(NEWLINE);
        fileContent.append(NEWLINE);
        fileContent.append("import org.apache.axis.message.SOAPEnvelope;");
        fileContent.append(NEWLINE);
        fileContent.append(NEWLINE);
        fileContent.append("import org.apache.axis.message.SOAPHeaderElement;");
        fileContent.append(NEWLINE);
        fileContent.append(NEWLINE);
        fileContent.append("import com.kingdee.bos.webservice.WSConfig;");
        fileContent.append(NEWLINE);
        fileContent.append(NEWLINE);
        fileContent.append("import com.kingdee.bos.webservice.WSInvokeException;");
        fileContent.append(NEWLINE);
        fileContent.append("import com.kingdee.bos.dao.IObjectPK;");
        fileContent.append(NEWLINE);
        fileContent.append("import com.kingdee.bos.dao.ObjectMultiPK;");
        fileContent.append(NEWLINE);
        fileContent.append("import com.kingdee.bos.dao.ormapping.ObjectUuidPK;");
        fileContent.append(NEWLINE);
        fileContent.append("import com.kingdee.bos.orm.core.ORMEngine;");
        fileContent.append(NEWLINE);
        fileContent.append("import com.kingdee.bos.webservice.BeanConvertHelper;");
        fileContent.append(NEWLINE);
        fileContent.append("import com.kingdee.bos.webservice.BOSTypeConvertor;");
        fileContent.append(NEWLINE);
        fileContent.append("import com.kingdee.bos.util.BOSUuid;");
        fileContent.append(NEWLINE);
        fileContent.append("import com.kingdee.bos.webservice.WSConfig;");
        fileContent.append(NEWLINE);
        fileContent.append("import com.kingdee.bos.webservice.MetaDataHelper;");
        fileContent.append(NEWLINE);
        fileContent.append("import com.kingdee.bos.BOSObjectFactory;");
        fileContent.append(NEWLINE);
        fileContent.append(NEWLINE);
        fileContent.append("public class " + this.className + " { ");
        fileContent.append(NEWLINE);
        WSValidator validator = new WSValidator();
        validator.setCtx(this.ctx);
        HashMap<String, StringBuffer> duplicateMethods = new HashMap<String, StringBuffer>();
        for (int i = 0; i < methods.size(); ++i) {
            WSTypeInfo info;
            MethodInfo method = (MethodInfo)methods.get(i);
            if (!validator.validateMethod(entityInfo, method)) continue;
            WSMethodInfo wsMethod = new WSMethodInfo();
            wsMethod.setMethodName(method.getName());
            boolean isOwn = entityInfo.getMethods().contains(method);
            if ("getCollection".equals(method.getName()) && isOwn && this.parentHasCollectionMethod(entityInfo, method)) {
                wsMethod.setMethodName("get" + entityInfo.getName() + "Collection");
            }
            if (method.getDataType() == null) {
                info = new WSTypeInfo();
                info.setName("void");
                info.setVoidType(true);
                wsMethod.setReturnType(info);
            } else if (method.getDataType().length() == 0) {
                info = new WSTypeInfo();
                info.setName("void");
                info.setVoidType(true);
                wsMethod.setReturnType(info);
            } else {
                wsMethod.setReturnType(validator.getWSType(entityInfo, method, method.getDataType(), method.getMetaDataRef()));
            }
            if (wsMethod.getReturnType().getRefObjectName() != null && !wsMethod.getReturnType().isBosEnumType() && wsMethod.getReturnType().getRefObjectName().trim().length() > 0 && !wsMethod.getReturnType().getRefObjectName().equals(entityInfo.getFullName())) {
                this.needFiles.add(wsMethod.getReturnType().getRefObjectName());
            }
            if (method.getParameters() != null) {
                ArrayList<WSParaMetersInfo> paras = new ArrayList<WSParaMetersInfo>();
                for (int j = 0; j < method.getParameters().size(); ++j) {
                    ParameterInfo para = method.getParameters().get(j);
                    WSParaMetersInfo wsPara = new WSParaMetersInfo();
                    wsPara.setParameterName(para.getName());
                    wsPara.setParameterType(validator.getWSType(entityInfo, method, para.getDataType(), para.getMetaDataRef()));
                    if (wsPara.getParameterType().getRefObjectName() != null && !wsMethod.getReturnType().isBosEnumType() && wsPara.getParameterType().getRefObjectName().trim().length() > 0 && !wsPara.getParameterType().getRefObjectName().equals(entityInfo.getFullName())) {
                        this.needFiles.add(wsPara.getParameterType().getRefObjectName());
                    }
                    paras.add(wsPara);
                }
                wsMethod.setParameters(paras);
            }
            if (duplicateMethods.keySet().contains(wsMethod.getMethodConstraint().toString())) continue;
            duplicateMethods.put(wsMethod.getMethodConstraint().toString(), wsMethod.getMethodDefinition());
            fileContent.append(NEWLINE);
            fileContent.append(INDENT);
            fileContent.append(wsMethod.getMethodDefinition());
            fileContent.append(" {");
            fileContent.append(NEWLINE);
            fileContent.append(wsMethod.getMethodContent());
            fileContent.append(NEWLINE);
            fileContent.append(INDENT);
            fileContent.append("}");
            fileContent.append(NEWLINE);
        }
        fileContent.append(NEWLINE);
        fileContent.append(this.getControllerMethod(entityInfo));
        fileContent.append(NEWLINE);
        fileContent.append(NEWLINE);
        fileContent.append(this.getBeanConvertorMethod());
        fileContent.append(NEWLINE);
        fileContent.append(NEWLINE);
        if (entityInfo instanceof EntityObjectInfo) {
            fileContent.append(this.getToBOSObjectPKMethod((EntityObjectInfo)entityInfo));
            fileContent.append(NEWLINE);
            fileContent.append(NEWLINE);
            fileContent.append(this.getToWSPKMethod((EntityObjectInfo)entityInfo));
            fileContent.append(NEWLINE);
            fileContent.append(NEWLINE);
            fileContent.append(this.getToWSPKArrayMethod((EntityObjectInfo)entityInfo));
            fileContent.append(NEWLINE);
            fileContent.append(NEWLINE);
            fileContent.append(this.getToBOSObjectPKArrayMethod((EntityObjectInfo)entityInfo));
            fileContent.append(NEWLINE);
            fileContent.append(NEWLINE);
        }
        fileContent.append("}");
        return fileContent;
    }

    private StringBuffer getControllerMethod(BusinessObjectInfo entityInfo) {
        StringBuffer content = new StringBuffer();
        content.append(INDENT);
        content.append("private " + entityInfo.getBusinessInterface() + " getController() {");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append(INDENT);
        content.append("try {");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append(INDENT);
        content.append("if (WSConfig.getRomoteLocate()!=null&&WSConfig.getRomoteLocate().equals(\"false\")){");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append(INDENT);
        content.append(INDENT);
        content.append("Message message =MessageContext.getCurrentContext().getRequestMessage();");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append(INDENT);
        content.append(INDENT);
        content.append("SOAPEnvelope soap =message.getSOAPEnvelope();");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append(INDENT);
        content.append(INDENT);
        content.append("SOAPHeaderElement headerElement=soap.getHeaderByName(WSConfig.loginQName,WSConfig.loginSessionId);");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append(INDENT);
        content.append(INDENT);
        content.append("String SessionId=headerElement.getValue();");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append(INDENT);
        content.append(INDENT);
        content.append("return ( " + entityInfo.getBusinessInterface() + " )BOSObjectFactory.createBOSObject( SessionId , \"" + entityInfo.getBusinessImplName() + "\") ; ");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append(INDENT);
        content.append("} else {");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append(INDENT);
        content.append(INDENT);
        content.append("return ( " + entityInfo.getBusinessInterface() + " )BOSObjectFactory.createRemoteBOSObject( WSConfig.getSrvURL() , \"" + entityInfo.getBusinessImplName() + "\" , " + entityInfo.getBusinessInterface() + ".class ) ; ");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append(INDENT);
        content.append("}");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append(INDENT);
        content.append("}");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append(INDENT);
        content.append("catch( Throwable e ) {");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append(INDENT);
        content.append(INDENT);
        content.append("return ( " + entityInfo.getBusinessInterface() + " )ORMEngine.createRemoteObject( WSConfig.getSrvURL() , \"" + entityInfo.getBusinessImplName() + "\" , " + entityInfo.getBusinessInterface() + ".class ) ; ");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append(INDENT);
        content.append("}");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append("}");
        return content;
    }

    private StringBuffer getBeanConvertorMethod() {
        StringBuffer content = new StringBuffer();
        content.append(INDENT);
        content.append("private BeanConvertHelper getBeanConvertor() {");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append(INDENT);
        content.append("return new BeanConvertHelper(); ");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append("}");
        return content;
    }

    private StringBuffer getBOSTypeConvertorMethod() {
        StringBuffer content = new StringBuffer();
        content.append(INDENT);
        content.append("private BOSTypeConvertor getBosTypeConvertor() {");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append(INDENT);
        content.append("return new BOSTypeConvertor(); ");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append("}");
        return content;
    }

    private StringBuffer getMetaDataMethod() {
        StringBuffer content = new StringBuffer();
        content.append(INDENT);
        content.append("private EntityObjectInfo getMetaData( String metadataName ) {");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append(INDENT);
        content.append("try {");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append(INDENT);
        content.append(INDENT);
        content.append("MetaDataLoaderFactory.setClientMetaDataPath( WSConfig.getMetaDataPath() ) ;");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append(INDENT);
        content.append(INDENT);
        content.append("return MetaDataLoaderFactory.getLocalMetaDataLoader( null ).getEntity( new MetaDataPK(metadataName) ) ;");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append(INDENT);
        content.append("}");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append(INDENT);
        content.append("catch( Exception e ) {");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append(INDENT);
        content.append(INDENT);
        content.append("return null ;");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append(INDENT);
        content.append("}");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append("}");
        return content;
    }

    private StringBuffer getToBOSObjectPKMethod(EntityObjectInfo entityInfo) {
        String pkName = entityInfo.getName() + "WSPK";
        StringBuffer content = new StringBuffer();
        content.append(INDENT);
        content.append("private IObjectPK toBOSObjectPK( " + pkName + " pk ) {");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append(INDENT);
        content.append("IObjectPK rtv = null ;");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append(INDENT);
        WSEntityFileGenerator eg = new WSEntityFileGenerator();
        if (entityInfo.getLogicalKey().getKeyPropertys().size() > 1) {
            for (int i = 0; i < entityInfo.getLogicalKey().getKeyPropertys().size(); ++i) {
                PropertyInfo entityPropertyInfo = entityInfo.getLogicalKey().getKeyPropertys().get(i);
                WSPropertyInfo wsPropertyInfo = null;
                if (entityPropertyInfo instanceof OwnPropertyInfo) {
                    OwnPropertyInfo ownerPropertyInfo = (OwnPropertyInfo)entityPropertyInfo;
                    wsPropertyInfo = eg.getWSPropertyByOwner(ownerPropertyInfo);
                }
                if (entityPropertyInfo instanceof LinkPropertyInfo) {
                    LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)entityPropertyInfo;
                    EntityObjectInfo childEntityInfo = linkPropertyInfo.getRelationship().getChildObject(entityInfo);
                    wsPropertyInfo = eg.getWSPropertyByLink(linkPropertyInfo, entityInfo, childEntityInfo);
                }
                content.append("rtv = new ObjectMultiPK() ;");
                content.append(NEWLINE);
                content.append(INDENT);
                content.append(INDENT);
                content.append("rtv.setKeyValue( \"" + entityPropertyInfo.getName() + "\" , pk." + wsPropertyInfo.getGetterName() + " ) ;");
                content.append(NEWLINE);
                content.append(INDENT);
                content.append(INDENT);
            }
        } else if (entityInfo.getLogicalKey().getKeyPropertys().size() == 1) {
            PropertyInfo entityPropertyInfo = entityInfo.getLogicalKey().getKeyPropertys().get(0);
            WSPropertyInfo wsPropertyInfo = null;
            if (entityPropertyInfo instanceof OwnPropertyInfo) {
                OwnPropertyInfo ownerPropertyInfo = (OwnPropertyInfo)entityPropertyInfo;
                wsPropertyInfo = eg.getWSPropertyByOwner(ownerPropertyInfo);
            }
            if (entityPropertyInfo instanceof LinkPropertyInfo) {
                LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)entityPropertyInfo;
                EntityObjectInfo childEntityInfo = linkPropertyInfo.getRelationship().getChildObject(entityInfo);
                wsPropertyInfo = eg.getWSPropertyByLink(linkPropertyInfo, entityInfo, childEntityInfo);
            }
            content.append("rtv = new ObjectUuidPK( BOSUuid.read( pk." + wsPropertyInfo.getGetterName() + " ) ) ;");
            content.append(NEWLINE);
            content.append(INDENT);
            content.append(INDENT);
        }
        content.append("return rtv; ");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append("}");
        return content;
    }

    private StringBuffer getToWSPKMethod(EntityObjectInfo entityInfo) {
        String pkName = entityInfo.getName() + "WSPK";
        StringBuffer content = new StringBuffer();
        content.append(INDENT);
        content.append("private " + pkName + " toWSPK( IObjectPK pk ) {");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append(INDENT);
        content.append(pkName + " rtv = new " + pkName + "() ;");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append(INDENT);
        WSEntityFileGenerator eg = new WSEntityFileGenerator();
        for (int i = 0; i < entityInfo.getLogicalKey().getKeyPropertys().size(); ++i) {
            PropertyInfo entityPropertyInfo = entityInfo.getLogicalKey().getKeyPropertys().get(i);
            WSPropertyInfo wsPropertyInfo = null;
            DataType dataType = null;
            if (entityPropertyInfo instanceof OwnPropertyInfo) {
                OwnPropertyInfo ownerPropertyInfo = (OwnPropertyInfo)entityPropertyInfo;
                dataType = ownerPropertyInfo.getDataType();
                wsPropertyInfo = eg.getWSPropertyByOwner(ownerPropertyInfo);
            }
            if (entityPropertyInfo instanceof LinkPropertyInfo) {
                LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)entityPropertyInfo;
                EntityObjectInfo childEntityInfo = linkPropertyInfo.getRelationship().getChildObject(entityInfo);
                wsPropertyInfo = eg.getWSPropertyByLink(linkPropertyInfo, entityInfo, childEntityInfo);
            }
            content.append("rtv." + wsPropertyInfo.getSetterName() + "( (" + wsPropertyInfo.getJavaType() + ")com.kingdee.bos.webservice.BeanConvertUtil.convertToNative( com.kingdee.bos.metadata.entity.DataType.getEnum(\"" + dataType.getName() + "\") , pk.getKeyValue(\"" + entityPropertyInfo.getName() + "\")) ) ;");
            content.append(NEWLINE);
            content.append(INDENT);
            content.append(INDENT);
        }
        content.append("return rtv; ");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append("}");
        return content;
    }

    private StringBuffer getToWSPKArrayMethod(EntityObjectInfo entityInfo) {
        String pkName = entityInfo.getName() + "WSPK";
        StringBuffer content = new StringBuffer();
        content.append(INDENT);
        content.append("private " + pkName + "[] toWSPK( IObjectPK[] pk ) {");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append(INDENT);
        content.append(pkName + "[] rtv = new " + pkName + "[pk.length] ;");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append(INDENT);
        content.append("for( int i = 0 ; i < pk.length ; i ++ ) {");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append(INDENT);
        content.append(INDENT);
        content.append("rtv[i] = toWSPK( pk[i] ) ;");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append(INDENT);
        content.append("}");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append(INDENT);
        content.append("return rtv; ");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append("}");
        return content;
    }

    private StringBuffer getToBOSObjectPKArrayMethod(EntityObjectInfo entityInfo) {
        String pkName = entityInfo.getName() + "WSPK";
        StringBuffer content = new StringBuffer();
        content.append(INDENT);
        content.append("private IObjectPK[] toBOSObjectPK( " + pkName + "[] pk ) {");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append(INDENT);
        content.append("IObjectPK[] rtv = new IObjectPK[pk.length] ;");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append(INDENT);
        content.append("for( int i = 0 ; i < pk.length ; i ++ ) {");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append(INDENT);
        content.append(INDENT);
        content.append("rtv[i] = toBOSObjectPK( pk[i] ) ;");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append(INDENT);
        content.append("}");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append(INDENT);
        content.append("return rtv; ");
        content.append(NEWLINE);
        content.append(INDENT);
        content.append("}");
        return content;
    }

    public StringBuffer generatePKfile(EntityObjectInfo entityInfo) {
        WSPropertyInfo wsProperty;
        int j;
        HashSet<WSPropertyInfo> wsProperties = new HashSet<WSPropertyInfo>();
        WSEntityFileGenerator eg = new WSEntityFileGenerator();
        for (int i = 0; i < entityInfo.getLogicalKey().getKeyPropertys().size(); ++i) {
            EntityObjectInfo childEntityInfo;
            LinkPropertyInfo linkPropertyInfo;
            WSPropertyInfo wsPropertyInfo;
            OwnPropertyInfo ownerPropertyInfo;
            WSPropertyInfo wsPropertyInfo2;
            PropertyInfo entityPropertyInfo = entityInfo.getLogicalKey().getKeyPropertys().get(i);
            if (entityPropertyInfo instanceof OwnPropertyInfo && (wsPropertyInfo2 = eg.getWSPropertyByOwner(ownerPropertyInfo = (OwnPropertyInfo)entityPropertyInfo)) != null) {
                wsProperties.add(wsPropertyInfo2);
            }
            if (!(entityPropertyInfo instanceof LinkPropertyInfo) || (wsPropertyInfo = eg.getWSPropertyByLink(linkPropertyInfo = (LinkPropertyInfo)entityPropertyInfo, entityInfo, childEntityInfo = linkPropertyInfo.getRelationship().getChildObject(entityInfo))) == null) continue;
            wsProperties.add(wsPropertyInfo);
        }
        StringBuffer fileContext = new StringBuffer();
        this.packageName = entityInfo.getPackage() + ".webservice";
        this.className = entityInfo.getName() + "WSPK";
        fileContext.append("package " + this.packageName + ";");
        fileContext.append(NEWLINE);
        fileContext.append(NEWLINE);
        fileContext.append("public class " + this.className + " { ");
        fileContext.append(NEWLINE);
        for (j = 0; j < wsProperties.size(); ++j) {
            wsProperty = (WSPropertyInfo)wsProperties.toArray()[j];
            fileContext.append(wsProperty.getDefinition());
            fileContext.append(NEWLINE);
        }
        for (j = 0; j < wsProperties.size(); ++j) {
            wsProperty = (WSPropertyInfo)wsProperties.toArray()[j];
            fileContext.append(wsProperty.getGetter());
            fileContext.append(NEWLINE);
            fileContext.append(wsProperty.getSetter());
            fileContext.append(NEWLINE);
        }
        fileContext.append("}");
        return fileContext;
    }

    private boolean parentHasCollectionMethod(BusinessObjectInfo info, MethodInfo method) {
        boolean hasCollection = false;
        for (int i = 0; i < info.getAllMethods().size(); ++i) {
            MethodInfo parent;
            if (info.getMethods().contains(info.getAllMethods().get(i)) || !(parent = info.getAllMethods().get(i)).getName().equals("getCollection") || parent.getParameters().size() != method.getParameters().size()) continue;
            boolean sameType = true;
            for (int j = 0; j < parent.getParameters().size(); ++j) {
                if (parent.getParameters().get(j).getDataType().equals(method.getParameters().get(j).getDataType())) continue;
                sameType = false;
                break;
            }
            if (!sameType) continue;
            hasCollection = true;
            break;
        }
        return hasCollection;
    }

    public String getClassName() {
        return this.className;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Set getNeedFiles() {
        return this.needFiles;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }
}

