/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.webservice.tool;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.webservice.MetaDataHelper;
import com.kingdee.bos.webservice.ValidateResult;
import com.kingdee.bos.webservice.WSValidator;
import com.kingdee.bos.webservice.tool.FileGenerateException;
import com.kingdee.bos.webservice.tool.WSBizProxyFileGenerator;
import com.kingdee.bos.webservice.tool.WSDDFileGenerator;
import com.kingdee.bos.webservice.tool.WSEntityFileGenerator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class WSHelper {
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private Set hasGenerateFiles = new HashSet();
    private Set wsddFileLines = new HashSet();
    private Context ctx = null;

    public WSHelper() {
    }

    public WSHelper(Context ctx) {
        this.ctx = ctx;
    }

    public ValidateResult validate(BusinessObjectInfo objectInfo, MethodCollection methods) {
        ValidateResult result = new ValidateResult();
        WSValidator validator = new WSValidator();
        validator.setCtx(this.ctx);
        for (int i = 0; i < methods.size(); ++i) {
            if (validator.validateMethod(objectInfo, methods.get(i))) {
                result.getRights().put(methods.get(i), methods.get(i));
                continue;
            }
            result.getErrors().put(methods.get(i), methods.get(i));
        }
        return result;
    }

    public void generateJavaFile(BusinessObjectInfo objectInfo, List methods, String targetPath) throws FileGenerateException, IOException {
        if (objectInfo instanceof EntityObjectInfo) {
            this.generateAllFile(objectInfo, targetPath, "deploy.wsdd");
        }
        WSBizProxyFileGenerator proxyFileGenerator = new WSBizProxyFileGenerator();
        proxyFileGenerator.setCtx(this.ctx);
        StringBuffer buffer = proxyFileGenerator.generateJavaFile(objectInfo, methods);
        String fileDir = this.getFileDir(targetPath, proxyFileGenerator.getPackageName());
        File dir = new File(fileDir);
        if (dir != null) {
            dir.mkdirs();
        }
        OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(fileDir + proxyFileGenerator.getClassName() + ".java"));
        writer.write(buffer.toString());
        writer.close();
        if (objectInfo instanceof EntityObjectInfo) {
            StringBuffer buffer1 = proxyFileGenerator.generatePKfile((EntityObjectInfo)objectInfo);
            String fileDir1 = this.getFileDir(targetPath, proxyFileGenerator.getPackageName());
            File dir1 = new File(fileDir1);
            if (dir1 != null) {
                dir1.mkdirs();
            }
            OutputStreamWriter writer1 = new OutputStreamWriter(new FileOutputStream(fileDir1 + proxyFileGenerator.getClassName() + ".java"));
            writer1.write(buffer1.toString());
            writer1.close();
        }
        for (String fullName : proxyFileGenerator.getNeedFiles()) {
            try {
                EntityObjectInfo bo = MetaDataHelper.getEntityMetaData(this.ctx, fullName);
                this.generateAllFile((BusinessObjectInfo)bo, targetPath, bo.getName() + ".wsdd");
            }
            catch (Exception e1) {
                System.out.println(e1);
            }
        }
    }

    public void generateWSDDFile(BusinessObjectInfo objectInfo, List methods, String targetPath) throws FileGenerateException, IOException {
        String wsddFileName = objectInfo.getName() + ".wsdd";
        WSDDFileGenerator wsddFileGenerator = new WSDDFileGenerator();
        StringBuffer wsddFile = wsddFileGenerator.generateAllWSDDFile(objectInfo, this.wsddFileLines);
        OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(new File(targetPath + FILE_SEPARATOR + wsddFileName)));
        writer.write(wsddFile.toString());
        writer.close();
    }

    public void generateAllFile(BusinessObjectInfo objectInfo, String targetPath, String wsddFileName) throws FileGenerateException, IOException {
        WSEntityFileGenerator entityFile = new WSEntityFileGenerator();
        Map files = entityFile.generateFiles(objectInfo);
        WSDDFileGenerator wsddFileGenerator = new WSDDFileGenerator();
        for (String key : files.keySet()) {
            if (this.hasGenerateFiles.contains(key)) continue;
            if (!targetPath.endsWith(FILE_SEPARATOR)) {
                targetPath = targetPath + FILE_SEPARATOR;
            }
            String packageName = key.substring(0, key.lastIndexOf("."));
            String className = key.substring(key.lastIndexOf(".") + 1);
            String fileName = className + ".java";
            String fileDir = this.getFileDir(targetPath, packageName);
            File dir = new File(fileDir);
            if (dir != null) {
                dir.mkdirs();
            }
            OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(new File(fileDir + fileName)));
            writer.write(((StringBuffer)files.get(key)).toString());
            writer.close();
            this.hasGenerateFiles.add(key);
        }
        this.wsddFileLines.addAll(wsddFileGenerator.getWSDDFiles(objectInfo, files));
    }

    private String getFileDir(String targetPath, String packageName) {
        String result = targetPath;
        StringTokenizer st = new StringTokenizer(packageName, ".");
        if (!result.endsWith(FILE_SEPARATOR)) {
            result = result + FILE_SEPARATOR;
        }
        while (st.hasMoreElements()) {
            result = result + st.nextToken();
            result = result + FILE_SEPARATOR;
        }
        return result;
    }
}

