/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentAssoInfo;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoCollection;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.base.attachment.app.AbstractBizobjectFacadeControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class BizobjectFacadeControllerBean
extends AbstractBizobjectFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.attachment.app.BizobjectFacadeControllerBean");

    @Override
    protected IObjectValue _getBizobjectInfo(Context ctx, String boID) throws BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        ObjectUuidPK oup = new ObjectUuidPK(boID);
        BOSObjectType bot = oup.getObjectType();
        return new DynamicObject(ctx).getValue(bot, (IObjectPK)oup, sic);
    }

    @Override
    protected void _copyBizAttachmentFiles(Context ctx, String SourceboID, String destBoID) throws BOSException, EASBizException {
        if (SourceboID == null || SourceboID.trim().length() == 0) {
            logger.info((Object)"........ SourceboID is null,copy 0 files.");
            return;
        }
        IBoAttchAsso iBoattchAsso = BoAttchAssoFactory.getLocalInstance(ctx);
        String[] attachmentIDs = iBoattchAsso.getAttchIDsByBoID(SourceboID);
        if (attachmentIDs != null && attachmentIDs.length > 0) {
            ArrayList<AttachmentAssoInfo> fileList = new ArrayList<AttachmentAssoInfo>();
            IAttachment iAttachment = AttachmentFactory.getLocalInstance(ctx);
            for (int j = 0; j < attachmentIDs.length; ++j) {
                String newAttachmentId = iAttachment.copyAttachment(attachmentIDs[j]);
                if (!StringUtils.isEmpty((String)newAttachmentId)) {
                    AttachmentAssoInfo testInfo = new AttachmentAssoInfo();
                    testInfo.setBoID(destBoID);
                    testInfo.setAttachmentID(newAttachmentId);
                    fileList.add(testInfo);
                    logger.info((Object)("..... copy file, the old fid is:" + attachmentIDs[j] + " new id is:" + newAttachmentId));
                    continue;
                }
                logger.info((Object)(".. when copy attachment , copy 0 files, the fileId is:" + attachmentIDs[j]));
            }
            iBoattchAsso.addnew(fileList);
        }
    }

    @Override
    protected void _copyBizRelation(Context ctx, String sourceID, String destID) throws BOSException, EASBizException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("boID", (Object)sourceID, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        IBoAttchAsso iBo = BoAttchAssoFactory.getLocalInstance(ctx);
        BoAttchAssoCollection boCol = iBo.getBoAttchAssoCollection(entityViewInfo);
        if (boCol == null) {
            return;
        }
        for (int i = 0; i < boCol.size(); ++i) {
            BoAttchAssoInfo boAttInfo = boCol.get(i);
            boAttInfo.setId(null);
            boAttInfo.setBoID(destID);
            iBo.addnew(boAttInfo);
        }
    }

    @Override
    protected void _upAttID2BosID(Context ctx, String attID, String boID) throws BOSException {
        StringBuffer strSql = new StringBuffer();
        strSql.append("update T_BAS_BoAttchAsso set ");
        strSql.append("FBoID = '" + boID + "' ,");
        strSql.append(" FAssoBusObjType = '" + BOSUuid.read((String)boID).getType() + "'");
        strSql.append(" where FBoID = '" + attID + "'");
        DbUtil.execute((Context)ctx, (String)strSql.toString());
    }

    @Override
    protected void _delTempAttachment(Context ctx, String attID) throws BOSException {
        StringBuffer strSql = new StringBuffer();
        strSql.append("delete t_bas_attachment ");
        strSql.append("where fid in (select FAttachmentID from T_BAS_BoAttchAsso where FBoID = '" + attID + "')");
        DbUtil.execute((Context)ctx, (String)strSql.toString());
        strSql.append("delete T_BAS_BoAttchAsso where FBoID = '" + attID + "'");
        DbUtil.execute((Context)ctx, (String)strSql.toString());
    }
}

