/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataNotFoundException;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentAssoInfo;
import com.kingdee.eas.base.attachment.AttachmentException;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.BoAttchAssoCollection;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.IAttachmentDelBoIDCheck;
import com.kingdee.eas.base.attachment.app.AbstractAttachmentBizObjTypeBuilder;
import com.kingdee.eas.base.attachment.app.AbstractBoAttchAssoControllerBean;
import com.kingdee.eas.base.attachment.app.AttachmentBizObjBuilder;
import com.kingdee.eas.base.attachment.util.Resrcs;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.XMLConfiguration;
import com.kingdee.util.db.SQLUtils;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class BoAttchAssoControllerBean
extends AbstractBoAttchAssoControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.attachment.app.BoAttchAssoControllerBean");

    @Override
    protected int _getBoCountByAttchID(Context ctx, String attchID) throws BOSException {
        int boCount = 0;
        IRowSet rs = null;
        Connection cn = null;
        try {
            BOSUuid.read((String)attchID);
            cn = this.getConnection(ctx);
            String sql = "select count(FID) from T_BAS_BoAttchAsso where FAttachmentID= ? ";
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{attchID});
            rs.next();
            boCount = rs.getInt(1);
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Connection)cn);
        return boCount;
    }

    @Override
    protected int _getAttchCountByBoID(Context ctx, String boID) throws BOSException {
        int attchCount = 0;
        IRowSet rs = null;
        Connection cn = null;
        try {
            BOSUuid.read((String)boID);
            cn = this.getConnection(ctx);
            String sql = "select count(FID) from T_BAS_BoAttchAsso where FBoID= ? ";
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{boID});
            rs.next();
            attchCount = rs.getInt(1);
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Connection)cn);
        return attchCount;
    }

    @Override
    protected boolean _isAssociationExisted(Context ctx, String boID, String attchID) throws BOSException {
        boolean isExisted = false;
        IRowSet rs = null;
        Connection cn = null;
        try {
            BOSUuid.read((String)boID);
            BOSUuid.read((String)attchID);
            cn = this.getConnection(ctx);
            String sql = "select count(FID) from T_BAS_BoAttchAsso where FBoID= ? and FAttachmentID =? ";
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{boID, attchID});
            rs.next();
            if (rs.getInt(1) != 0) {
                isExisted = true;
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Connection)cn);
        return isExisted;
    }

    @Override
    protected String[] _getAttchIDsByBoID(Context ctx, String boID) throws BOSException {
        return this._getAttchIDsByBoID(ctx, boID, false);
    }

    @Override
    protected String[] _getAttchIDsByBoID(Context ctx, String boID, boolean isAsc) throws BOSException {
        String[] attchIDs = new String[]{};
        IRowSet rs = null;
        Connection cn = null;
        try {
            BOSUuid.read((String)boID);
            cn = this.getConnection(ctx);
            String sql = "select count(FID) from T_BAS_BoAttchAsso where FBoID= ? ";
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{boID});
            rs.next();
            int attchCount = rs.getInt(1);
            attchIDs = new String[attchCount];
            String asc = isAsc ? "asc" : "desc";
            sql = "select a.fattachmentid,b.fcreatetime from T_BAS_BoAttchAsso as a left join t_bas_attachment as b on a.fattachmentid = b.fid where a.FBoID = ? order by b.fcreatetime " + asc;
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{boID});
            for (int i = 0; i < attchCount; ++i) {
                rs.next();
                attchIDs[i] = rs.getString(1);
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Connection)cn);
        return attchIDs;
    }

    @Override
    protected void _deleteOneAssociation(Context ctx, String boID, String attchID) throws BOSException, EASBizException {
        FilterInfo fi = new FilterInfo();
        FilterItemCollection fic = fi.getFilterItems();
        fic.add(new FilterItemInfo("boID", (Object)boID, CompareType.EQUALS));
        fic.add(new FilterItemInfo("attachment.ID", (Object)attchID, CompareType.EQUALS));
        AttachmentInfo attachmentInfo = AttachmentFactory.getLocalInstance(ctx).getAttachmentInfo("select name where id = '" + attchID + "'");
        String logName = this.getLogInfo(boID) + " " + attachmentInfo.getName();
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"delete", (BOSObjectType)new AttachmentInfo().getBOSType(), (IObjectPK)new ObjectUuidPK(attchID), (String)logName, (String)"bs_attachment_attachment_delete");
        this.delete(ctx, fi);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        if (this.getBoCountByAttchID(ctx, attchID) == 0) {
            ServiceStateManager.getInstance().disableNextCallService("LOG_SERVICE");
            this.getIA(ctx).delete((IObjectPK)new ObjectUuidPK(attchID));
        }
        logger.info((Object)("@sky*******_deleteOneAssociation: boID:" + boID + " attchID:" + attchID));
    }

    @Override
    protected void _deleteAllAssociationsByBoID(Context ctx, String boID) throws BOSException, EASBizException {
        String[] attchIDs = this.getAttchIDsByBoID(ctx, boID);
        for (int i = 0; i < attchIDs.length; ++i) {
            this.deleteOneAssociation(ctx, boID, attchIDs[i]);
        }
    }

    private IAttachment getIA(Context ctx) throws BOSException {
        return AttachmentFactory.getLocalInstance(ctx);
    }

    @Override
    protected String[] _getAttachIDsByBOSType(Context ctx, String bosType) throws BOSException {
        String[] attchIDs = new String[]{};
        RowSet rs = null;
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            String sql = "select count(distinct FAttachmentID) from T_BAS_BoAttchAsso where FBoID like '%" + bosType + "'";
            rs = SQLUtils.getJdbcRowSet((Connection)cn, (String)sql);
            rs.next();
            int attchCount = rs.getInt(1);
            attchIDs = new String[attchCount];
            sql = "select distinct FAttachmentID from T_BAS_BoAttchAsso where FBoID like '%" + bosType + "'";
            rs = SQLUtils.getJdbcRowSet((Connection)cn, (String)sql);
            for (int i = 0; i < attchCount; ++i) {
                rs.next();
                attchIDs[i] = rs.getString(1);
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup((Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Connection)cn);
        return attchIDs;
    }

    @Override
    protected String[] _getAttachIDsByBOSTypeAndBeginTime(Context ctx, String bosType, Timestamp beginTime) throws BOSException {
        String[] attchIDs = new String[]{};
        ResultSet rs = null;
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            String sql = "select distinct a.FAttachmentID from T_BAS_BoAttchAsso a inner join T_BAS_Attachment b on a.FAttachmentID=b.FID where a.FBoID like '%" + bosType + "' and b.FLastUpdateTime>?";
            PreparedStatement ps = cn.prepareStatement(sql);
            ps.setTimestamp(1, beginTime);
            rs = ps.executeQuery();
            ArrayList<String> al = new ArrayList<String>();
            while (rs.next()) {
                al.add(rs.getString(1));
            }
            int soal = al.size();
            attchIDs = new String[soal];
            for (int i = 0; i < soal; ++i) {
                attchIDs[i] = al.get(i).toString();
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup((Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Connection)cn);
        return attchIDs;
    }

    @Override
    protected void _addAssociations(Context ctx, String boID, String[] attachIDs) throws BOSException, EASBizException {
        if (attachIDs != null && attachIDs.length != 0) {
            ArrayList<AttachmentAssoInfo> attachmentList = new ArrayList<AttachmentAssoInfo>();
            for (int i = 0; i < attachIDs.length; ++i) {
                AttachmentAssoInfo info = new AttachmentAssoInfo();
                info.setAttachmentID(attachIDs[i]);
                info.setBoID(boID);
                attachmentList.add(info);
            }
            this._addnew(ctx, attachmentList);
        }
    }

    @Override
    protected String[] _getAttchIDsByBoIDAndCode(Context ctx, String boID, String code) throws BOSException {
        String[] attchIDs = new String[]{};
        IRowSet rs = null;
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            String sql = "select a.FAttachmentID from T_BAS_BoAttchAsso a inner join T_BAS_Attachment b on a.FAttachmentID=b.FID where a.FBoID= ?  and b.FNumber= ? ";
            ArrayList<String> al = new ArrayList<String>();
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{boID, code});
            while (rs.next()) {
                al.add(rs.getString(1));
            }
            int size = al.size();
            attchIDs = new String[size];
            for (int i = 0; i < size; ++i) {
                attchIDs[i] = (String)al.get(i);
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup((Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Connection)cn);
        return attchIDs;
    }

    @Override
    protected void _deleteByBoList(Context ctx, String[] boIdAry) throws BOSException, EASBizException {
        if (boIdAry == null || boIdAry.length == 0) {
            return;
        }
        BoAttchAssoCollection boIdList = new BoAttchAssoCollection();
        for (int i = 0; i < boIdAry.length; ++i) {
            BoAttchAssoInfo boInfo = new BoAttchAssoInfo();
            boInfo.setBoID(boIdAry[i]);
            boIdList.add(boInfo);
        }
        this._deleteByBoList(ctx, (IObjectCollection)boIdList);
    }

    @Override
    protected void _deleteByBoList(Context ctx, IObjectCollection boIdList) throws EASBizException, BOSException {
        int i;
        List attchIdList = new ArrayList();
        if (boIdList == null || boIdList.isEmpty()) {
            return;
        }
        for (i = 0; i < boIdList.size(); ++i) {
            BoAttchAssoInfo boAttchAssoInfo = (BoAttchAssoInfo)boIdList.getObject(i);
            FilterInfo fi = new FilterInfo();
            FilterItemCollection fic = fi.getFilterItems();
            fic.add(new FilterItemInfo("boID", (Object)boAttchAssoInfo.getBoID(), CompareType.EQUALS));
            if (boAttchAssoInfo.getAttachment() != null && boAttchAssoInfo.getAttachment().getId() != null) {
                fic.add(new FilterItemInfo("attachment.ID", (Object)boAttchAssoInfo.getAttachment().getId().toString(), CompareType.EQUALS));
                logger.info((Object)("@sky*******_deleteByBoList: boID:" + boAttchAssoInfo.getBoID() + " attchID:" + boAttchAssoInfo.getAttachment().getId().toString()));
            }
            if (!this.isMayEditByBoID(ctx, boAttchAssoInfo.getBoID())) {
                throw new AttachmentException(AttachmentException.ASSOCIATIONREADONLY);
            }
            String[] attachId = this._getAttchIDsByBoID(ctx, boAttchAssoInfo.getBoID());
            AttachmentInfo attachmentInfo = AttachmentFactory.getLocalInstance(ctx).getAttachmentInfo("select name where id = '" + boAttchAssoInfo.getAttachment().getId() + "'");
            String logName = this.getLogInfo(boAttchAssoInfo.getBoID()) + " " + attachmentInfo.getName();
            IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"delete", (BOSObjectType)new AttachmentInfo().getBOSType(), (IObjectPK)new ObjectUuidPK(boAttchAssoInfo.getId()), (String)logName, (String)"bs_attachment_attachment_delete");
            this.delete(ctx, fi);
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
            attchIdList = this.add(attchIdList, attachId);
        }
        for (i = 0; i < attchIdList.size(); ++i) {
            if (this.getBoCountByAttchID(ctx, attchIdList.get(i).toString()) != 0) continue;
            String attachmentId = attchIdList.get(i).toString();
            ServiceStateManager.getInstance().disableNextCallService("LOG_SERVICE");
            this.getIA(ctx).delete((IObjectPK)new ObjectUuidPK(attachmentId));
        }
    }

    private List add(List sourceList, String[] idAry) {
        if (idAry == null || idAry.length == 0) {
            return sourceList;
        }
        if (sourceList == null) {
            sourceList = new ArrayList<String>();
        }
        for (int i = 0; i < idAry.length; ++i) {
            if (sourceList.contains(idAry[i])) continue;
            sourceList.add(idAry[i]);
        }
        return sourceList;
    }

    private boolean isMayEditByBoID(Context ctx, String boID) throws BOSException {
        IAttachmentDelBoIDCheck iAttachment;
        try {
            iAttachment = this.getClassByBizType(BOSUuid.read((String)boID).getType().toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (iAttachment == null) {
            return true;
        }
        return iAttachment.isMayEdit(ctx, boID);
    }

    private IAttachmentDelBoIDCheck getClassByBizType(String bizType) throws BOSException {
        XMLConfiguration xmlReader = XMLConfiguration.getInstance((URL)this.getClass().getResource(AbstractAttachmentBizObjTypeBuilder.PROPFILENAME));
        ConfigurationItem item = xmlReader.getConfigItem("checkBoMayDel");
        if (item.getProperty(bizType) != null) {
            String className = item.getProperty(bizType);
            try {
                return (IAttachmentDelBoIDCheck)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                logger.info((Object)("in " + AbstractAttachmentBizObjTypeBuilder.PROPFILENAME + " file ,bizType :" + bizType + " for class is fail!"));
                logger.info((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        logger.info((Object)(" return null , bizType is:" + bizType));
        return null;
    }

    @Override
    protected Map _getAllBizOjbType(Context ctx) throws BOSException {
        RowSet rs = null;
        Connection cn = null;
        Map retMap = new HashMap();
        try {
            String value;
            cn = this.getConnection(ctx);
            String sql = "select distinct fassobusobjtype from T_BAS_BoAttchAsso where fassobusobjtype is not null";
            String attachmentPerSql = "select distinct FSimpleName from t_bas_attachmentper where fsimpleName is not null";
            ArrayList<String> al = new ArrayList<String>();
            rs = SQLUtils.getJdbcRowSet((Connection)cn, (String)sql);
            while (rs.next()) {
                value = rs.getString(1);
                if (value == null || value.trim().length() == 0 || value.trim().equalsIgnoreCase("null")) continue;
                al.add(rs.getString(1).trim());
            }
            rs = SQLUtils.getJdbcRowSet((Connection)cn, (String)attachmentPerSql);
            while (rs.next()) {
                value = rs.getString(1);
                if (value == null || value.trim().length() == 0 || value.trim().equalsIgnoreCase("null") || al.contains(value)) continue;
                al.add(rs.getString(1).trim());
            }
            if (al != null && !al.isEmpty()) {
                AttachmentBizObjBuilder builder = new AttachmentBizObjBuilder();
                builder.buildSource(ctx, al);
                builder.build();
                retMap = builder.getResult();
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup((Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Connection)cn);
        return retMap;
    }

    @Override
    protected boolean _isReference(Context ctx, String boId, String attachmentId) throws BOSException {
        boolean bl;
        Connection cn;
        RowSet rs;
        block6: {
            int value;
            rs = null;
            cn = null;
            if (boId == null || attachmentId == null || boId.trim().length() == 0 || attachmentId.trim().length() == 0) {
                logger.info((Object)"........... boId or attachmentId is null, true will be return !");
                return true;
            }
            BOSUuid.read((String)boId);
            BOSUuid.read((String)attachmentId);
            cn = this.getConnection(ctx);
            String sql = "select count(fid) from t_bas_boattchasso where fboid <> '" + boId + "' and fattachmentid = '" + attachmentId + "'";
            rs = SQLUtils.getJdbcRowSet((Connection)cn, (String)sql);
            if (!rs.next() || (value = rs.getInt(1)) != 0) break block6;
            boolean bl2 = false;
            SQLUtils.cleanup((ResultSet)rs);
            SQLUtils.cleanup((Connection)cn);
            return bl2;
        }
        try {
            bl = true;
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Connection)cn);
        return bl;
    }

    @Override
    protected boolean _isMayEdit(Context ctx, String boID) throws BOSException {
        logger.info((Object)("....... server boID is:" + boID));
        return this.isMayEditByBoID(ctx, boID);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _addnew(Context ctx, List attachmentAssoInfoCol) throws BOSException {
        if (attachmentAssoInfoCol == null) return;
        if (attachmentAssoInfoCol.isEmpty()) {
            return;
        }
        String assoType = Resrcs.getString("ExistedAttachment", ctx.getLocale());
        String locale = ctx.getLocale().toString();
        Connection cn = null;
        Statement stm = null;
        try {
            cn = this.getConnection(ctx);
            stm = cn.createStatement();
            int size = attachmentAssoInfoCol.size();
            String sql = "";
            String fid = "";
            for (int i = 0; i < size; ++i) {
                AttachmentAssoInfo attachmentAssoInfo = (AttachmentAssoInfo)attachmentAssoInfoCol.get(i);
                BOSUuid bosuuid = BOSUuid.read((String)attachmentAssoInfo.getBoID());
                if (this.isAssociationExisted(ctx, attachmentAssoInfo.getBoID(), attachmentAssoInfo.getAttachmentID())) {
                    throw new AttachmentException(AttachmentException.ASSOCIATIONEXISTED);
                }
                fid = BOSUuid.create((BOSObjectType)this.getBOSType()).toString();
                AttachmentInfo attachmentInfo = AttachmentFactory.getLocalInstance(ctx).getAttachmentInfo("select name where id = '" + attachmentAssoInfo.getAttachmentID() + "'");
                String logName = this.getLogInfo(attachmentAssoInfo.getBoID()) + " " + attachmentInfo.getName();
                IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"addnew", (BOSObjectType)new AttachmentInfo().getBOSType(), (IObjectPK)new ObjectUuidPK(fid), (String)logName, (String)"bs_attachment_attachment_addnew");
                sql = "insert into T_BAS_BoAttchAsso (FID,FBoID,FAttachmentID,FAssoBusObjType,FAssoType_" + locale + ") values('" + fid + "','" + attachmentAssoInfo.getBoID() + "','" + attachmentAssoInfo.getAttachmentID() + "','" + bosuuid.getType().toString() + "','" + assoType + "')";
                stm.addBatch(sql);
                LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
            }
            stm.executeBatch();
        }
        catch (AttachmentException ae) {
            try {
                throw new BOSException(ae.getMessage());
                catch (BOSException be) {
                    throw be;
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((Connection)cn);
                SQLUtils.cleanup(stm);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)cn);
        SQLUtils.cleanup((Statement)stm);
    }

    private String getLogInfo(String boId) {
        String logName = "BOSType[00ABCDEF]";
        try {
            DataBaseInfo info;
            BOSUuid uuid = BOSUuid.read((String)boId);
            IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            EntityObjectInfo entity = loader.getEntity(uuid.getType());
            IObjectValue data = null;
            if (ConfigMDUtil.isClient()) {
                data = DynamicObjectFactory.getRemoteInstance().getValue(uuid.getType(), (IObjectPK)new ObjectUuidPK(uuid));
            } else {
                Context ctx = ConfigMDUtil.getContext();
                data = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(uuid.getType(), (IObjectPK)new ObjectUuidPK(uuid));
            }
            if (data instanceof DataBaseInfo) {
                info = (DataBaseInfo)data;
                logName = entity.getAlias() + " " + info.getNumber();
            } else if (data instanceof CoreBillBaseInfo) {
                info = (CoreBillBaseInfo)data;
                logName = entity.getAlias() + " " + info.getNumber();
            } else {
                logName = entity.getAlias() + " " + boId;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return logName;
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return null;
        }
        BoAttchAssoInfo boInfo = (BoAttchAssoInfo)model;
        if (boInfo.getBoID() != null) {
            boInfo.setAssoBusObjType(BOSUuid.read((String)boInfo.getBoID()).getType().toString());
        }
        return super._addnew(ctx, (IObjectValue)boInfo);
    }

    @Override
    protected int _getFileCount(Context ctx, String boID) throws BOSException {
        Statement stm;
        Connection cn;
        block5: {
            int n;
            if (StringUtils.isEmpty((String)boID)) {
                return 0;
            }
            String sqlStr = "select count(*) from t_bas_boattchasso where fboid = '" + boID + "'";
            cn = null;
            stm = null;
            try {
                cn = this.getConnection(ctx);
                stm = cn.createStatement();
                RowSet rs = SQLUtils.getJdbcRowSet((Connection)cn, (String)sqlStr);
                if (!rs.next()) break block5;
                n = rs.getInt(1);
            }
            catch (SQLException be) {
                try {
                    logger.error((Object)"findFileCount error!", (Throwable)be);
                    throw new BOSException();
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup((Connection)cn);
                    SQLUtils.cleanup(stm);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Connection)cn);
            SQLUtils.cleanup((Statement)stm);
            return n;
        }
        SQLUtils.cleanup((Connection)cn);
        SQLUtils.cleanup((Statement)stm);
        return 0;
    }

    @Override
    protected void _sortSeq(Context ctx, String billID, String attId, int seq) throws BOSException, EASBizException {
        ResultSet rs = null;
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            String updateSeq = "update T_BAS_BoAttchAsso b set fseq = ? where b.FAttachmentID =?and  b.FBoID = ?";
            DbUtil.execute((Context)ctx, (String)updateSeq, (Object[])new Object[]{seq, attId, billID});
        }
        catch (Throwable e) {
            throw new BOSException(e);
        }
        finally {
            SQLUtils.cleanup(rs);
            SQLUtils.cleanup((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map<String, List<String>> _getBoIDBosTypeByAttchID(Context ctx, String attachID) {
        RowSet rs = null;
        RowSet boRs = null;
        RowSet boNumRs = null;
        Connection cn = null;
        String boBosType = null;
        String boID = null;
        String tableName = null;
        String boNumber = null;
        ArrayList<String> boNumList = new ArrayList<String>();
        HashMap<String, List<String>> rsMap = new HashMap<String, List<String>>();
        try {
            cn = this.getConnection(ctx);
            String sql = "select distinct FAssoBusObjType from T_BAS_BoAttchAsso where FAttachmentID='" + attachID + "'";
            rs = SQLUtils.getJdbcRowSet((Connection)cn, (String)sql);
            String boSql = null;
            EntityObjectInfo entity = null;
            while (true) {
                String boSqlNum;
                if (rs.next()) {
                    try {
                        boBosType = rs.getString(1);
                        BOSObjectType bosType = BOSObjectType.create((String)boBosType);
                        entity = MetaDataLoader.getEntity(null, (BOSObjectType)bosType);
                        tableName = entity.getTable().getName();
                    }
                    catch (MetaDataNotFoundException e2) {
                        Map<String, List<String>> map = null;
                        SQLUtils.cleanup(boNumRs);
                        SQLUtils.cleanup(boRs);
                        SQLUtils.cleanup((ResultSet)rs);
                        SQLUtils.cleanup((Connection)cn);
                        return map;
                    }
                    boSql = "select FBoID from T_BAS_BoAttchAsso where FAttachmentID='" + attachID + "' and FAssoBusObjType='" + boBosType + "'";
                    boRs = SQLUtils.getJdbcRowSet((Connection)cn, (String)boSql);
                    boSqlNum = null;
                } else {
                    HashMap<String, List<String>> hashMap = rsMap;
                    SQLUtils.cleanup(boNumRs);
                    SQLUtils.cleanup(boRs);
                    SQLUtils.cleanup((ResultSet)rs);
                    SQLUtils.cleanup((Connection)cn);
                    return hashMap;
                }
                while (boRs.next()) {
                    try {
                        boID = boRs.getString(1);
                        boSqlNum = "select FNUMBER from " + tableName + " where FID='" + boID + "'";
                        boNumRs = SQLUtils.getJdbcRowSet((Connection)cn, (String)boSqlNum);
                        boNumRs.next();
                        boNumber = boNumRs.getString(1);
                    }
                    catch (Exception e) {
                        boNumber = boID;
                    }
                    boNumList.add(boNumber);
                }
                if (entity.getAlias() == null) {
                    rsMap.put(boBosType, boNumList);
                } else {
                    rsMap.put(entity.getAlias(), boNumList);
                }
                boNumList = new ArrayList();
            }
        }
        catch (Exception e) {
            Map<String, List<String>> map;
            try {
                logger.error((Object)("select error :" + e));
                map = null;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(boNumRs);
                SQLUtils.cleanup(boRs);
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup((Connection)cn);
                throw throwable;
            }
            SQLUtils.cleanup(boNumRs);
            SQLUtils.cleanup(boRs);
            SQLUtils.cleanup((ResultSet)rs);
            SQLUtils.cleanup((Connection)cn);
            return map;
        }
    }
}

