/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.app;

import com.kingdee.eas.base.attachment.ConnectionObject;
import com.kingdee.eas.base.attachment.FtpConfigInfo;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.util.CryptException;
import com.kingdee.eas.util.CryptoTean;
import com.kingdee.enterprisedt.net.ftp.FTPException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class FtpConnectionPool {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.attachment.app.FtpConnectionPool");
    private static final int MAX_FTPLINK = 30;
    private List ftpConn;
    private static FtpConnectionPool pool = null;

    private FtpConnectionPool() throws FTPException, IOException, CryptException {
        if (this.ftpConn == null) {
            this.ftpConn = new ArrayList();
        }
    }

    public static synchronized FtpConnectionPool getInstance() throws FTPException, IOException, CryptException {
        if (pool == null) {
            pool = new FtpConnectionPool();
        }
        return pool;
    }

    public void destroy() throws FTPException, IOException {
        this.releaseFtpConn();
        pool = null;
    }

    public synchronized ConnectionObject getConn(FtpConfigInfo config) throws FTPException, IOException, CryptException {
        for (ConnectionObject oneConn : this.ftpConn) {
            FtpConfigInfo config2 = oneConn.getConfig();
            if (this.configEquals(config2, config) && oneConn != null && !oneConn.getInUse()) {
                oneConn.setInUse(true);
                oneConn.setUseCount(oneConn.getUseCount() + 1);
                return oneConn;
            }
            if (this.configEquals(config2, config)) continue;
            this.releaseFtpConn();
        }
        ConnectionObject conn = this.getFtpConnection(config);
        if (this.ftpConn.size() < 30) {
            this.ftpConn.add(conn);
        } else {
            conn.setInPool(false);
        }
        conn.setInUse(true);
        return conn;
    }

    private boolean configEquals(FtpConfigInfo config1, FtpConfigInfo config2) throws CryptException {
        if (config1 == null || config2 == null) {
            return false;
        }
        return ToolUtils.equalObject((Object)config1.getHost(), (Object)config2.getHost()) && config1.getPort() == config2.getPort() && ToolUtils.equalObject((Object)config1.getUserName(), (Object)config2.getUserName()) && ToolUtils.equalObject((Object)CryptoTean.decrypt((String)config1.getUserName(), (String)config1.getPassword()), (Object)CryptoTean.decrypt((String)config2.getUserName(), (String)config2.getPassword()));
    }

    private ConnectionObject getFtpConnection(FtpConfigInfo config) throws FTPException, IOException, CryptException {
        return new ConnectionObject(config);
    }

    private void releaseFtpConn() {
        if (this.ftpConn == null) {
            this.ftpConn = new ArrayList();
        }
        int connectionObjectSize = this.ftpConn.size();
        try {
            if (connectionObjectSize > 0) {
                for (ConnectionObject oneConn : this.ftpConn) {
                    if (oneConn == null || oneConn.getInUse()) continue;
                    oneConn.getFtpConn().disconnect();
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.ftpConn = new ArrayList();
    }

    public synchronized void close() {
    }
}

