/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.ftp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.attachment.AttachmentFtpHandleFacadeFactory;
import com.kingdee.eas.base.attachment.ftp.AttachmentFtpInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class AttachmentDownloadServer {
    Logger logger = Logger.getLogger((String)AttachmentDownloadServer.class.getName());

    public InputStream getContent4Server(String attachmentID, Connection con) throws BOSException {
        ResultSet set;
        PreparedStatement ps;
        block4: {
            ByteArrayInputStream byteArrayInputStream;
            String sql = "select ffile from t_bas_attachment where fid = ?";
            ps = null;
            set = null;
            try {
                byte[] tempAry;
                ps = con.prepareStatement(sql);
                ps.setString(1, attachmentID);
                set = ps.executeQuery();
                if (!set.next() || (tempAry = set.getBytes(1)) == null) break block4;
                byteArrayInputStream = new ByteArrayInputStream(tempAry);
            }
            catch (SQLException e) {
                try {
                    this.logger.info((Object)e);
                    throw new BOSException("1query t_bas_attachment error");
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(set, (Statement)ps);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)set, (Statement)ps);
            return byteArrayInputStream;
        }
        SQLUtils.cleanup((ResultSet)set, (Statement)ps);
        return null;
    }

    public byte[] getContent(InputStream input, long startPos) throws BOSException {
        return this.getContent(input);
    }

    public byte[] getContent(InputStream input) throws BOSException {
        AttachmentFtpInfo.init();
        if (input == null) {
            this.logger.error((Object)"******AttachmentDownloadServer*****input is null***********");
            return null;
        }
        byte[] content = null;
        try {
            content = input.available() > AttachmentFtpInfo.MAX_OF_DOWNLOADLENGTH ? new byte[AttachmentFtpInfo.MAX_OF_DOWNLOADLENGTH] : new byte[input.available()];
            this.logger.error((Object)("***AttachmentDownloadServer***content.length=" + content.length));
            input.read(content, 0, content.length);
        }
        catch (IOException e) {
            this.logger.info((Object)e);
            throw new BOSException(e.getMessage());
        }
        return content;
    }

    public byte[] getFileFromFtp(Context ctx, String attachment) throws BOSException, EASBizException {
        byte[] temp = AttachmentFtpHandleFacadeFactory.getLocalInstance(ctx).download(attachment);
        return temp;
    }
}

