/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.nscanner;

import com.kingdee.eas.base.attachment.client.scan.ScanHelper;
import com.kingdee.eas.base.attachment.nscanner.IListener;
import com.kingdee.eas.base.attachment.nscanner.IScannerListener;
import com.kingdee.eas.base.attachment.nscanner.ScannerEvent;
import com.kingdee.eas.base.attachment.nscanner.ScannerType;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;
import uk.co.mmscomputing.device.scanner.Scanner;
import uk.co.mmscomputing.device.scanner.ScannerIOMetadata;
import uk.co.mmscomputing.device.scanner.ScannerListener;

public class KDScannerListener
implements IScannerListener,
ScannerListener {
    private List<IListener> observers = new ArrayList<IListener>();
    private Scanner scanner;
    Logger logger = Logger.getLogger((String)this.getClass().getName());

    public KDScannerListener() {
        this.init();
    }

    public void update(ScannerIOMetadata.Type paramType, ScannerIOMetadata paramScannerIOMetadata) {
        ScannerEvent event = new ScannerEvent((Object)this, paramScannerIOMetadata);
        if (paramType.equals(ScannerIOMetadata.ACQUIRED)) {
            this.logger.error((Object)"Scanner Acquired type.");
            event.setType(ScannerType.ACQUIRED);
            BufferedImage bufferedImage = paramScannerIOMetadata.getImage();
            File file = new File(ScanHelper.genFileName());
            try {
                ImageIO.write((RenderedImage)bufferedImage, "jpg", file);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error((Object)"Scanner Acquired Error.", (Throwable)e);
            }
            event.setData(file);
        } else if (paramType.equals(ScannerIOMetadata.FILE)) {
            this.logger.error((Object)"Scanner File type.");
            event.setType(ScannerType.FILE);
            File file = paramScannerIOMetadata.getFile();
            event.setData(file);
        } else if (paramType.equals(ScannerIOMetadata.NEGOTIATE)) {
            this.logger.error((Object)"Scanner Negotiate type.");
            event.setType(ScannerType.NEGOTIATE);
        } else if (paramType.equals(ScannerIOMetadata.STATECHANGE)) {
            paramScannerIOMetadata.getState();
            this.logger.error((Object)("Scanner state changed: " + paramScannerIOMetadata.getStateStr()));
            event.setType(ScannerType.STATECHANGE);
        } else if (paramType.equals(ScannerIOMetadata.INFO)) {
            this.logger.error((Object)("Scanner info type. info:" + paramScannerIOMetadata.getInfo()));
            event.setType(ScannerType.INFO);
        } else if (paramType.equals(ScannerIOMetadata.EXCEPTION)) {
            this.logger.error((Object)("Scanner exception type. info:" + paramScannerIOMetadata.getException()));
            event.setType(ScannerType.EXCEPTION);
        }
        for (IListener observer : this.observers) {
            observer.captured(event);
        }
    }

    @Override
    public void addListenter(IListener listener) {
        if (null == listener) {
            throw new IllegalArgumentException("\u53c2\u6570listener\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (!this.observers.contains(listener)) {
            this.observers.add(listener);
        }
    }

    @Override
    public void removeListenter(IListener listener) {
        if (null == listener) {
            throw new IllegalArgumentException("\u53c2\u6570listener\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (this.observers.contains(listener)) {
            this.observers.remove(listener);
        }
    }

    private void init() {
        this.scanner = Scanner.getDevice();
        if (null == this.scanner) {
            throw new RuntimeException("\u83b7\u53d6\u9a71\u52a8\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5b89\u88c5\u5408\u9002\u9a71\u52a8\uff01");
        }
    }

    @Override
    public void destory() {
        if (null != this.observers) {
            this.observers.clear();
        }
        if (null != this.scanner) {
            this.scanner.removeListener((ScannerListener)this);
        } else {
            this.logger.error((Object)"\u626b\u63cf\u4eea\u4e3aNULL");
        }
    }

    @Override
    public void stop() {
        if (null != this.scanner) {
            try {
                this.scanner.waitToExit();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error((Object)"\u505c\u6b62\u51fa\u9519\uff1a", (Throwable)e);
            }
        }
    }

    public Scanner getScanner() {
        return this.scanner;
    }
}

