/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.obs;

import com.kingdee.eas.base.attachment.obs.OBSHandler;
import com.obs.services.ObsClient;
import com.obs.services.exception.ObsException;
import com.obs.services.model.CompleteMultipartUploadRequest;
import com.obs.services.model.CompleteMultipartUploadResult;
import com.obs.services.model.DeleteObjectResult;
import com.obs.services.model.DeleteObjectsRequest;
import com.obs.services.model.InitiateMultipartUploadRequest;
import com.obs.services.model.InitiateMultipartUploadResult;
import com.obs.services.model.ListVersionsRequest;
import com.obs.services.model.ListVersionsResult;
import com.obs.services.model.ObjectListing;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.ObsObject;
import com.obs.services.model.PartEtag;
import com.obs.services.model.PutObjectResult;
import com.obs.services.model.UploadPartRequest;
import com.obs.services.model.UploadPartResult;
import com.obs.services.model.VersionOrDeleteMarker;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class BucketObjectOperation {
    private String endPoint;
    private String ak;
    private String sk;
    private String bucketName;
    private static Logger logger = Logger.getLogger((String)BucketObjectOperation.class.getName());

    public BucketObjectOperation(String endPoint, String ak, String sk, String bucketName) {
        this.endPoint = endPoint;
        this.ak = ak;
        this.sk = sk;
        this.bucketName = bucketName;
    }

    public ObsClient getObsClient() {
        OBSHandler obsHandler = new OBSHandler(this.ak, this.sk, this.endPoint);
        return obsHandler.getObsClient();
    }

    public Integer uploadFileByIO(InputStream is, String objectKey) throws IOException {
        ObsClient obsClient = this.getObsClient();
        String handleObjectName = objectKey;
        if (this.bucketName.contains("/")) {
            handleObjectName = this.handleBucketName(handleObjectName);
        }
        Boolean flag = obsClient.doesObjectExist(this.bucketName, handleObjectName);
        PutObjectResult result = null;
        if (flag.booleanValue()) {
            return 0;
        }
        result = obsClient.putObject(this.bucketName, handleObjectName, is);
        obsClient.close();
        return result.getStatusCode();
    }

    public int uploadFileByByte(byte[] file, String objectKey) throws Exception {
        try (ObsClient obsClient = null;){
            String handleObjectName = objectKey;
            if (this.bucketName.contains("/")) {
                handleObjectName = this.handleBucketName(handleObjectName);
            }
            obsClient = this.getObsClient();
            Boolean flag = obsClient.doesObjectExist(this.bucketName, handleObjectName);
            PutObjectResult result = null;
            if (flag.booleanValue()) {
                int n = 0;
                return n;
            }
            result = obsClient.putObject(this.bucketName, handleObjectName, (InputStream)new ByteArrayInputStream(file));
            int n = result.getStatusCode();
            return n;
        }
    }

    public int uploadFileByFile(File file, String objectKey) throws Exception {
        try (ObsClient obsClient = null;){
            String handleObjectName = objectKey;
            if (this.bucketName.contains("/")) {
                handleObjectName = this.handleBucketName(handleObjectName);
            }
            obsClient = this.getObsClient();
            Boolean flag = obsClient.doesObjectExist(this.bucketName, handleObjectName);
            PutObjectResult result = null;
            if (flag.booleanValue()) {
                int n = 0;
                return n;
            }
            result = obsClient.putObject(this.bucketName, handleObjectName, file);
            int n = result.getStatusCode();
            return n;
        }
    }

    public Integer createFolder(String folderName) throws IOException {
        ObsClient obsClient = this.getObsClient();
        int length = folderName.length();
        if (length != 0 && !folderName.contains("/") && !folderName.substring(length - 1).equals("/")) {
            return 0;
        }
        Boolean flag = obsClient.doesObjectExist(this.bucketName, folderName);
        PutObjectResult result = null;
        if (flag.booleanValue()) {
            return 0;
        }
        result = obsClient.putObject(this.bucketName, folderName, (InputStream)new ByteArrayInputStream(new byte[0]));
        obsClient.close();
        return result.getStatusCode();
    }

    public void uploadFileByFolderName(String folderName) throws IOException {
    }

    public List<ObsObject> getAllFileInfo() throws IOException {
        ObsClient obsClient = this.getObsClient();
        ObjectListing objectList = obsClient.listObjects(this.bucketName);
        List list = objectList.getObjects();
        obsClient.close();
        return list;
    }

    public Boolean removeFile(String objectKey) throws IOException {
        ObsClient obsClient = this.getObsClient();
        boolean exist = obsClient.doesObjectExist(this.bucketName, objectKey);
        boolean flag = false;
        DeleteObjectResult result = null;
        if (exist) {
            result = obsClient.deleteObject(this.bucketName, objectKey);
        }
        obsClient.close();
        if (result != null) {
            flag = result.isDeleteMarker();
        }
        return flag;
    }

    public ObsObject getFile(String objectKey) {
        ObsClient obsClient = this.getObsClient();
        boolean exist = obsClient.doesObjectExist(this.bucketName, objectKey);
        if (exist) {
            ObsObject object = obsClient.getObject(this.bucketName, objectKey);
            return object;
        }
        return null;
    }

    public byte[] getFileInputStream(String objectKey) throws Exception {
        ObsClient obsClient = null;
        ByteArrayOutputStream bos = null;
        InputStream input = null;
        try {
            boolean exist;
            obsClient = this.getObsClient();
            String handleObjectName = objectKey;
            if (this.bucketName.contains("/")) {
                handleObjectName = this.handleBucketName(handleObjectName);
            }
            if (exist = obsClient.doesObjectExist(this.bucketName, handleObjectName)) {
                int len;
                ObsObject obsObject = obsClient.getObject(this.bucketName, handleObjectName);
                input = obsObject.getObjectContent();
                byte[] b = new byte[5120];
                bos = new ByteArrayOutputStream();
                while ((len = input.read(b)) != -1) {
                    bos.write(b, 0, len);
                }
                byte[] byArray = bos.toByteArray();
                return byArray;
            }
            try {
                throw new Exception("\u6587\u4ef6\u4e0d\u5b58\u5728,\u6587\u4ef6\u8def\u5f84\uff1a" + this.bucketName);
            }
            catch (ObsException e1) {
                logger.error((Object)("obsClient-downloadFile-errorCode:" + e1.getErrorCode() + "  obsClient-downloadFile-errorMessage:" + e1.getErrorMessage()));
                throw e1;
            }
            catch (Exception e) {
                logger.error((Object)"obsClient-downloadFile-error:", (Throwable)e);
                throw e;
            }
        }
        finally {
            if (bos != null) {
                bos.close();
            }
            if (input != null) {
                input.close();
            }
            if (obsClient != null) {
                obsClient.close();
            }
        }
    }

    public String initiateMultipartUpload(File file, String objectKey) throws IOException {
        ObsClient obsClient = this.getObsClient();
        Boolean flag = obsClient.doesObjectExist(this.bucketName, objectKey);
        String uploadId = null;
        if (flag.booleanValue()) {
            return null;
        }
        InitiateMultipartUploadRequest request = new InitiateMultipartUploadRequest(this.bucketName, objectKey);
        ObjectMetadata metadata = new ObjectMetadata();
        request.setMetadata(metadata);
        InitiateMultipartUploadResult result = obsClient.initiateMultipartUpload(request);
        uploadId = result.getUploadId();
        obsClient.close();
        return uploadId;
    }

    public Integer uploadByPart(File file, String objectKey, String uploadId) throws IOException {
        ObsClient obsClient = this.getObsClient();
        Boolean flag = obsClient.doesObjectExist(this.bucketName, objectKey);
        int statusCode = 0;
        UploadPartResult result = null;
        long fileLength = file.length();
        long defaultPartLength = 0x140000000L;
        long allPartNumber = 0L;
        if (fileLength == 0L || fileLength / defaultPartLength == 0L || fileLength % defaultPartLength == fileLength) {
            return 0;
        }
        allPartNumber = fileLength % defaultPartLength == 0L ? fileLength / defaultPartLength : fileLength / defaultPartLength + 1L;
        if (flag.booleanValue()) {
            return 0;
        }
        ArrayList<PartEtag> partEtags = new ArrayList<PartEtag>();
        int i = 1;
        while ((long)i < allPartNumber + 1L) {
            UploadPartRequest request = new UploadPartRequest(this.bucketName, objectKey);
            request.setUploadId(uploadId);
            request.setPartNumber(i);
            request.setFile(file);
            if (i >= 2) {
                request.setOffset((long)((i - 1) * 5 * 1024 * 1024) * 1024L);
            }
            request.setPartSize(Long.valueOf(0x140000000L));
            result = obsClient.uploadPart(request);
            partEtags.add(new PartEtag(result.getEtag(), Integer.valueOf(result.getPartNumber())));
            ++i;
        }
        CompleteMultipartUploadRequest request = new CompleteMultipartUploadRequest(this.bucketName, objectKey, uploadId, partEtags);
        CompleteMultipartUploadResult completeMultipartUpload = obsClient.completeMultipartUpload(request);
        statusCode = completeMultipartUpload.getStatusCode();
        obsClient.close();
        return statusCode;
    }

    public Integer concurrentUploadByPart(final File file, final String objectKey, final String uploadId) throws IOException {
        final ObsClient obsClient = this.getObsClient();
        Boolean flag = obsClient.doesObjectExist(this.bucketName, objectKey);
        ExecutorService executorService = Executors.newFixedThreadPool(20);
        int statusCode = 0;
        long fileLength = file.length();
        long defaultPartLength = 0x140000000L;
        long allPartNumber = 0L;
        if (fileLength == 0L || fileLength / defaultPartLength == 0L || fileLength % defaultPartLength == fileLength) {
            return 0;
        }
        allPartNumber = fileLength % defaultPartLength == 0L ? fileLength / defaultPartLength : fileLength / defaultPartLength + 1L;
        if (flag.booleanValue()) {
            return 0;
        }
        final List partEtags = Collections.synchronizedList(new ArrayList());
        int i = 1;
        while ((long)i < allPartNumber + 1L) {
            final long offset = (long)(i - 1) * defaultPartLength;
            final long currPartSize = (long)i == allPartNumber ? fileLength - offset : defaultPartLength;
            final int partNumber = i++;
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    UploadPartRequest uploadPartRequest = new UploadPartRequest();
                    uploadPartRequest.setBucketName(BucketObjectOperation.this.bucketName);
                    uploadPartRequest.setObjectKey(objectKey);
                    uploadPartRequest.setUploadId(uploadId);
                    uploadPartRequest.setFile(file);
                    uploadPartRequest.setPartSize(Long.valueOf(currPartSize));
                    uploadPartRequest.setOffset(offset);
                    uploadPartRequest.setPartNumber(partNumber);
                    try {
                        UploadPartResult uploadPartResult = obsClient.uploadPart(uploadPartRequest);
                        System.out.println("Part#" + partNumber + " done\n");
                        partEtags.add(new PartEtag(uploadPartResult.getEtag(), Integer.valueOf(uploadPartResult.getPartNumber())));
                    }
                    catch (ObsException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        executorService.shutdown();
        while (!executorService.isTerminated()) {
            try {
                executorService.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(this.bucketName, objectKey, uploadId, partEtags);
        CompleteMultipartUploadResult completeMultipartUpload = obsClient.completeMultipartUpload(completeMultipartUploadRequest);
        statusCode = completeMultipartUpload.getStatusCode();
        obsClient.close();
        return statusCode;
    }

    public ObjectListing listObjects(String objectKey) {
        ObsClient obsClient = this.getObsClient();
        boolean exist = obsClient.doesObjectExist(this.bucketName, objectKey);
        if (exist) {
            ObjectListing result = obsClient.listObjects(this.bucketName);
            return result;
        }
        return null;
    }

    public int deleteObject(String objectKey) throws Exception {
        try (ObsClient obsClient = null;){
            boolean exist;
            obsClient = this.getObsClient();
            String handleObjectName = objectKey;
            if (this.bucketName.contains("/")) {
                handleObjectName = this.handleBucketName(handleObjectName);
            }
            if (exist = obsClient.doesObjectExist(this.bucketName, handleObjectName)) {
                DeleteObjectResult result = obsClient.deleteObject(this.bucketName, handleObjectName);
                int n = result.getStatusCode();
                return n;
            }
        }
        return 0;
    }

    public void deleteObjects(String objectKey) {
        boolean exist;
        ObsClient obsClient = this.getObsClient();
        String handleObjectName = objectKey;
        if (this.bucketName.contains("/")) {
            handleObjectName = this.handleBucketName(handleObjectName);
        }
        if (exist = obsClient.doesObjectExist(this.bucketName, handleObjectName)) {
            ListVersionsResult result;
            ListVersionsRequest request = new ListVersionsRequest(this.bucketName);
            request.setMaxKeys(100);
            do {
                result = obsClient.listVersions(request);
                DeleteObjectsRequest deleteRequest = new DeleteObjectsRequest(this.bucketName);
                for (VersionOrDeleteMarker v : result.getVersions()) {
                    deleteRequest.addKeyAndVersion(v.getKey(), v.getVersionId());
                }
                request.setKeyMarker(result.getNextKeyMarker());
                request.setVersionIdMarker(result.getNextVersionIdMarker());
            } while (result.isTruncated());
        }
    }

    public String handleBucketName(String objectKey) {
        String bucketName = this.bucketName;
        String[] strings = bucketName.split("/", 2);
        this.bucketName = strings[0];
        String objectNameFolder = strings[1];
        return objectNameFolder + "/" + objectKey;
    }
}

