/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.billdigest;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.billdigest.util.format.BillDigestCache;
import com.kingdee.bos.billdigest.util.format.Format;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class BillDigestUtil {
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.billdigest.BillDigestUtil");

    public static boolean isExistDigest(Context ctx, BOSObjectType bosType, String purpose) {
        Format format = BillDigestCache.get(ctx.getAIS(), ctx.getLocale(), purpose, bosType);
        return format != null;
    }

    public static String getDigest(Context ctx, String billId, String purpose) throws Exception {
        boolean cacheable = true;
        if (!cacheable) {
            BillDigestCache.clear();
        }
        long startTime = 0L;
        if (log.isDebugEnabled()) {
            startTime = System.nanoTime();
        }
        BOSUuid id = BOSUuid.read((String)billId);
        Format format = BillDigestCache.get(ctx.getAIS(), ctx.getLocale(), purpose, id.getType());
        if (log.isDebugEnabled()) {
            log.debug((Object)("BillDigestUtil::get digest[" + ctx.getAIS() + "/" + purpose + "/" + id.getType() + "]  cost:" + (System.nanoTime() - startTime) + "ns"));
        }
        if (format == null) {
            return null;
        }
        IObjectValue bo = BillDigestUtil.loadBillObject(ctx, id, format);
        if (log.isDebugEnabled()) {
            log.debug((Object)("BillDigestUtil::load bill object[" + ctx.getAIS() + "/" + id + "]  cost:" + (System.nanoTime() - startTime) + "ns"));
            startTime = System.nanoTime();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ctx", ctx);
        map.put("bo", bo);
        String rtn = format.translate(map);
        if (log.isDebugEnabled()) {
            log.debug((Object)("BillDigestUtil::translate digest cost:" + (System.nanoTime() - startTime) + "ns"));
            startTime = System.nanoTime();
        }
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IObjectValue loadBillObject(Context ctx, BOSUuid id, Format format) throws BOSException, SQLException {
        IObjectValue iObjectValue;
        Object bak = ctx.get((Object)"disablePermissionForKScript");
        IORMappingDAO dao = null;
        IObjectValue model = null;
        Connection cn = null;
        try {
            ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
            ObjectUuidPK pk = new ObjectUuidPK(id);
            SelectorItemCollection sc = new SelectorItemCollection();
            Iterator<String> it = format.getReferences().iterator();
            while (it.hasNext()) {
                sc.add(it.next());
            }
            cn = EJBFactory.getConnection((Context)ctx);
            dao = ORMappingDAO.getInstance((BOSObjectType)pk.getObjectType(), (Context)ctx, (Connection)cn);
            iObjectValue = model = dao.getValue((IObjectPK)pk, sc, true);
        }
        catch (Throwable throwable) {
            ctx.put((Object)"disablePermissionForKScript", bak);
            SQLUtils.cleanup(cn);
            throw throwable;
        }
        ctx.put((Object)"disablePermissionForKScript", bak);
        SQLUtils.cleanup((Connection)cn);
        return iObjectValue;
    }
}

