/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.billdigest.util.format;

import com.kingdee.bos.billdigest.util.format.Expr;
import com.kingdee.bos.billdigest.util.format.Format;
import com.kingdee.bos.billdigest.util.format.Pair;
import com.kingdee.bos.billdigest.util.format.Property;
import com.kingdee.bos.billdigest.util.format.Util;
import com.kingdee.bos.dao.IObjectCollection;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ForEach
implements Property {
    private Expr expr;
    private Pair<String, String> rename;
    private Format content;
    private String s;

    ForEach(String s) {
        int j = this.parseVarName(s);
        this.parseContent(s, j);
        this.s = s;
    }

    private void parseContent(String content, int j) {
        while (Util.isSpace(content.charAt(j))) {
            ++j;
        }
        this.content = new Format(content.substring(j));
    }

    private int parseVarName(String content) {
        String rename;
        int i = 0;
        while (Util.isSpace(content.charAt(i))) {
            ++i;
        }
        int j = i + 1;
        while (!Util.isSpace(content.charAt(j))) {
            ++j;
        }
        String s = content.substring(i, j);
        if ((i = s.indexOf("->")) > 0) {
            this.expr = new Expr(s.substring(0, i));
            rename = s.substring(i + "->".length());
        } else {
            this.expr = new Expr(s);
            rename = s;
        }
        if (rename.indexOf(",") > 0) {
            String[] tmp = rename.split(",", 2);
            this.rename = new Pair<String, String>(tmp[0], tmp[1]);
        } else {
            this.rename = new Pair<Object, String>(null, rename);
        }
        return j;
    }

    @Override
    public Object getFrom(Map<String, Object> ctx) {
        Object value = this.expr.getFrom(ctx);
        if (value == null) {
            return "";
        }
        List<Object> list = this.translate(ctx, value);
        if (list.size() == 1) {
            return list.get(0);
        }
        return this.concatList(list);
    }

    private Object concatList(List<Object> list) {
        StringBuilder s = new StringBuilder();
        for (Object o : list) {
            s.append(o);
        }
        return s.toString();
    }

    private List<Object> translate(Map<String, Object> ctx, Object value) {
        List<Object> list;
        if (value instanceof Object[]) {
            list = this.translateOnObjectArray(ctx, value);
        } else if (value instanceof Collection) {
            list = this.translateOnCollection(ctx, value);
        } else if (value.getClass().isArray()) {
            list = this.translateOnPrimitiveArray(ctx, value);
        } else if (value instanceof Map) {
            list = this.translateOnMap(ctx, value);
        } else if (value instanceof IObjectCollection) {
            Object[] array = ((IObjectCollection)value).toArray();
            list = this.translateOnObjectArray(ctx, array);
        } else {
            list = this.translateOnSingleValue(ctx, value);
        }
        return list;
    }

    private List<Object> translateOnSingleValue(Map<String, Object> ctx, Object value) {
        ArrayList<Object> list = new ArrayList<Object>(1);
        this.translateOnElement(ctx, list, 1, value);
        return list;
    }

    private List<Object> translateOnObjectArray(Map<String, Object> ctx, Object value) {
        Object[] array = (Object[])value;
        ArrayList<Object> list = new ArrayList<Object>(array.length);
        for (Object v : array) {
            this.translateOnElement(ctx, list, array.length, v);
        }
        return list;
    }

    private List<Object> translateOnCollection(Map<String, Object> ctx, Object value) {
        Collection collection = (Collection)value;
        ArrayList<Object> list = new ArrayList<Object>(collection.size());
        for (Object v : collection) {
            this.translateOnElement(ctx, list, collection.size(), v);
        }
        return list;
    }

    private List<Object> translateOnPrimitiveArray(Map<String, Object> ctx, Object value) {
        ArrayList<Object> list = new ArrayList<Object>(Array.getLength(value));
        int count = Array.getLength(value);
        for (int i = 0; i < count; ++i) {
            Object v = Array.get(value, i);
            this.translateOnElement(ctx, list, count, v);
        }
        return list;
    }

    private List<Object> translateOnMap(Map<String, Object> ctx, Object value) {
        Map map = (Map)value;
        int count = map.size();
        ArrayList<Object> list = new ArrayList<Object>(count);
        for (Map.Entry entry : map.entrySet()) {
            this.translateOnElement(ctx, list, count, entry);
        }
        return list;
    }

    private void translateOnElement(Map<String, Object> ctx, List<Object> list, int count, Map.Entry<?, ?> entry) {
        int index = list.size() + 1;
        Map<String, Object> ctx0 = this.newMap(this.rename, index, count, new Pair<Object, Object>(entry.getKey(), entry.getValue()), ctx);
        list.add(this.content.translateValue(ctx0));
    }

    private void translateOnElement(Map<String, Object> ctx, List<Object> list, int count, Object v) {
        int index = list.size() + 1;
        Map<String, Object> ctx0 = this.newMap(this.rename, index, count, new Pair<Object, Object>(null, v), ctx);
        list.add(this.content.translateValue(ctx0));
    }

    @Override
    public String getName() {
        return this.expr.getName();
    }

    public String toString() {
        return "#{for-each:" + this.s + "}";
    }

    private Map<String, Object> newMap(Pair<String, String> var, int index, int count, Pair<Object, Object> value, Map<String, Object> inner) {
        HashMap<String, Object> n = new HashMap<String, Object>(inner.size() * 2);
        n.putAll(inner);
        n.put("index", index);
        n.put("count", count);
        if (var.getA() != null) {
            n.put(var.getA(), value.getA());
        }
        if (var.getB() != null) {
            n.put(var.getB(), value.getB());
        }
        return n;
    }

    @Override
    public void addReference(String prefix, Collection<String> refs) {
        this.expr.addReference(prefix, refs);
        String ref = this.expr.getRef();
        if (ref != null) {
            prefix = prefix == null ? ref : prefix + "." + ref;
        }
        this.content.addReferences(prefix, refs);
    }
}

