/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.botp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.eas.base.botp.BotLogInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

public class BotLogUtil {
    public static void addBotLog(Context ctx, BOTMappingInfo botMapping, IObjectCollection srcBIllCols, int state, Exception e) throws BOSException {
        BotLogInfo logInfo = new BotLogInfo();
        logInfo.setBotMapping(botMapping);
        logInfo.setSrcBillCols(srcBIllCols);
        logInfo.setState(state);
        logInfo.setError(e);
        String sqlToDeleteLog = "DELETE FROM T_BOT_BOTLOG WHERE FBOTMAPPINGID = ?";
        DbUtil.execute((Context)ctx, (String)sqlToDeleteLog, (Object[])new Object[]{botMapping.getId().toString()});
        String sqlToInsertLog = "INSERT INTO T_BOT_BOTLOG(FBOTMAPPINGID,FSRCBILLCOLS,FErrorDetails,FSTATE) VALUES(?,?,?,?)";
        try {
            DbUtil.execute((Context)ctx, (String)sqlToInsertLog, (Object[])new Object[]{logInfo.getBotMappingInLog(), logInfo.getSrcBillColsDisplayInfo(), logInfo.getErrorDetails(), new Integer(logInfo.getState())});
        }
        catch (IOException e1) {
            throw new BOSException((Throwable)e1);
        }
    }

    public static String getBotLog(Context ctx, String botMappingId) throws BOSException, SQLException {
        StringBuffer botLogBuffer = new StringBuffer();
        String sqlToGetBotLog = "SELECT TOP 1 FBOTMAPPINGID,FSRCBILLCOLS,FERRORDETAILS,FSTATE FROM T_BOT_BOTLOG WHERE FBOTMAPPINGID = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlToGetBotLog, (Object[])new Object[]{botMappingId});
        if (rs != null && rs.next()) {
            String srcBillColsDisplayInfo = rs.getString("FSRCBILLCOLS");
            String errorDetail = rs.getString("FERRORDETAILS");
            int state = rs.getInt("FSTATE");
            if (srcBillColsDisplayInfo != null) {
                botLogBuffer.append(srcBillColsDisplayInfo);
                botLogBuffer.append("\r\n");
            }
            if (state == 1) {
                String successInfo = EASResource.getString((String)"com.kingdee.eas.base.botp.BotpResx", (String)"BOTPTRANSFORMSUCCESS");
                botLogBuffer.append(successInfo);
                botLogBuffer.append("\r\n");
            } else {
                String lostInfo = EASResource.getString((String)"com.kingdee.eas.base.botp.BotpResx", (String)"BOTPTRANSFORMLOST");
                botLogBuffer.append(lostInfo);
                botLogBuffer.append("\r\n");
                if (errorDetail != null && errorDetail.length() > 0) {
                    botLogBuffer.append(errorDetail);
                }
            }
        }
        return botLogBuffer.toString();
    }

    public static void addBotLog(Context ctx, BOTMappingCollection botMappingCols, List srcBillColsList, int state, Exception e) throws BOSException {
        if (botMappingCols.size() == srcBillColsList.size()) {
            int count = botMappingCols.size();
            for (int i = 0; i < count; ++i) {
                BOTMappingInfo botMappingInfo = botMappingCols.get(i);
                CoreBillBaseCollection srcBillCols = (CoreBillBaseCollection)srcBillColsList.get(i);
                BotLogUtil.addBotLog(ctx, botMappingInfo, (IObjectCollection)srcBillCols, state, e);
            }
        }
    }
}

