/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.commonquery.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.util.StringUtil;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterCollection;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.base.commonquery.CommonFilterUtil;
import com.kingdee.eas.base.commonquery.QueryUtils;
import com.kingdee.eas.base.commonquery.RowObject;
import com.kingdee.eas.base.commonquery.VarEnum;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class CommonQueryUtil {
    private static final Logger logger = Logger.getLogger(CommonQueryUtil.class);
    protected static final String SPLIT_DATE_FUNCTION_SIGN = "$";

    public static String getInnerFilterInfo(Context ctx, String filterStr) {
        if (StringUtils.isEmpty((String)filterStr)) {
            return "";
        }
        FilterInfo filterInfo = new FilterInfo();
        EntityViewInfo evInfo = new EntityViewInfo();
        EntityViewInfo entityEvInfo = new EntityViewInfo();
        String result = "";
        try {
            evInfo = new EntityViewInfo(filterStr);
            entityEvInfo = new EntityViewInfo(filterStr);
            entityEvInfo.getEntryFilters().clear();
            FilterCollection filterCollection = evInfo.getEntryFilters();
            int filterLength = filterCollection.toArray().length;
            if (filterLength <= 0) {
                filterInfo = evInfo.getFilter();
                result = CommonQueryUtil.getRuleFilterInfo(ctx, filterInfo, evInfo, false);
            } else {
                for (int len = 0; len < filterLength; ++len) {
                    filterInfo = filterCollection.get(len);
                    result = CommonQueryUtil.getRuleFilterInfo(ctx, filterInfo, entityEvInfo, true);
                }
            }
        }
        catch (ParserException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private static String getRuleFilterInfo(Context ctx, FilterInfo filterInfo, EntityViewInfo evInfo, boolean isEntry) {
        FilterInfo newFilterInfo = new FilterInfo();
        StringBuffer sbFormula = new StringBuffer();
        try {
            int filterSize = filterInfo.getFilterItems().size();
            ArrayList rowInfos = CommonQueryUtil.getRowInfos(filterInfo);
            for (int i = 0; i < filterSize; ++i) {
                FilterItemInfo filterItemInfo = filterInfo.getFilterItems().get(i);
                RowObject rowsInfo = (RowObject)rowInfos.get(i);
                String leftBracket = rowsInfo.getLeftBracket();
                String rightBracket = rowsInfo.getRightBracket();
                String logic = rowsInfo.getLogic();
                rowsInfo.setLeftBracket(rowsInfo.getLeftBracket());
                rowsInfo.setCondition(filterItemInfo.getPropertyName());
                if (filterItemInfo.getCompareValue() != null && CommonQueryUtil.isVarValue(filterItemInfo.getCompareValue().toString())) {
                    String compare = filterItemInfo.getCompareValue().toString();
                    if ((compare.equalsIgnoreCase("$currentPerson$") || compare.equalsIgnoreCase(VarEnum.CURRENTPERSON.getAlias())) && CommonQueryUtil.getCurrentUserType(ctx) != UserType.PERSON.getValue()) {
                        return " WHERE ( id = '00000000-0000-0000-0000-00000000000013B7DE7F' AND id <> '00000000-0000-0000-0000-00000000000013B7DE7F' )";
                    }
                    String condition = filterItemInfo.getPropertyName();
                    String value = filterItemInfo.getCompareValue().toString();
                    FilterItemInfo itemInfo = null;
                    itemInfo = isEntry ? CommonQueryUtil.getVarFilterForQueryForIsEntry(ctx, filterItemInfo.getCompareType().toString(), condition, value) : CommonQueryUtil.getVarFilterForQuery(ctx, filterItemInfo.getCompareType().toString(), condition, value);
                    newFilterInfo.getFilterItems().add(itemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (CommonQueryUtil.isUseDateFunction(filterItemInfo)) {
                    Date dateFrom;
                    Date dateTo;
                    Date dateTo2;
                    Date dateFrom2;
                    Calendar cal;
                    String compValue;
                    String sDateType = DataType.TIMESTAMP.getName();
                    String sCompareCondition = filterItemInfo.getPropertyName();
                    String compareValue = filterItemInfo.getCompareValue().toString();
                    if (!StringUtil.isEmpty((String)compareValue) && compareValue.toUpperCase(Locale.ENGLISH).startsWith("IN_X_DAYS_AFTER")) {
                        compValue = compareValue.split("\\$")[1];
                        cal = Calendar.getInstance();
                        cal.add(5, Integer.parseInt(compValue));
                        Date startDate = CommonQueryUtil.getDateIgnoreTime(cal.getTime());
                        FilterItemInfo innerFilterItemInfo = new FilterItemInfo(sCompareCondition, (Object)startDate, CompareType.getEnum((String)">"));
                        newFilterInfo.getFilterItems().add(innerFilterItemInfo);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (!StringUtil.isEmpty((String)compareValue) && compareValue.toUpperCase(Locale.ENGLISH).startsWith("IN_X_DAYS_EQUAL")) {
                        compValue = compareValue.split("\\$")[1];
                        cal = Calendar.getInstance();
                        cal.add(5, Integer.parseInt(compValue));
                        dateFrom2 = cal.getTime();
                        cal.add(5, 1);
                        dateTo2 = cal.getTime();
                        dateFrom2 = CommonQueryUtil.getDateIgnoreTime(dateFrom2);
                        dateTo2 = CommonQueryUtil.getDateIgnoreTime(dateTo2);
                        QueryUtils.getDayBetweenFilterInfo(newFilterInfo, sCompareCondition, dateFrom2, dateTo2, sDateType);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (!StringUtil.isEmpty((String)compareValue) && compareValue.toUpperCase(Locale.ENGLISH).startsWith("IN_X_DAYS_BEFORE")) {
                        compValue = compareValue.split("\\$")[1];
                        cal = Calendar.getInstance();
                        cal.add(5, 1);
                        dateFrom2 = cal.getTime();
                        cal.add(5, Integer.parseInt(compValue) - 1);
                        dateTo2 = cal.getTime();
                        dateFrom2 = CommonQueryUtil.getDateIgnoreTime(dateFrom2);
                        dateTo2 = CommonQueryUtil.getDateIgnoreTime(dateTo2);
                        QueryUtils.getDayBetweenFilterInfo(newFilterInfo, sCompareCondition, dateFrom2, dateTo2, sDateType);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (!StringUtil.isEmpty((String)compareValue) && compareValue.toUpperCase(Locale.ENGLISH).startsWith("X_DAYS_AGO_AFTER")) {
                        compValue = compareValue.split("\\$")[1];
                        cal = Calendar.getInstance();
                        cal.add(5, -Integer.parseInt(compValue));
                        QueryUtils.getCompareDayFilterInfo(newFilterInfo, sCompareCondition, sDateType, cal.getTime(), CompareType.getEnum((String)"<"));
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (!StringUtil.isEmpty((String)compareValue) && compareValue.toUpperCase(Locale.ENGLISH).startsWith("X_DAYS_AGO_EQUAL")) {
                        compValue = compareValue.split("\\$")[1];
                        cal = Calendar.getInstance();
                        cal.add(5, -Integer.parseInt(compValue) + 1);
                        dateTo = cal.getTime();
                        cal.add(5, -1);
                        dateFrom = cal.getTime();
                        QueryUtils.getDayBetweenFilterInfo(newFilterInfo, sCompareCondition, dateFrom, dateTo, sDateType);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (StringUtil.isEmpty((String)compareValue) || !compareValue.toUpperCase(Locale.ENGLISH).startsWith("X_DAYS_AGO_BEFORE")) continue;
                    compValue = compareValue.split("\\$")[1];
                    cal = Calendar.getInstance();
                    dateTo = cal.getTime();
                    cal.add(5, -Integer.parseInt(compValue) + 1);
                    dateFrom = cal.getTime();
                    QueryUtils.getDayBetweenFilterInfo(newFilterInfo, sCompareCondition, dateFrom, dateTo, sDateType);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                newFilterInfo.getFilterItems().add(filterItemInfo);
                sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
            }
            String strFormula = sbFormula.toString();
            if (strFormula != null && !strFormula.trim().equalsIgnoreCase("")) {
                newFilterInfo.setMaskString(sbFormula.toString().substring(0, strFormula.length() - 1));
            }
            newFilterInfo.setEntryName(filterInfo.getEntryName());
            newFilterInfo.setEntryilterType(filterInfo.getEntryFilterType());
            if (isEntry) {
                evInfo.getEntryFilters().add(newFilterInfo);
            } else {
                evInfo.setFilter(newFilterInfo);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return evInfo.toString();
    }

    public static FilterItemInfo getVarFilterForQuery(Context ctx, String compare, String condition, Object compareValue) {
        FilterItemInfo filterItemInfo = new FilterItemInfo();
        String conditionid = CommonQueryUtil.getConditionId(condition);
        Object currentValue = CommonQueryUtil.getVarCurrentValue(ctx, compareValue);
        if (compare.equalsIgnoreCase("VAREQUAL".toString()) || compare.equalsIgnoreCase("=")) {
            filterItemInfo = new FilterItemInfo(conditionid, currentValue, CompareType.getEnum((String)"="));
        } else if (compare.equalsIgnoreCase("VARNOTEQUAL".toString()) || compare.equalsIgnoreCase("<>")) {
            filterItemInfo = new FilterItemInfo(conditionid, currentValue, CompareType.getEnum((String)"<>"));
        }
        return filterItemInfo;
    }

    public static FilterItemInfo getVarFilterForQueryForIsEntry(Context ctx, String compare, String condition, Object compareValue) {
        FilterItemInfo filterItemInfo = new FilterItemInfo();
        String conditionNumber = CommonQueryUtil.getConditionNumber(condition);
        Object currentValue = CommonQueryUtil.getVarCurrentValueOfNumber(ctx, compareValue);
        if (compare.equalsIgnoreCase("VAREQUAL".toString()) || compare.equalsIgnoreCase("=")) {
            filterItemInfo = new FilterItemInfo(conditionNumber, currentValue, CompareType.getEnum((String)"="));
        } else if (compare.equalsIgnoreCase("VARNOTEQUAL".toString()) || compare.equalsIgnoreCase("<>")) {
            filterItemInfo = new FilterItemInfo(conditionNumber, currentValue, CompareType.getEnum((String)"<>"));
        }
        return filterItemInfo;
    }

    private static String getConditionId(String condition) {
        if (condition.indexOf(".") > 0) {
            String[] arr = condition.split("\\.");
            StringBuffer tmp = new StringBuffer();
            for (int i = 0; i <= arr.length - 1; ++i) {
                if (i < arr.length - 1) {
                    tmp.append(arr[i]).append(".");
                    continue;
                }
                tmp.append("id");
            }
            return tmp.toString();
        }
        return "id";
    }

    private static String getConditionNumber(String condition) {
        if (condition.indexOf(".") > 0) {
            String[] arr = condition.split("\\.");
            StringBuffer tmp = new StringBuffer();
            for (int i = 0; i <= arr.length - 1; ++i) {
                if (i < arr.length - 1) {
                    tmp.append(arr[i]).append(".");
                    continue;
                }
                tmp.append("number");
            }
            return tmp.toString();
        }
        return "number";
    }

    public static boolean isVarValue(String str) {
        return CommonFilterUtil.isVarValue(str);
    }

    private static Object getVarCurrentValue(Context ctx, Object compareValue) {
        if ("$currentUser$".toString().equals(compareValue.toString())) {
            return CommonQueryUtil.getCurrentUserId(ctx);
        }
        if ("$currentPerson$".toString().equals(compareValue.toString())) {
            return CommonQueryUtil.getCurrentPersonId(ctx);
        }
        if ("$currentOrg$".toString().equals(compareValue.toString())) {
            return ((OrgUnitInfo)ContextUtils.getContextFromSession().get((Object)"CurOU")).getId().toString();
        }
        return null;
    }

    private static Object getVarCurrentValueOfNumber(Context ctx, Object compareValue) {
        if ("$currentUser$".toString().equals(compareValue.toString())) {
            return ContextUtil.getCurrentUserInfo((Context)ctx).getNumber().toString();
        }
        if ("$currentPerson$".toString().equals(compareValue.toString())) {
            String result = "";
            if (ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() != null) {
                result = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getNumber().toString();
            }
            return result;
        }
        if ("$currentOrg$".toString().equals(compareValue.toString())) {
            return ((OrgUnitInfo)ContextUtils.getContextFromSession().get((Object)"CurOU")).getNumber().toString();
        }
        return null;
    }

    private static String getCurrentUserId(Context ctx) {
        return ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
    }

    private static String getCurrentOrgId(Context ctx) {
        return ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
    }

    private static String getCurrentPersonId(Context ctx) {
        String result = "";
        if (ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() != null) {
            result = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        }
        return result;
    }

    private static int getCurrentUserType(Context ctx) {
        return ContextUtil.getCurrentUserInfo((Context)ctx).getType().getValue();
    }

    private static boolean isUseDateFunction(FilterItemInfo aFilterItemInfo) {
        if (aFilterItemInfo.getCompareValue() != null) {
            String compareValue = aFilterItemInfo.getCompareValue().toString();
            if ((compareValue = compareValue.split("\\$")[0]) != null && (compareValue.equalsIgnoreCase("IN_X_DAYS_AFTER") || compareValue.equalsIgnoreCase("IN_X_DAYS_EQUAL") || compareValue.equalsIgnoreCase("IN_X_DAYS_BEFORE") || compareValue.equalsIgnoreCase("X_DAYS_AGO_AFTER") || compareValue.equalsIgnoreCase("X_DAYS_AGO_EQUAL") || compareValue.equalsIgnoreCase("X_DAYS_AGO_BEFORE"))) {
                return true;
            }
        }
        return false;
    }

    private static Date getDateIgnoreTime(Date aDate) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = df.format(aDate) + " 00:00:00";
        return df.parse(dateString);
    }

    public static ArrayList getRowInfos(FilterInfo filterInfo) {
        int size;
        char[] exp;
        int size2;
        ArrayList<RowObject> target = new ArrayList<RowObject>();
        String expression = filterInfo.getMaskString();
        if (StringUtils.isEmpty((String)expression) && (size2 = filterInfo.getFilterItems().size()) > 0) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < size2; ++i) {
                if (i == size2 - 1) {
                    buffer.append("#").append(i);
                    continue;
                }
                buffer.append("#").append(i).append(" AND ");
            }
            expression = buffer.toString();
        }
        if ((exp = (expression = expression + " AND ").toLowerCase().toCharArray()) != null) {
            int length = exp.length;
            StringBuffer leftBracket = new StringBuffer();
            StringBuffer rightBracket = new StringBuffer();
            for (int i = 0; i < length; ++i) {
                RowObject rowObject;
                char c = exp[i];
                if ("(".equalsIgnoreCase(String.valueOf(c))) {
                    leftBracket.append(String.valueOf(c));
                    continue;
                }
                if (")".equalsIgnoreCase(String.valueOf(c))) {
                    rightBracket.append(String.valueOf(c));
                    continue;
                }
                if ("A".equalsIgnoreCase(String.valueOf(c))) {
                    rowObject = new RowObject();
                    rowObject.setLeftBracket(leftBracket.toString());
                    rowObject.setRightBracket(rightBracket.toString());
                    rowObject.setLogic("AND");
                    target.add(rowObject);
                    leftBracket = new StringBuffer();
                    rightBracket = new StringBuffer();
                    continue;
                }
                if (!"O".equalsIgnoreCase(String.valueOf(c))) continue;
                rowObject = new RowObject();
                rowObject.setLeftBracket(leftBracket.toString());
                rowObject.setRightBracket(rightBracket.toString());
                rowObject.setLogic("OR");
                target.add(rowObject);
                leftBracket = new StringBuffer();
                rightBracket = new StringBuffer();
            }
        }
        if ((size = target.size()) > 0) {
            ((RowObject)target.get(size - 1)).setLogic("");
        }
        return target;
    }
}

