/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.commonquery.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.DynQueryException;
import com.kingdee.eas.base.commonquery.app.AbstractUserOrgDynQueryControllerBean;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.log4j.Logger;

public class UserOrgDynQueryControllerBean
extends AbstractUserOrgDynQueryControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.commonquery.app.UserOrgDynQueryControllerBean");

    @Override
    protected void _addBatch(Context ctx, List userIdList, List orgIdList, List dynQueryIdList, String cu) throws BOSException, EASBizException {
        this.deleteUserOrgDynQueryCollection(ctx, userIdList, orgIdList, dynQueryIdList);
        this.insertUserOrgDynQueryList(ctx, userIdList, orgIdList, dynQueryIdList, cu);
    }

    @Override
    protected void _deleteBatch(Context ctx, List userIdList, List orgIdList, List dynQuerySolutionIdList) throws BOSException, EASBizException {
        this.deleteUserOrgDynQueryCollection(ctx, userIdList, orgIdList, dynQuerySolutionIdList);
    }

    private void insertUserOrgDynQueryList(Context ctx, List userIdList, List orgIdList, List dynQueryIdList, String cu) throws BOSException, EASBizException {
        BOSObjectType objectType = this.getBOSType();
        String insertSql = "insert into t_cq_userorgdynquery (fid,fuserid,forgid,fdynqueryid,Fctrlunitid) values(?,?,?,?,?)";
        Connection con = null;
        PreparedStatement state = null;
        try {
            con = this.getConnection(ctx);
            state = con.prepareStatement(insertSql);
            for (int i = userIdList.size() - 1; i >= 0; --i) {
                for (int j = orgIdList.size() - 1; j >= 0; --j) {
                    for (int k = dynQueryIdList.size() - 1; k >= 0; --k) {
                        String id = BOSUuid.create((BOSObjectType)objectType).toString();
                        state.setString(1, id);
                        state.setString(2, userIdList.get(i).toString());
                        state.setString(3, orgIdList.get(j).toString());
                        state.setString(4, dynQueryIdList.get(k).toString());
                        state.setString(5, cu);
                        state.addBatch();
                    }
                }
            }
            state.executeBatch();
        }
        catch (SQLException se) {
            try {
                logger.error((Object)"UserOrgDynQueryControllerBean.insertUserOrgDynQueryList fail", (Throwable)se);
                throw new DynQueryException(DynQueryException.ACCREDIT_FAIL);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(state, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)state, (Connection)con);
    }

    private void deleteUserOrgDynQueryCollection(Context ctx, List userIdList, List orgIdList, List dynQueryIdList) throws BOSException, EASBizException {
        String userIds = ToolUtils.aryToStr((List)userIdList, (boolean)true);
        String orgIds = ToolUtils.aryToStr((List)orgIdList, (boolean)true);
        String dynQueryIds = ToolUtils.aryToStr((List)dynQueryIdList, (boolean)true);
        StringBuffer delSql = new StringBuffer();
        delSql.append("delete from t_cq_userorgdynquery where fuserid in (").append(userIds).append(") and forgid in (").append(orgIds).append(") and fdynqueryid in (").append(dynQueryIds).append(")");
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            SQLUtils.execute((Connection)con, (String)delSql.toString());
        }
        catch (SQLException se) {
            logger.error((Object)"execute deleteUserOrgDynQueryCollection fail", (Throwable)se);
            throw new DynQueryException(DynQueryException.DISACCREDIT_FAIL);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }
}

