/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.commonquery.upgrade;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import org.apache.log4j.Logger;

public class DBConnection {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.commonquery.upgrade.DBConnection");
    public static final String DRIVER_CLASS = "com.kingdee.bos.sql.shell.Driver";
    private String dbType;
    private String host;
    private int port;
    private String dbName;
    private String user;
    private String password;

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public DBConnection() {
    }

    public DBConnection(String dbType, String host, int port, String dbName, String user, String password) {
        this.dbType = dbType;
        this.host = host;
        this.port = port;
        this.dbName = dbName;
        this.user = user;
        this.password = password;
    }

    public String makeUrl() {
        StringBuffer sb = new StringBuffer();
        sb.append("jdbc:ksql:");
        if ("Oracle".equals(this.dbType)) {
            sb.append("oracle.jdbc.driver.OracleDriver:dbtype=oracle:jdbc:oracle:thin:@");
            sb.append(this.host);
            sb.append(":");
            sb.append(this.port);
            sb.append(":");
            sb.append(this.dbName);
        } else if ("DB2".equalsIgnoreCase(this.dbType)) {
            sb.append("com.ibm.db2.jcc.DB2Driver:dbtype=db2:DBSchema=db2inst1:jdbc:db2://");
            sb.append(this.host);
            sb.append(":");
            sb.append(this.port);
            sb.append("/");
            sb.append(this.dbName);
            sb.append(":retrieveMessagesFromServerOnGetMessage=true;");
        } else {
            sb.append("net.sourceforge.jtds.jdbc.Driver:dbtype=mssqlserver:jdbc:jtds:sqlserver://");
            sb.append(this.host);
            sb.append(":");
            sb.append(this.port);
            sb.append(";DatabaseName=");
            sb.append(this.dbName);
            sb.append(";SelectMethod=cursor;Charset=GBK");
        }
        logger.debug((Object)("url:" + sb.toString()));
        return sb.toString();
    }

    public Connection getConnection() {
        try {
            Driver driver = (Driver)Class.forName(DRIVER_CLASS).newInstance();
            DriverManager.registerDriver(driver);
            return DriverManager.getConnection(this.makeUrl(), this.user, this.password);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }
}

